/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VerifyUtil {
    public static boolean verifyNum(String str) {
        return VerifyUtil.verifyNum(str, 0);
    }

    public static boolean verifyNum(String str, int n) {
        if (str != null) {
            String num = n < 2 ? "" : n + "";
            String regDecimal = "^[0-9]*(\\.[0-9]{1," + num + "})";
            String regInt = "^[0-9]*";
            Matcher md = Pattern.compile(regDecimal).matcher(str);
            Matcher mi = Pattern.compile(regInt).matcher(str);
            return md.matches() || mi.matches();
        }
        return false;
    }

    public static String getAppointDigitsDecimal(String decimal, int digits) {
        BigDecimal bd = new BigDecimal(decimal);
        return bd.setScale(digits, 4).toString();
    }

    public static boolean isBlankList(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isBlankMap(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean verifyBookCodePattern(String bookCode) {
        return Pattern.compile("^B[0-9]{12,25}").matcher(bookCode).matches();
    }

    public static boolean isBlankSet(Set<?> set) {
        return set == null || set.isEmpty();
    }

    public static boolean checkIsMobileNum(String num) {
        boolean result = true;
        Pattern p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$");
        Matcher m = p.matcher(num);
        if (StringUtils.isBlank((CharSequence)num) || !m.matches() || num.length() != 11) {
            result = false;
        }
        return result;
    }

    public static boolean checkAllIsMobileNum(String num, String regularExpressions) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{num, regularExpressions})) {
            return false;
        }
        boolean result = true;
        Pattern p = Pattern.compile(regularExpressions);
        Matcher m = p.matcher(num);
        if (StringUtils.isBlank((CharSequence)num) || !m.matches()) {
            result = false;
        }
        return result;
    }

    public static Boolean checkEmail(String email) {
        if (email.matches("^\\w[-\\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\\.)+[A-Za-z]{2,14}$")) {
            return true;
        }
        return false;
    }
}

