/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListMultipartUploadsRequest;
import com.aliyun.oss.model.ListPartsRequest;
import com.aliyun.oss.model.MultipartUpload;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import com.ellabook.entity.ResponseParams;
import com.ellabook.util.Base64Util;
import com.ellabook.util.OSSServer;
import com.ellabook.util.ResponseParamsUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class UploadUtil {
    private static final ResponseParamsUtil responseParamsUtil = new ResponseParamsUtil();
    public static final String OSS_BUCKET_ELLABOOK_PUBLIC = "ellabook-assistant";
    public static final String OSS_KEY_PREFIX_EVENT = "resource/";
    public static final String OSS_BUCKET_ELLABOOK_BOOK = "ellabook-resource";
    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_VIDEO = "video/";
    public static final String OSS_KEY_PREFIX_COURSE_PREVIEW_RESOURCE_VIDEO = "course-video/";
    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_IMG = "img/";
    public static final String OSS_KEY_PREFIX_COURSE_PREVIEW_RESOURCE_IMG = "course-img/";
    public static final Map<String, ProgressEvent> progressEventList = null;

    public String multipartUploadObject(String bucketName, String key, File partFile) {
        String tag = null;
        String uploadId = null;
        int j = 0;
        OSSClient client = OSSServer.getInstance();
        ListMultipartUploadsRequest lmur = new ListMultipartUploadsRequest(bucketName);
        MultipartUploadListing multipartUploadListing = client.listMultipartUploads(lmur);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        for (MultipartUpload multipartUpload : multipartUploadListing.getMultipartUploads()) {
            if (!multipartUpload.getKey().equals(key)) continue;
            uploadId = multipartUpload.getUploadId();
            break;
        }
        if (StringUtils.isEmpty(uploadId)) {
            InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
            InitiateMultipartUploadResult initiateMultipartUploadResult = client.initiateMultipartUpload(initiateMultipartUploadRequest);
            uploadId = initiateMultipartUploadResult.getUploadId();
        } else {
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
            PartListing partListing = client.listParts(listPartsRequest);
            for (PartSummary part : partListing.getParts()) {
                partETags.add(new PartETag(part.getPartNumber(), part.getETag()));
                ++j;
            }
        }
        int partSize = 0x500000;
        int partCount = (int)(partFile.length() / 0x500000L);
        if (partFile.length() % 0x500000L != 0L) {
            ++partCount;
        }
        try {
            for (int i = j; i < partCount; ++i) {
                FileInputStream fis = new FileInputStream(partFile);
                long skipBytes = 0x500000 * i;
                fis.skip(skipBytes);
                long size = 0x500000L < partFile.length() - skipBytes ? 0x500000L : partFile.length() - skipBytes;
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(key);
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream((InputStream)fis);
                uploadPartRequest.setPartSize(size);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = client.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        CompleteMultipartUploadResult completeMultipartUploadResult = client.completeMultipartUpload(completeMultipartUploadRequest);
        tag = completeMultipartUploadResult.getETag();
        return tag;
    }

    public static ResponseParams uploadFileBase64(String file, String type, int size, String bucket, String key) throws IOException {
        try {
            if (StringUtils.isBlank((CharSequence)file)) {
                return responseParamsUtil.fail("10000001", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", "base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20");
            }
            byte[] b = Base64Util.decodeBase64File(file);
            if (size != 0 && b.length > 0x100000 * size) {
                return responseParamsUtil.fail("10000002", "\u6587\u4ef6\u8fc7\u5927\uff01", "base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20");
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(b);
            String suffix = "." + file.substring(file.indexOf(47) + 1, file.indexOf(59));
            if (!StringUtils.isBlank((CharSequence)type) && !type.equals(suffix)) {
                return responseParamsUtil.fail("10000003", "\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u7c7b\u578b\uff01", "base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20");
            }
            key = key + suffix;
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength((long)b.length);
            OSSServer.getInstance().putObject(bucket, key, (InputStream)inputStream, meta);
            String url = OSSServer.ossUrl(bucket, key).split("\\?")[0];
            return responseParamsUtil.success("\u3010\u8c03\u7528\u6210\u529f\u3011", "base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20", url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return responseParamsUtil.fail("base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20");
        }
    }

    public static ResponseParams uploadFile(MultipartFile file, String type, int size, String bucket, String key) throws IOException {
        try {
            if (null == file) {
                return responseParamsUtil.fail("10000001", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", "\u6587\u4ef6\u4e0a\u4f20");
            }
            long fileStreamSize = file.getSize();
            if (size != 0 && fileStreamSize > (long)(0x100000 * size)) {
                return responseParamsUtil.fail("10000002", "\u6587\u4ef6\u8fc7\u5927\uff01", "\u6587\u4ef6\u4e0a\u4f20");
            }
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            if (!StringUtils.isBlank((CharSequence)type) && !type.equals(suffix)) {
                return responseParamsUtil.fail("10000003", "\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u7c7b\u578b\uff01", "base64\u683c\u5f0f\u6587\u4ef6\u4e0a\u4f20");
            }
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(fileStreamSize);
            OSSServer.getInstance().putObject(bucket, key + suffix, file.getInputStream(), meta);
            String url = OSSServer.ossUrl(bucket, key + suffix).split("\\?")[0];
            return responseParamsUtil.success("\u3010\u8c03\u7528\u6210\u529f\u3011", "\u6587\u4ef6\u4e0a\u4f20", url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return responseParamsUtil.fail("\u6587\u4ef6\u4e0a\u4f20");
        }
    }

    public static String uploadAndDeleteFile(String bucket, String filePath, String fileName) {
        File xlsxFile = new File(filePath);
        OSSServer.getInstance().putObject(bucket, fileName, xlsxFile);
        String url = OSSServer.ossUrl(bucket, fileName).split("\\?")[0];
        xlsxFile.delete();
        return url;
    }
}

