/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeUtil.class);
    public static final long ONE_MINUTE_IN_MILLISECONDS = 60000L;
    public static final long ONE_HOUR_IN_MILLISECONDS = 3600000L;
    public static final long ONE_DAY_IN_MILLISECONDS = 86400000L;
    public static final long ONE_DAY_IN_SECONDS = 86400L;
    public static final long ONE_MILLS = 1000L;
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static boolean isSameDay(long sourceTime, long targetTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(sourceTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long sourceTimeZero = calendar.getTimeInMillis();
        calendar.setTimeInMillis(targetTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long targetTimeZero = calendar.getTimeInMillis();
        return sourceTimeZero == targetTimeZero;
    }

    public static boolean isToday(long time) {
        return TimeUtil.isSameDay(System.currentTimeMillis(), time);
    }

    public static int getLogicIntervalDays(long sourceTime, long targetTime) {
        long source0ClockTime = TimeUtil.getZeroClockTime(sourceTime);
        long target0ClockTime = TimeUtil.getZeroClockTime(targetTime);
        return TimeUtil.getRealIntervalDays(source0ClockTime, target0ClockTime);
    }

    public static int getRealIntervalDays(long sourceTime, long targetTime) {
        return (int)TimeUtil.getIntervalTime(sourceTime, targetTime, 86400000L);
    }

    public static long getIntervalTime(long sourceTime, long targetTime, long timeUnit) {
        return (sourceTime - targetTime) / timeUnit;
    }

    public static long getTimeInMillis(long time, int hour, int minute, int second, int milliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
        return calendar.getTimeInMillis();
    }

    public static long getTimeInMillis(int year, int month, int day, int hour, int minute, int second, int milliSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecond);
        return calendar.getTimeInMillis();
    }

    public static long getNowOfMills() {
        return System.currentTimeMillis();
    }

    public static int getNowOfSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int getNowOfMinutes() {
        return TimeUtil.getNowOfSeconds() / 60;
    }

    public static long getTodayTime(int hour, int minute, int second, int milliSecond) {
        return TimeUtil.getTimeInMillis(System.currentTimeMillis(), hour, minute, second, milliSecond);
    }

    public static long getZeroClockTime(long time) {
        return TimeUtil.getTimeInMillis(time, 0, 0, 0, 0);
    }

    public static String getTimeString(long time, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(new Date(time));
    }

    public static long getTimeFromString(String timeStr, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(timeStr).getTime();
        }
        catch (ParseException e) {
            LOGGER.error("", (Throwable)e);
            return Long.MIN_VALUE;
        }
    }

    public static String getLeftTimeString(long leftTime) {
        int minute;
        int hour;
        StringBuilder sb = new StringBuilder();
        int day = (int)(leftTime / 86400000L);
        if (day > 0) {
            sb.append(day).append("\u5929");
            leftTime -= (long)day * 86400000L;
        }
        if ((hour = (int)(leftTime / 3600000L)) > 0 || sb.length() > 0) {
            sb.append(hour).append("\u5c0f\u65f6");
            leftTime -= (long)hour * 3600000L;
        }
        if ((minute = (int)(leftTime / 60000L)) > 0 || sb.length() > 0) {
            sb.append(minute).append("\u5206");
            leftTime -= (long)minute * 60000L;
        }
        sb.append(leftTime / 1000L).append("\u79d2");
        return sb.toString();
    }

    public static boolean isSameMouth(int oldMonth) {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        return month == oldMonth;
    }
}

