/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ellabook.util.redis.RedisServiceUtil;
import com.ellabook.util.redis.RedisZoneEnum;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class RedisUtil {
    public static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, String channelCode, int page, int pageSize) throws Exception {
        String fieldKey = channelCode + (page * pageSize + 1) + "-" + (page * pageSize <= 0 ? pageSize : (page + 1) * pageSize);
        return RedisUtil.getBookPackageDetail(redis, code, fieldKey);
    }

    public static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, int page, int pageSize) throws Exception {
        return RedisUtil.getBookPackageDetail(redis, code, "", page, pageSize);
    }

    private static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, String fieldKey) throws Exception {
        Object obj = redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).opsForHash().get((Object)("BOOKPACKAGE:DETAIL:" + code), (Object)fieldKey);
        return (Map)JSONObject.parseObject((String)((String)obj), Map.class);
    }

    public static void setBookPackageDetail(RedisServiceUtil redis, String code, String channelCode, int page, int pageSize, Object value) throws Exception {
        String fieldKey = channelCode + (page * pageSize + 1) + "-" + (page * pageSize <= 0 ? pageSize : (page + 1) * pageSize);
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).opsForHash().put((Object)("BOOKPACKAGE:DETAIL:" + code), (Object)fieldKey, (Object)JSONObject.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public static void setBookPackageDetail(RedisServiceUtil redis, String code, int page, int pageSize, Object value) throws Exception {
        RedisUtil.setBookPackageDetail(redis, code, "", page, pageSize, value);
    }

    public static void delBookPackageDetail(RedisServiceUtil redis, String code) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).delete((Object)("BOOKPACKAGE:DETAIL:" + code));
    }

    public static void delBookPackageDetail(RedisServiceUtil redis, Set<String> codes) throws Exception {
        HashSet set = new HashSet();
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.stream().forEach(code -> set.add("BOOKPACKAGE:DETAIL:" + code));
        }
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).delete(set);
    }

    public static Map<String, Object> getBookCourseDetail(RedisServiceUtil redis, String courseCode, String resource) throws Exception {
        Object obj = redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).opsForHash().get((Object)("COURSE:DETAIL:" + courseCode), (Object)(resource == null ? "" : resource));
        return (Map)JSONObject.parseObject((String)((String)obj), Map.class);
    }

    public static void setBookCourseDetail(RedisServiceUtil redis, String courseCode, String resource, Object value) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).opsForHash().put((Object)("COURSE:DETAIL:" + courseCode), (Object)resource, (Object)JSONObject.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    public static void delBookCourseDetail(RedisServiceUtil redis, String code) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).delete((Object)("COURSE:DETAIL:" + code));
    }

    public static void delBookCourseDetail(RedisServiceUtil redis, Set<String> courseCodes) throws Exception {
        HashSet set = new HashSet();
        if (CollectionUtils.isNotEmpty(courseCodes)) {
            courseCodes.stream().forEach(code -> set.add("COURSE:DETAIL:" + code));
        }
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).delete(set);
    }
}

