/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.ellabook.util.Base64;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.junit.Test;

public class RSA {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String SIGN_ALGORITHMS256 = "SHA256WithRSA";

    public static String sign(String content, String privateKey, String signtype) {
        String charset = "utf-8";
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = null;
            signature = "RSA256".equals(signtype) ? Signature.getInstance(SIGN_ALGORITHMS256) : Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes(charset));
            byte[] signed = signature.sign();
            return Base64.encode(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean rsaDoCheck(Map<String, Object> params, String sign, String publicKey, String signType) {
        String content = RSA.getSignData(params);
        System.out.println("The content for sign is : " + content.toString());
        System.out.println("The sign is : " + sign);
        return RSA.doCheck(content, sign, publicKey, signType);
    }

    public static boolean doCheck(String content, String sign, String publicKey, String signType) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = Base64.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = "RSA256".equals(signType) ? Signature.getInstance(SIGN_ALGORITHMS256) : Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes("utf-8"));
            boolean bverify = signature.verify(Base64.decode(sign));
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Test
    public void test() {
        String sign = "Y55acwAxqVjCV9wD3NH4L4V5sXvs2oaQHQSRD7LSINjSkCU/wVzZjJyWnGlzHDSebBJ9I4X91CHBCXZMXII9QKFAFlQpsGLw4Eg3ZdDGN7U8N/zxYfvRKsasbp2DrcZtfHIocbKDw0dx7grQlWUEVjApMc+jzW/F62Ulbaf0UBcLd3l5NqIBrL75zNvYAJ+AQ2VZnGUKWzToaxlZTjJKGbqVWlSlGL/uxCNnvB8a2WIm14M/He9RpvCwXA3M58WUWrSgLxWFth6setbbrDWSR0NJ6I+p0voDVnV0VtconIf/rjJ7SBRng9gRwKRk83pxM4YBCJHr45DairJBiJp74w==";
        byte[] b = Base64.decode(sign);
    }

    public static String getSignData(Map<String, Object> params) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if ("sign".equals(key) || "signType".equals(key)) continue;
            String value = (String)params.get(key);
            if (value != null) {
                content.append((i == 0 ? "" : "&") + key + "=" + value);
                continue;
            }
            content.append((i == 0 ? "" : "&") + key + "=");
        }
        return content.toString();
    }

    public static String getNoSortSignData(Map<String, Object> params) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if ("sign".equals(key)) continue;
            String value = (String)params.get(key);
            if (value != null) {
                content.append((i == 0 ? "" : "&") + key + "=" + value);
                continue;
            }
            content.append((i == 0 ? "" : "&") + key + "=");
        }
        return content.toString();
    }
}

