/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;

public class PinYin4jUtils {
    private static Set<String> getPinyin(String src, String split) {
        if (src != null && !src.trim().equalsIgnoreCase("")) {
            char[] srcChar = src.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            String[][] temp = new String[src.length()][];
            for (int i = 0; i < srcChar.length; ++i) {
                char c = srcChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)srcChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(srcChar[i])} : new String[]{""};
            }
            String[] pinyinArray = PinYin4jUtils.Exchange(temp, split);
            HashSet<String> pinyinSet = new HashSet<String>();
            for (int i = 0; i < pinyinArray.length; ++i) {
                pinyinSet.add(pinyinArray[i]);
            }
            return pinyinSet;
        }
        return null;
    }

    private static String[] Exchange(String[][] strJaggedArray, String split) {
        String[][] temp = PinYin4jUtils.DoExchange(strJaggedArray, split);
        return temp[0];
    }

    private static String[][] DoExchange(String[][] strJaggedArray, String split) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newLen = len1 * len2;
            String[] temp = new String[newLen];
            int Index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[Index] = strJaggedArray[0][i] + split + strJaggedArray[1][j];
                    ++Index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return PinYin4jUtils.DoExchange(newArray, split);
        }
        return strJaggedArray;
    }

    public static Set<String> cn2PYInitial(String str) {
        Set<String> pinyin = PinYin4jUtils.getPinyin(str, " ");
        TreeSet<String> result = new TreeSet<String>();
        if (pinyin != null) {
            for (String firstChar : pinyin) {
                String[] split = firstChar.split(" ");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < split.length; ++i) {
                    if (StringUtils.isBlank((CharSequence)split[i].trim())) continue;
                    sb.append(split[i].charAt(0));
                }
                result.add(sb.toString().toUpperCase());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "..424\u5355\u91cd.\u4f59";
        System.out.println(PinYin4jUtils.cn2PYInitial(str));
    }
}

