/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ellabook.entity.PublicParam;
import com.ellabook.entity.RequestParams;
import com.ellabook.exception.EllaBookException;
import com.ellabook.util.datx.City;
import com.ellabook.util.datx.IPv4FormatException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;

public class JsonUtil {
    public static String getContent(RequestParams params) {
        String content = params.getParams().get("content");
        try {
            content = StringUtils.isBlank((String)content) ? "{}" : content;
            JSONObject.parseObject((String)content);
        }
        catch (Exception e1) {
            try {
                content = content.equals("{}") ? "[]" : content;
                JSONObject.parseArray((String)content);
            }
            catch (Exception e2) {
                throw new EllaBookException("Illegal Json String:" + content);
            }
        }
        return content;
    }

    public static String getContentByPutUidAndVersionAndChannelCode(RequestParams params) {
        String content = JsonUtil.getContent(params);
        JSONObject obj = JSONObject.parseObject((String)content);
        String uid = params.getParams().get("uid");
        String channelCode = params.getParams().get("channelCode");
        String v = params.getParams().get("v");
        String platform = params.getParams().get("platform");
        String countryCode = params.getParams().get("countryCode");
        String snCode = params.getParams().get("snCode");
        String language = params.getParams().get("language");
        String siteCode = params.getSiteCode();
        if (StringUtils.isBlank((String)obj.getString("uid"))) {
            obj.put("uid", (Object)uid);
        }
        if (StringUtils.isBlank((String)obj.getString("channelCode"))) {
            obj.put("channelCode", (Object)channelCode);
        }
        if (StringUtils.isBlank((String)obj.getString("version"))) {
            obj.put("version", (Object)v);
        }
        if (StringUtils.isBlank((String)obj.getString("platform"))) {
            obj.put("platform", (Object)platform);
        }
        if (StringUtils.isBlank((String)obj.getString("countryCode"))) {
            obj.put("countryCode", (Object)countryCode);
        }
        if (StringUtils.isBlank((String)obj.getString("snCode"))) {
            obj.put("snCode", (Object)snCode);
        }
        if (StringUtils.isBlank((String)obj.getString("language"))) {
            obj.put("language", (Object)language);
        }
        if (StringUtils.isBlank((String)obj.getString("siteCode"))) {
            obj.put("siteCode", (Object)siteCode);
        }
        PublicParam publicParam = JsonUtil.getPublicParam(params);
        obj.put("publicParam", (Object)publicParam);
        return JSONObject.toJSONString((Object)obj);
    }

    public static String getContentContainsPublicParam(RequestParams params) {
        JSONObject obj = new JSONObject();
        String content = JsonUtil.getContent(params);
        PublicParam publicParam = JsonUtil.getPublicParam(params);
        try {
            obj = JSONObject.parseObject((String)content);
        }
        catch (Exception e) {
            try {
                content = content.equals("{}") ? "[]" : content;
                JSONArray jsonArray = JSONObject.parseArray((String)content);
                obj.put("list", (Object)jsonArray);
            }
            catch (Exception e2) {
                throw new EllaBookException("Illegal Json String:" + content);
            }
        }
        publicParam.setCountry(JsonUtil.countryConvert(params.getIp()));
        publicParam.setRegion(JsonUtil.getRegion(params.getIp()));
        obj.put("ip", (Object)params.getIp());
        obj.put("publicParam", (Object)publicParam);
        obj.put("siteCode", (Object)(StringUtils.isNotBlank((String)publicParam.getSiteCode()) ? publicParam.getSiteCode() : params.getSiteCode()));
        return JSONObject.toJSONString((Object)obj);
    }

    public static PublicParam getPublicParam(RequestParams params) {
        PublicParam publicParam = new PublicParam();
        Map<String, String> map = params.getParams();
        publicParam.setMethod(map.get("method"));
        publicParam.setAppKey(map.get("app_key"));
        publicParam.setFormat(map.get("format"));
        publicParam.setSign(map.get("sign"));
        publicParam.setSignMethod(map.get("sign_method"));
        publicParam.setTimestamp(map.get("timestamp"));
        publicParam.setToken(map.get("token"));
        publicParam.setUid(map.get("uid"));
        publicParam.setVersion(map.get("v"));
        publicParam.setChannelCode(map.get("channelCode"));
        publicParam.setPlatform(map.get("platform"));
        publicParam.setProduct(map.get("product"));
        publicParam.setContent(map.get("content"));
        String countryCode = map.get("countryCode");
        publicParam.setSnCode(map.get("snCode"));
        publicParam.setLanguage(map.get("language"));
        publicParam.setSiteCode(params.getSiteCode());
        countryCode = JsonUtil.countryCodeConvert(countryCode);
        publicParam.setCountryCode(countryCode);
        return publicParam;
    }

    public static String countryCodeConvert(String countryCode) {
        try {
            if (StringUtils.isNotBlank((String)countryCode)) {
                if (!(countryCode = URLEncoder.encode(countryCode, "UTF-8")).startsWith("+")) {
                    countryCode = URLDecoder.decode(countryCode, "UTF-8");
                }
            } else {
                countryCode = "+86";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            countryCode = "+86";
        }
        return countryCode;
    }

    @Test
    public void main() {
        String cityCode = JsonUtil.countryConvert("49.246.255.255");
        System.out.println(cityCode);
    }

    public static String numberConvert(String number) {
        if (number.length() < 4) {
            return number;
        }
        Pattern p2 = Pattern.compile("[0-9]");
        Matcher m = p2.matcher(number.substring(2, number.length() - 2));
        String trim = m.replaceAll("*");
        return number.substring(0, 2) + trim + number.substring(number.length() - 2, number.length());
    }

    public static String countryConvert(String ip) {
        String country = "CN";
        String region = "";
        try {
            City cityUtil = City.newInstance("17monipdb.datx");
            String[] addressNameList = cityUtil.find(ip);
            if (addressNameList.length >= 1) {
                country = JsonUtil.getCountryMap().get(addressNameList[0]);
                if (addressNameList.length >= 2) {
                    region = addressNameList[1];
                }
                if (StringUtils.isNotBlank((String)country)) {
                    if (StringUtils.equalsIgnoreCase((String)country, (String)"CN")) {
                        country = StringUtils.isNotBlank((String)JsonUtil.getRegionMap().get(region)) ? JsonUtil.getRegionMap().get(region) : "CN";
                    }
                } else {
                    country = "CN";
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IPv4FormatException e) {
            e.printStackTrace();
        }
        return country;
    }

    public static String getRegion(String ip) {
        String region = null;
        try {
            City cityUtil = City.newInstance("17monipdb.datx");
            String[] addressNameList = cityUtil.find(ip);
            if (addressNameList.length >= 1) {
                region = addressNameList[1];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IPv4FormatException e) {
            e.printStackTrace();
        }
        return region;
    }

    public static String getKidsToolsContent(RequestParams params) {
        String content = JsonUtil.getContent(params);
        String channelCode = params.getParams().get("channelCode");
        JSONObject obj = JSONObject.parseObject((String)content);
        obj.put("channelCode", (Object)channelCode);
        content = obj.toJSONString();
        return content;
    }

    public static JSONObject dateFormat(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat((Object)obj, (String)JSONObject.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return JSONObject.parseObject((String)s);
    }

    public static JSONArray dateFormatArray(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat((Object)obj, (String)JSONObject.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        return JSONObject.parseArray((String)s);
    }

    public static String output(Object json) {
        String start = "  ";
        String jsonStr = JSONObject.toJSONString((Object)json, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        int level = 0;
        StringBuffer jsonResultStr = new StringBuffer();
        block5: for (int i = 0; i < jsonStr.length(); ++i) {
            int k;
            char piece = jsonStr.charAt(i);
            if (i != 0 && '\n' == jsonResultStr.charAt(jsonResultStr.length() - 1)) {
                for (k = 0; k < level; ++k) {
                    jsonResultStr.append(start);
                }
            }
            switch (piece) {
                case '[': 
                case '{': {
                    jsonResultStr.append(piece + "\n");
                    ++level;
                    continue block5;
                }
                case ',': {
                    jsonResultStr.append(piece + "\n");
                    continue block5;
                }
                case ']': 
                case '}': {
                    jsonResultStr.append("\n");
                    --level;
                    for (k = 0; k < level; ++k) {
                        jsonResultStr.append(start);
                    }
                    jsonResultStr.append(piece);
                    continue block5;
                }
                default: {
                    jsonResultStr.append(piece);
                }
            }
        }
        return jsonResultStr.toString();
    }

    public static Map<String, String> getCountryMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u4e2d\u56fd", "CN");
        map.put("\u7f8e\u56fd", "US");
        map.put("\u963f\u5e03\u54c8\u5179", "US");
        map.put("\u963f\u5bcc\u6c57", "US");
        map.put("\u963f\u5c14\u5df4\u5c3c\u4e9a", "US");
        map.put("\u963f\u5c14\u53ca\u5229\u4e9a", "US");
        map.put("\u5b89\u9053\u5c14", "US");
        map.put("\u5b89\u54e5\u62c9", "US");
        map.put("\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe", "US");
        map.put("\u963f\u6839\u5ef7", "US");
        map.put("\u4e9a\u7f8e\u5c3c\u4e9a", "US");
        map.put("\u6fb3\u5927\u5229\u4e9a", "US");
        map.put("\u5965\u5730\u5229", "US");
        map.put("\u963f\u585e\u62dc\u7586", "US");
        map.put("\u5df4\u54c8\u9a6c", "US");
        map.put("\u5df4\u6797", "US");
        map.put("\u5b5f\u52a0\u62c9\u56fd", "US");
        map.put("\u5df4\u5df4\u591a\u65af", "US");
        map.put("\u767d\u4fc4\u7f57\u65af", "US");
        map.put("\u6bd4\u5229\u65f6", "US");
        map.put("\u4f2f\u5229\u5179", "US");
        map.put("\u8d1d\u5b81", "US");
        map.put("\u4e0d\u4e39", "US");
        map.put("\u73bb\u5229\u7ef4\u4e9a", "US");
        map.put("\u6ce2\u9ed1", "US");
        map.put("\u535a\u8328\u74e6\u7eb3", "US");
        map.put("\u5df4\u897f", "US");
        map.put("\u6587\u83b1", "US");
        map.put("\u4fdd\u52a0\u5229\u4e9a", "US");
        map.put("\u5e03\u57fa\u7eb3\u6cd5\u7d22", "US");
        map.put("\u5e03\u9686\u8fea", "US");
        map.put("\u67ec\u57d4\u5be8", "US");
        map.put("\u5580\u9ea6\u9686", "US");
        map.put("\u52a0\u62ff\u5927", "US");
        map.put("\u4f5b\u5f97\u89d2", "US");
        map.put("\u52a0\u6cf0\u7f57\u5c3c\u4e9a", "US");
        map.put("\u4e2d\u975e\u5171\u548c\u56fd", "US");
        map.put("\u4e4d\u5f97", "US");
        map.put("\u667a\u5229", "US");
        map.put("\u54e5\u4f26\u6bd4\u4e9a", "US");
        map.put("\u79d1\u6469\u7f57", "US");
        map.put("\u521a\u679c\u5171\u548c\u56fd", "US");
        map.put("\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd", "US");
        map.put("\u5e93\u514b\u7fa4\u5c9b", "US");
        map.put("\u54e5\u65af\u8fbe\u9ece\u52a0", "US");
        map.put("\u79d1\u7279\u8fea\u74e6", "US");
        map.put("\u514b\u7f57\u5730\u4e9a", "US");
        map.put("\u53e4\u5df4", "US");
        map.put("\u585e\u6d66\u8def\u65af", "US");
        map.put("\u6377\u514b", "US");
        map.put("\u4e39\u9ea6", "US");
        map.put("\u5409\u5e03\u63d0", "US");
        map.put("\u987f\u6d85\u8328\u514b", "US");
        map.put("\u591a\u7c73\u5c3c\u514b", "US");
        map.put("\u591a\u7c73\u5c3c\u52a0", "US");
        map.put("\u5384\u74dc\u591a\u5c14", "US");
        map.put("\u57c3\u53ca", "US");
        map.put("\u8428\u5c14\u74e6\u591a", "US");
        map.put("\u8d64\u9053\u51e0\u5185\u4e9a", "US");
        map.put("\u5384\u7acb\u7279\u91cc\u4e9a", "US");
        map.put("\u7231\u6c99\u5c3c\u4e9a", "US");
        map.put("\u57c3\u585e\u4fc4\u6bd4\u4e9a", "US");
        map.put("\u6590\u6d4e", "US");
        map.put("\u82ac\u5170", "US");
        map.put("\u6cd5\u56fd", "US");
        map.put("\u52a0\u84ec", "US");
        map.put("\u5188\u6bd4\u4e9a", "US");
        map.put("\u683c\u9c81\u5409\u4e9a", "US");
        map.put("\u5fb7\u56fd", "US");
        map.put("\u52a0\u7eb3", "US");
        map.put("\u5e0c\u814a", "US");
        map.put("\u683c\u6797\u7eb3\u8fbe", "US");
        map.put("\u5371\u5730\u9a6c\u62c9", "US");
        map.put("\u51e0\u5185\u4e9a", "US");
        map.put("\u51e0\u5185\u4e9a\u6bd4\u7ecd", "US");
        map.put("\u572d\u4e9a\u90a3", "US");
        map.put("\u6d77\u5730", "US");
        map.put("\u6d2a\u90fd\u62c9\u65af", "US");
        map.put("\u5308\u7259\u5229", "US");
        map.put("\u51b0\u5c9b", "US");
        map.put("\u5370\u5ea6", "US");
        map.put("\u5370\u5ea6\u5c3c\u897f\u4e9a", "US");
        map.put("\u4f0a\u6717", "US");
        map.put("\u4f0a\u62c9\u514b", "US");
        map.put("\u7231\u5c14\u5170", "US");
        map.put("\u4ee5\u8272\u5217", "US");
        map.put("\u610f\u5927\u5229", "US");
        map.put("\u7259\u4e70\u52a0", "US");
        map.put("\u65e5\u672c", "US");
        map.put("\u7ea6\u65e6", "US");
        map.put("\u54c8\u8428\u514b\u65af\u5766", "US");
        map.put("\u80af\u5c3c\u4e9a", "US");
        map.put("\u57fa\u91cc\u5df4\u65af", "US");
        map.put("\u97e9\u56fd", "US");
        map.put("\u79d1\u7d22\u6c83", "US");
        map.put("\u79d1\u5a01\u7279", "US");
        map.put("\u5409\u5c14\u5409\u65af\u65af\u5766", "US");
        map.put("\u8001\u631d", "US");
        map.put("\u62c9\u8131\u7ef4\u4e9a", "US");
        map.put("\u9ece\u5df4\u5ae9", "US");
        map.put("\u83b1\u7d22\u6258", "US");
        map.put("\u5229\u6bd4\u91cc\u4e9a", "US");
        map.put("\u5229\u6bd4\u4e9a", "US");
        map.put("\u5217\u652f\u6566\u58eb\u767b", "US");
        map.put("\u7acb\u9676\u5b9b", "US");
        map.put("\u5362\u68ee\u5821", "US");
        map.put("\u9a6c\u8fbe\u52a0\u65af\u52a0", "US");
        map.put("\u9a6c\u62c9\u7ef4", "US");
        map.put("\u9a6c\u6765\u897f\u4e9a", "US");
        map.put("\u9a6c\u5c14\u4ee3\u592b", "US");
        map.put("\u9a6c\u8033\u4ed6\u9a91\u58eb\u56e2", "US");
        map.put("\u9a6c\u91cc", "US");
        map.put("\u9a6c\u8033\u4ed6", "US");
        map.put("\u9a6c\u7ecd\u5c14\u7fa4\u5c9b", "US");
        map.put("\u6bdb\u91cc\u5854\u5c3c\u4e9a", "US");
        map.put("\u6bdb\u91cc\u6c42\u65af", "US");
        map.put("\u58a8\u897f\u54e5", "US");
        map.put("\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u8054\u90a6", "US");
        map.put("\u6469\u5c14\u591a\u74e6", "US");
        map.put("\u6469\u7eb3\u54e5", "US");
        map.put("\u8499\u53e4\u56fd", "US");
        map.put("\u9ed1\u5c71", "US");
        map.put("\u6469\u6d1b\u54e5", "US");
        map.put("\u83ab\u6851\u6bd4\u514b", "US");
        map.put("\u7f05\u7538", "US");
        map.put("\u7eb3\u6208\u5c14\u8bfa-\u5361\u62c9\u5df4\u8d6b", "US");
        map.put("\u7eb3\u7c73\u6bd4\u4e9a", "US");
        map.put("\u7459\u9c81", "US");
        map.put("\u5c3c\u6cca\u5c14", "US");
        map.put("\u8377\u5170", "US");
        map.put("\u65b0\u897f\u5170", "US");
        map.put("\u5c3c\u52a0\u62c9\u74dc", "US");
        map.put("\u5c3c\u65e5\u5c14", "US");
        map.put("\u5c3c\u65e5\u5229\u4e9a", "US");
        map.put("\u7ebd\u57c3\uff08\u65b0\u897f\u5170\uff09", "US");
        map.put("\u5317\u585e\u6d66\u8def\u65af", "US");
        map.put("\u5317\u9a6c\u5176\u987f", "US");
        map.put("\u632a\u5a01", "US");
        map.put("\u963f\u66fc", "US");
        map.put("\u5df4\u57fa\u65af\u5766", "US");
        map.put("\u5e15\u52b3", "US");
        map.put("\u5df4\u52d2\u65af\u5766", "US");
        map.put("\u5df4\u62ff\u9a6c", "US");
        map.put("\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a", "US");
        map.put("\u5df4\u62c9\u572d", "US");
        map.put("\u671d\u9c9c", "US");
        map.put("\u79d8\u9c81", "US");
        map.put("\u83f2\u5f8b\u5bbe", "US");
        map.put("\u6ce2\u5170", "US");
        map.put("\u8461\u8404\u7259", "US");
        map.put("\u5fb7\u6d85\u65af\u7279\u6cb3\u6cbf\u5cb8", "US");
        map.put("\u90a6\u7279\u5170", "US");
        map.put("\u7f57\u9a6c\u5c3c\u4e9a", "US");
        map.put("\u4fc4\u7f57\u65af", "US");
        map.put("\u5362\u65fa\u8fbe", "US");
        map.put("\u5361\u5854\u5c14", "US");
        map.put("\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af", "US");
        map.put("\u5723\u5362\u897f\u4e9a", "US");
        map.put("\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af", "US");
        map.put("\u8428\u6469\u4e9a", "US");
        map.put("\u5723\u9a6c\u529b\u8bfa", "US");
        map.put("\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4", "US");
        map.put("\u6c99\u7279\u963f\u62c9\u4f2f", "US");
        map.put("\u585e\u5185\u52a0\u5c14", "US");
        map.put("\u585e\u5c14\u7ef4\u4e9a", "US");
        map.put("\u585e\u820c\u5c14", "US");
        map.put("\u585e\u62c9\u5229\u6602", "US");
        map.put("\u65b0\u52a0\u5761", "US");
        map.put("\u65af\u6d1b\u4f10\u514b", "US");
        map.put("\u65af\u6d1b\u6587\u5c3c\u4e9a", "US");
        map.put("\u6240\u7f57\u95e8\u7fa4\u5c9b", "US");
        map.put("\u7d22\u9a6c\u91cc", "US");
        map.put("\u7d22\u9a6c\u91cc\u5170", "US");
        map.put("\u5357\u975e", "US");
        map.put("\u5357\u5965\u585e\u68af", "US");
        map.put("\u5357\u82cf\u4e39", "US");
        map.put("\u897f\u73ed\u7259", "US");
        map.put("\u65af\u91cc\u5170\u5361", "US");
        map.put("\u82cf\u4e39", "US");
        map.put("\u82cf\u91cc\u5357", "US");
        map.put("\u65af\u5a01\u58eb\u5170", "US");
        map.put("\u745e\u5178", "US");
        map.put("\u745e\u58eb", "US");
        map.put("\u53d9\u5229\u4e9a", "US");
        map.put("\u5854\u5409\u514b\u65af\u5766", "US");
        map.put("\u5766\u6851\u5c3c\u4e9a", "US");
        map.put("\u6cf0\u56fd", "US");
        map.put("\u4e1c\u5e1d\u6c76", "US");
        map.put("\u591a\u54e5", "US");
        map.put("\u6c64\u52a0", "US");
        map.put("\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5", "US");
        map.put("\u7a81\u5c3c\u65af", "US");
        map.put("\u571f\u8033\u5176", "US");
        map.put("\u571f\u5e93\u66fc\u65af\u5766", "US");
        map.put("\u56fe\u74e6\u5362", "US");
        map.put("\u4e4c\u5e72\u8fbe", "US");
        map.put("\u4e4c\u514b\u5170", "US");
        map.put("\u963f\u8054\u914b", "US");
        map.put("\u82f1\u56fd", "US");
        map.put("\u4e4c\u62c9\u572d", "US");
        map.put("\u4e4c\u5179\u522b\u514b\u65af\u5766", "US");
        map.put("\u74e6\u52aa\u963f\u56fe", "US");
        map.put("\u68b5\u8482\u5188", "US");
        map.put("\u59d4\u5185\u745e\u62c9", "US");
        map.put("\u8d8a\u5357", "US");
        map.put("\u897f\u6492\u54c8\u62c9", "US");
        map.put("\u4e5f\u95e8", "US");
        map.put("\u8d5e\u6bd4\u4e9a", "US");
        map.put("\u6d25\u5df4\u5e03\u97e6", "US");
        return map;
    }

    public static Map<String, String> getRegionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\u9999\u6e2f", "HK");
        map.put("\u6fb3\u95e8", "MC");
        map.put("\u53f0\u6e7e", "TW");
        return map;
    }
}

