/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.ellabook.util.BigDecimalUtil;
import com.ellabook.util.FileUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.util.IOUtils;

public class ImgTools {
    public static byte[] compressUnderSize(byte[] srcImgData, long maxSize, long maxWidth, long maxHeight) {
        byte[] imgData = Arrays.copyOf(srcImgData, srcImgData.length);
        try {
            byte[] compress = ImgTools.compress(imgData, maxSize, maxWidth, maxHeight);
            return compress;
        }
        catch (IOException e) {
            throw new IllegalStateException("\u538b\u7f29\u56fe\u7247\u8fc7\u7a0b\u4e2d\u51fa\u9519\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7ba1\u7406\u5458\uff01", e);
        }
    }

    public static byte[] compress(byte[] srcImgData, long maxSize, long maxWidth, long maxHeight) throws IOException {
        BufferedImage bi = ImageIO.read(new ByteArrayInputStream(srcImgData));
        int width = bi.getWidth();
        int height = bi.getHeight();
        double scale = Double.min((double)maxSize * 1.0 / (double)srcImgData.length, Double.min((double)maxWidth * 1.0 / (double)width, (double)maxHeight * 1.0 / (double)height));
        scale = ImgTools.getScale(maxWidth, maxHeight, width, height, scale, 1.0);
        width = (int)((double)bi.getWidth() * scale);
        height = (int)((double)bi.getHeight() * scale);
        if (0.0 < scale && scale < 1.0 && width > 0 && height > 0) {
            Image image = bi.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.setColor(Color.RED);
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)tag, "JPEG", bOut);
            srcImgData = bOut.toByteArray();
            if ((long)srcImgData.length > maxSize || (long)width > maxWidth || (long)height > maxHeight) {
                srcImgData = ImgTools.compress(srcImgData, maxSize, maxWidth, maxHeight);
            }
        }
        return srcImgData;
    }

    private static double getScale(long maxWidth, long maxHeight, int width, int height, double scale, double prefixScale) {
        int w = (int)((double)width * scale);
        int h = (int)((double)height * scale);
        if (scale < 1.0 && scale > 0.0 && (long)w < maxWidth && (long)h < maxHeight) {
            prefixScale = scale;
            scale = 1.1 * scale;
            scale = ImgTools.getScale(maxWidth, maxHeight, width, height, scale, prefixScale);
        } else {
            scale = prefixScale;
        }
        return scale;
    }

    public static void compressImg(String path, long maxSize, long maxWidth, long maxHeight) throws Exception {
        List<File> imgFileList = FileUtil.getImgFileList(path);
        if (!CollectionUtils.isEmpty(imgFileList)) {
            for (File next : imgFileList) {
                byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(next));
                byte[] data = ImgTools.compressUnderSize(bytes, maxSize, maxWidth, maxHeight);
                FileUtils.writeByteArrayToFile((File)next, (byte[])data);
            }
        }
    }

    public static void compressImgByThumbnails(String path, long maxSize, long maxWidth, long maxHeight) throws Exception {
        List<File> imgFileList = FileUtil.getImgFileList(path);
        if (!CollectionUtils.isEmpty(imgFileList)) {
            for (File next : imgFileList) {
                System.out.println("---" + next.getAbsolutePath());
                byte[] bytes1 = IOUtils.toByteArray((InputStream)new FileInputStream(next));
                byte[] bytes = Arrays.copyOf(bytes1, bytes1.length);
                BufferedImage bi = ImageIO.read(new ByteArrayInputStream(bytes));
                int width = bi.getWidth();
                int height = bi.getHeight();
                if ((long)bytes.length <= maxSize && (long)width <= maxWidth && (long)height <= maxHeight) continue;
                double scale = Double.min((double)maxWidth * 1.0 / (double)width, (double)maxHeight * 1.0 / (double)height);
                scale = scale > 1.0 ? 1.0 : scale;
                ImgTools.thumbnails(next, bytes, maxSize, maxWidth, maxHeight, scale);
            }
        }
    }

    private static void thumbnails(File next, byte[] bytes, long maxSize, long maxWidth, long maxHeight, double scale) throws IOException {
        boolean qualityCompress = false;
        boolean sizeCompress = false;
        boolean sizeIncrease = false;
        if (scale < 1.0) {
            sizeCompress = true;
        }
        if ((long)bytes.length > maxSize) {
            qualityCompress = true;
        }
        System.out.println("\u6e90\u6587\u4ef6\u521d\u59cb\u5927\u5c0f\uff1a" + next.getName() + ": " + BigDecimalUtil.round((double)next.length() / 1048576.0, 4) + "M");
        Thumbnails.of((File[])new File[]{next}).scale(scale).outputQuality(1.0f).toFile(next);
        System.out.println("\u7b2c\u4e00\u6b21\u538b\u7f29\u5927\u5c0f\uff1a" + next.getName() + ": " + BigDecimalUtil.round((double)next.length() / 1048576.0, 4) + "M");
        byte[] bytes1 = IOUtils.toByteArray((InputStream)new FileInputStream(next));
        if ((long)bytes1.length <= maxSize) {
            return;
        }
        if (bytes.length <= bytes1.length) {
            byte[] data = ImgTools.compressUnderSize(bytes, maxSize, maxWidth, maxHeight);
            FileUtils.writeByteArrayToFile((File)next, (byte[])data);
            return;
        }
        if (qualityCompress) {
            int flag = (long)bytes.length > maxSize ? 1 : ((long)bytes.length < maxSize ? -1 : 0);
            ImgTools.compress(next, maxSize, scale, 0.0, 1.0, flag, sizeIncrease, sizeCompress);
        }
    }

    private static void compress(File next, long maxSize, double scale, double start, double end, int flag, boolean sizeIncrease, boolean sizeCompress) throws IOException {
        double outputQuality = 1.0;
        outputQuality = sizeCompress ? (outputQuality - 0.001) * 0.99 : (start + end) / 2.0;
        if (flag == 1) {
            end = (start + end) / 2.0;
        } else if (flag == -1) {
            start = (start + end) / 2.0;
        } else {
            return;
        }
        if (sizeIncrease) {
            scale *= 0.99;
            outputQuality = 1.0;
        }
        Thumbnails.of((File[])new File[]{next}).scale(scale).outputQuality(outputQuality).toFile(next);
        byte[] bytes1 = IOUtils.toByteArray((InputStream)new FileInputStream(next));
        long length = bytes1.length;
        System.out.println("\u7b2cn\u6b21\u538b\u7f29--------scale:" + BigDecimalUtil.round(scale, 4) + "---length:" + BigDecimalUtil.round((double)length / 1048576.0, 4) + "M---outputQuality:" + outputQuality);
        if (scale < 1.0 && length < maxSize) {
            return;
        }
        if (flag == 1 && length > maxSize) {
            ImgTools.compress(next, maxSize, scale, start, end, 1, sizeIncrease, sizeCompress);
        }
        if (flag == 1 && length < maxSize) {
            ImgTools.compress(next, maxSize, scale, start, end, -1, sizeIncrease, sizeCompress);
        }
        if (flag == -1 && length > maxSize) {
            Thumbnails.of((File[])new File[]{next}).scale(scale).outputQuality(outputQuality).toFile(next);
            ImgTools.compress(next, maxSize, scale, start, end, 0, sizeIncrease, sizeCompress);
        }
        if (flag == -1 && length < maxSize) {
            ImgTools.compress(next, maxSize, scale, start, end, -1, sizeIncrease, sizeCompress);
        }
    }

    public static void compressImgKeepTranslucent(String path, long maxWidth, long maxHeight) throws Exception {
        List<File> imgFileList = FileUtil.getImgFileList(path);
        if (!CollectionUtils.isEmpty(imgFileList)) {
            for (File next : imgFileList) {
                ImgTools.compressKeepTranslucent(next, next, maxWidth, maxHeight);
            }
        }
    }

    public static void compressKeepTranslucent(File fromFile, File toFile, long outputMaxWidth, long outputMaxHeight) {
        try {
            double rate;
            BufferedImage sourceBufferImage = ImageIO.read(fromFile);
            int width = sourceBufferImage.getWidth(null);
            int height = sourceBufferImage.getHeight(null);
            double widthRate = (double)outputMaxWidth * 1.0 / (double)width;
            double heightRate = (double)outputMaxHeight * 1.0 / (double)height;
            double d = rate = widthRate < heightRate ? widthRate : heightRate;
            if (rate < 1.0) {
                width = (int)((double)sourceBufferImage.getWidth(null) * rate);
                height = (int)((double)sourceBufferImage.getHeight(null) * rate);
            }
            Image image = sourceBufferImage.getScaledInstance(width, height, 4);
            BufferedImage reSizeBufferedImage = new BufferedImage(width, height, 6);
            Graphics2D g2d = reSizeBufferedImage.createGraphics();
            reSizeBufferedImage = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            g2d.dispose();
            g2d = reSizeBufferedImage.createGraphics();
            g2d.drawImage(image, 0, 0, null);
            g2d.dispose();
            BufferedImage compressedBufferedImage = new BufferedImage(width, height, 9);
            g2d = compressedBufferedImage.createGraphics();
            g2d.drawImage((Image)reSizeBufferedImage, 0, 0, null);
            int[] resultPixel = new int[width * height];
            int[] reSizePixel = new int[width * height];
            int[] compressedPixel = new int[width * height];
            reSizePixel = reSizeBufferedImage.getRGB(0, 0, width, height, reSizePixel, 0, width);
            compressedPixel = compressedBufferedImage.getRGB(0, 0, width, height, compressedPixel, 0, width);
            for (int i = 0; i < compressedPixel.length; ++i) {
                resultPixel[i] = reSizePixel[i] == 0 ? reSizePixel[i] : compressedPixel[i];
            }
            BufferedImage resultBufferedImage = new BufferedImage(width, height, 6);
            resultBufferedImage.setRGB(0, 0, width, height, resultPixel, 0, width);
            g2d = resultBufferedImage.createGraphics();
            g2d.drawImage((Image)resultBufferedImage, 0, 0, null);
            g2d.dispose();
            ImageIO.write((RenderedImage)resultBufferedImage, "png", toFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

