/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectUtil {
    private static Logger log = LoggerFactory.getLogger(HttpConnectUtil.class);

    public static Map<String, String> getConnectionXmlResponse(String url, TreeMap<String, String> map, String method) {
        Map<String, String> result = null;
        String xml = HttpConnectUtil.mapToXml(map);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            if (map.size() != 0) {
                OutputStream os = connection.getOutputStream();
                os.write(xml.getBytes("utf-8"));
                os.close();
            } else {
                connection.connect();
            }
            InputStream is = connection.getInputStream();
            String xmlResult = HttpConnectUtil.inputStreamToString(is);
            result = HttpConnectUtil.xmlToMap(xmlResult);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getConnectionFromBody(String url, Object body, String method) {
        String result = "";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            if (null != body && body.toString().length() != 0) {
                OutputStream os = connection.getOutputStream();
                os.write(body.toString().getBytes("utf-8"));
                os.close();
            } else {
                connection.connect();
            }
            InputStream is = connection.getInputStream();
            result = HttpConnectUtil.inputStreamToString(is);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String inputStreamToString(InputStream is) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader reader = new InputStreamReader(is, "utf-8");
            BufferedReader br = new BufferedReader(reader);
            String str = "";
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            log.debug("\u8f93\u5165\u6d41\u89e3\u6790\u7ed3\u679c:" + sb);
            br.close();
            reader.close();
            is.close();
            is = null;
        }
        catch (UnsupportedEncodingException e) {
            log.debug("\u8f93\u5165\u6d41\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            e.printStackTrace();
        }
        catch (IOException e) {
            log.debug("\u5b57\u7b26\u6d41\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getConnectionJsonResponse(String url, Map<String, Object> paramMap, String method) {
        JSONObject json = null;
        String connectURL = HttpConnectUtil.createURLWithParam(url, paramMap);
        try {
            URL getUrl = new URL(connectURL);
            HttpURLConnection conn = (HttpURLConnection)getUrl.openConnection();
            conn.setRequestMethod(method);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.connect();
            InputStream is = conn.getInputStream();
            int size = is.available();
            byte[] b = new byte[size];
            is.read(b);
            String message = new String(b, "utf-8");
            json = (JSONObject)JSON.parse((String)message);
            log.debug("return json:" + json.toString());
        }
        catch (MalformedURLException e) {
            log.error("\u83b7\u53d6openid\u5931\u8d25 : " + e.getMessage());
        }
        catch (IOException e) {
            log.error("getOpenId\u8fde\u63a5\u6253\u5f00\u5931\u8d25: " + e.getMessage());
        }
        return json.toString();
    }

    public static String createURLWithParam(String url, Map<String, Object> paramMap) {
        StringBuffer sb = new StringBuffer(url).append("?");
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String mapToXml(Map<String, String> map) {
        StringBuffer xml = new StringBuffer("<xml>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xml.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static Map<String, String> xmlToMap(String xml) {
        if (StringUtils.isEmpty((CharSequence)(xml = xml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"")))) {
            return null;
        }
        Map<String, String> map = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("utf-8"));
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)in);
            Element root = doc.getRootElement();
            map = HttpConnectUtil.parseXML(root, new HashMap<String, String>());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return map;
    }

    private static Map<String, String> parseXML(Element ele, Map<String, String> map) {
        Iterator i = ele.elementIterator();
        while (i.hasNext()) {
            Element node = (Element)i.next();
            if (node.attributes() != null && node.attributes().size() > 0) {
                Iterator j = node.attributeIterator();
                while (j.hasNext()) {
                    Attribute item = (Attribute)j.next();
                    map.put(item.getName(), item.getValue());
                }
            }
            if (node.getText().length() > 0) {
                map.put(node.getName(), node.getText());
            }
            if (!node.elementIterator().hasNext()) continue;
            HttpConnectUtil.parseXML(node, map);
        }
        return map;
    }

    public static String createWechatSign(TreeMap<String, String> map, String key) {
        StringBuffer signBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            signBuffer.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        signBuffer.append("key=").append(key);
        return DigestUtils.md5Hex((String)signBuffer.toString()).toUpperCase();
    }
}

