/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import com.ellabook.entity.home.ExcelFile;
import com.ellabook.entity.home.ExcelSheet;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static boolean createExcelFile(String filePath, ExcelFile excelFile) {
        try {
            FileOutputStream os = new FileOutputStream(filePath);
            XSSFWorkbook workbook = new XSSFWorkbook();
            for (int i = 0; i < excelFile.getSize(); ++i) {
                ExcelSheet excelsheet = excelFile.get(i);
                List<Map<String, Object>> content = excelsheet.getContent();
                Map<String, Object> title = excelsheet.getTitle();
                XSSFSheet sheet = workbook.createSheet(excelsheet.getSheetName());
                XSSFRow row = sheet.createRow(0);
                int colNum = 0;
                for (String titleKey : title.keySet()) {
                    row.createCell(colNum++).setCellValue(title.get(titleKey).toString());
                }
                int rouNum = 1;
                for (Map<String, Object> rowMap : content) {
                    row = sheet.createRow(rouNum++);
                    colNum = 0;
                    for (String key : title.keySet()) {
                        row.createCell(colNum++).setCellValue(rowMap.get(key).toString());
                    }
                }
            }
            workbook.write((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
        }
        return true;
    }
}

