/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

public class CompressUtil {
    @Test
    public void testUncompressZip() {
        File file = new File("D:/TT/rt.txt.zip");
        System.out.println(file.getParentFile().getPath());
        String temp = "D:/TT/";
        try {
            CompressUtil.uncompressZip(file, temp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void uncompressZip(File storeFile, String tempPath) throws Exception {
        File file = storeFile;
        String temp = tempPath;
        FileInputStream fis = null;
        ZipInputStream zins = null;
        try {
            fis = new FileInputStream(file);
            zins = new ZipInputStream(fis);
            ZipEntry ze = null;
            byte[] ch = new byte[256];
            while ((ze = zins.getNextEntry()) != null) {
                int i;
                File zfile = new File(temp + "/" + ze.getName());
                File fpath = new File(zfile.getParentFile().getPath());
                if (ze.isDirectory()) {
                    if (!zfile.exists()) {
                        zfile.mkdirs();
                    }
                    zins.closeEntry();
                    continue;
                }
                if (!fpath.exists()) {
                    fpath.mkdirs();
                }
                FileOutputStream fouts = new FileOutputStream(zfile);
                while ((i = zins.read(ch)) != -1) {
                    fouts.write(ch, 0, i);
                }
                zins.closeEntry();
                fouts.close();
            }
            fis.close();
            zins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
            throw new RuntimeException("\u6587\u4ef6" + file.toString() + "\u89e3\u538b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.toString());
        }
    }

    @Test
    public void testTarFile() {
        String filePath = "D:/TT/";
        String[] fileName = new String[]{"ss.txt", "st.txt"};
        String tarName = "all.zip";
        try {
            CompressUtil.tarFile(filePath, fileName, tarName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String tarFile(String filePath, String[] fileName, String tarName) throws Exception {
        String[] filenames = fileName;
        byte[] buf = new byte[1024];
        String outFilename = tarName;
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(filePath + File.separator + outFilename));
        for (int i = 0; i < filenames.length; ++i) {
            FileInputStream in = new FileInputStream(filePath + File.separator + filenames[i]);
            out.putNextEntry(new ZipEntry(filenames[i]));
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        out.close();
        return filePath;
    }

    @Test
    public void testZipWithPaw() throws IOException {
        String zipFile = "D:/TT/st.txt.zip";
        String filePath = "D:/TT/";
        CompressUtil.zipWithPaw(zipFile, filePath);
    }

    public static String zipWithPaw(String zipfile, String filePath) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(zipfile);
            File folderToAdd = new File(filePath);
            String pawd = "123456";
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(99);
            parameters.setAesKeyStrength(3);
            parameters.setPassword(pawd);
            zipFile.addFolder(folderToAdd, parameters);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        return zipfile;
    }

    @Test
    public void testZip() throws IOException {
        CompressUtil.zip("E:\\teach\\123", "E:\\teach\\", true, null);
    }

    public static String zip(String src) throws IOException {
        return CompressUtil.zip(src, null);
    }

    public static String zip(String src, String passwd) throws IOException {
        return CompressUtil.zip(src, null, passwd);
    }

    public static String zip(String src, String dest, String passwd) throws IOException {
        return CompressUtil.zip(src, dest, true, passwd);
    }

    public static String zip(String src, String dest, boolean isCreateDir, String passwd) throws IOException {
        File srcFile = new File(src);
        dest = CompressUtil.buildDestinationZipFilePath(srcFile, dest);
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        if (!StringUtils.isEmpty((CharSequence)passwd)) {
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(0);
            parameters.setPassword(passwd.toCharArray());
        }
        try {
            ZipFile zipFile = new ZipFile(dest);
            if (srcFile.isDirectory()) {
                if (!isCreateDir) {
                    File[] subFiles = srcFile.listFiles();
                    ArrayList temp = new ArrayList();
                    Collections.addAll(temp, subFiles);
                    zipFile.addFiles(temp, parameters);
                    return dest;
                }
                zipFile.addFolder(srcFile, parameters);
            } else {
                zipFile.addFile(srcFile, parameters);
            }
            return dest;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return src;
        }
    }

    private static String buildDestinationZipFilePath(File srcFile, String destParam) {
        if (StringUtils.isEmpty((CharSequence)destParam)) {
            if (srcFile.isDirectory()) {
                destParam = srcFile.getParent() + File.separator + srcFile.getName() + ".zip";
            } else {
                String fileName = srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = srcFile.getParent() + File.separator + fileName + ".zip";
            }
        } else {
            CompressUtil.createDestDirectoryIfNecessary(destParam);
            if (destParam.endsWith(File.separator)) {
                String fileName = "";
                fileName = srcFile.isDirectory() ? srcFile.getName() : srcFile.getName().substring(0, srcFile.getName().lastIndexOf("."));
                destParam = destParam + fileName + ".zip";
            }
        }
        return destParam;
    }

    private static void createDestDirectoryIfNecessary(String destParam) {
        File destDir = null;
        destDir = destParam.endsWith(File.separator) ? new File(destParam) : new File(destParam.substring(0, destParam.lastIndexOf(File.separator)));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
    }
}

