/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.analysis.dto.KeyValDataDTO;
import com.ellabook.entity.analysis.vo.TimeSlotDataVO;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class MongodbDaoBaseTemplate {
    public static String DATE_DAY_PATTERN = "yyyyMMdd";
    public static String EVENT_TIME_PATTERN = "yyyyMMddHHmmss";
    public static String EVENT_MILLIS_TIME_PATTERN = "yyyyMMddHHmmssSSS";
    protected String COLLECTION_NAME;
    protected String uidKey;
    protected String timeKey;
    @Autowired
    protected MongoTemplate mongoTemplate;

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    protected List<BasicDBObject> getGroupAggregationList(String startTime, String endTime, boolean containsEnd, boolean in, Collection<String> ids, BasicDBObject groupFields) {
        boolean noMatchDate = StringUtils.isBlank((String)startTime) && StringUtils.isBlank((String)endTime);
        BasicDBObject match = new BasicDBObject("$match", (Object)this.getTimeUidMatchObj(startTime, endTime, containsEnd, in, ids));
        BasicDBObject group = new BasicDBObject("$group", (Object)groupFields);
        return noMatchDate ? Arrays.asList(group) : Arrays.asList(match, group);
    }

    protected BasicDBObject getTimeUidMatchObj(String startTime, String endTime, boolean containsEnd, boolean in, Collection<String> ids) {
        BasicDBObject matchObj = this.timeMatchObj(startTime, endTime, containsEnd);
        matchObj.put((Object)this.uidKey, (Object)this.uidMatchObj(in, ids));
        return matchObj;
    }

    protected BasicDBObject timeMatchObj(String startTime, String endTime, boolean containsEnd) {
        return new BasicDBObject(this.timeKey, StringUtils.equalsIgnoreCase((String)(startTime = this.getDay(startTime)), (String)(endTime = this.getDay(endTime))) ? this.objForTimeEq(startTime) : new BasicDBObject("$gte", (Object)startTime).append(this.getLteOrLt(containsEnd), (Object)endTime));
    }

    protected String getLteOrLt(boolean contains) {
        return contains ? "$lte" : "$lt";
    }

    protected BasicDBObject uidMatchObj(boolean in, Collection<String> ids) {
        return in ? new BasicDBObject("$in", ids) : new BasicDBObject("$nin", CollectionUtils.isEmpty(ids) ? Arrays.asList(null, "") : ids);
    }

    protected String getDay(String day) {
        return StringUtils.replace((String)day, (String)"-", (String)"");
    }

    protected Object objForTimeEq(String startTime) {
        return startTime;
    }

    protected JSONArray getData(BasicDBList dbList, String dataKey) {
        for (Object result : dbList) {
            if (result == null) continue;
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)result.toString());
                return jsonObject.getJSONArray(dataKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new JSONArray();
    }

    protected <T> List<T> getListData(List dbList, Class<T> clazz) {
        ArrayList<Object> rs = new ArrayList<Object>();
        for (Object result : dbList) {
            if (result == null) continue;
            try {
                Object t = JSONObject.parseObject((String)result.toString(), clazz);
                rs.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rs;
    }

    protected List getListDataForGroupId(List dbList) {
        List<KeyValDataDTO> listData = this.getListData(dbList, KeyValDataDTO.class);
        ArrayList<Object> list = new ArrayList<Object>();
        for (KeyValDataDTO item : listData) {
            list.add(item.getId());
        }
        return list;
    }

    protected BasicDBList aggregation(List<BasicDBObject> list, String collectionName) {
        try {
            Cursor dbCursor = this.getCursor(list, collectionName);
            BasicDBList dbList = new BasicDBList();
            while (dbCursor.hasNext()) {
                DBObject dbObject = (DBObject)dbCursor.next();
                dbList.add((Object)dbObject);
            }
            return dbList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new BasicDBList();
        }
    }

    protected Set aggregationByKey(List<BasicDBObject> list, String keyName) {
        try {
            Cursor dbCursor = this.getCursor(list, this.COLLECTION_NAME);
            HashSet<Object> keyList = new HashSet<Object>();
            while (dbCursor.hasNext()) {
                DBObject dbObject = (DBObject)dbCursor.next();
                Object keyVal = dbObject.get(keyName);
                keyList.add(keyVal);
            }
            return keyList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet();
        }
    }

    protected Set<String> aggregationByKeyForColl(List<BasicDBObject> list, String keyName) {
        try {
            Cursor dbCursor = this.getCursor(list, this.COLLECTION_NAME);
            HashSet<String> keyList = new HashSet<String>();
            while (dbCursor.hasNext()) {
                DBObject dbObject = (DBObject)dbCursor.next();
                BasicDBList arr = (BasicDBList)dbObject.get(keyName);
                keyList.addAll((Collection<String>)arr);
            }
            return keyList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    protected Set<String> aggregationForGroupId(List<BasicDBObject> list) {
        return this.aggregationByKey(list, "_id");
    }

    private Cursor getCursor(List<BasicDBObject> list, String collectionName) {
        AggregationOptions build = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).batchSize(Integer.valueOf(5000)).outputMode(AggregationOptions.OutputMode.CURSOR).build();
        return this.mongoTemplate.getCollection(collectionName).aggregate(list, build);
    }

    protected Query getQueryByParamMap(Map<String, Object> paramMap) {
        Query query = new Query();
        if (paramMap != null) {
            Criteria criteria = new Criteria();
            for (Map.Entry<String, Object> kv : paramMap.entrySet()) {
                String key = kv.getKey();
                Object value = kv.getValue();
                if (key == null || value == null) continue;
                criteria.and(key).is(kv.getValue());
            }
            query.addCriteria((CriteriaDefinition)criteria);
        }
        return query;
    }

    protected Document getCmd(String mapFunction, String reduceFunction, Document match) {
        Document command = new Document();
        command.put("mapreduce", (Object)this.COLLECTION_NAME);
        command.put("query", (Object)match);
        command.put("map", (Object)mapFunction);
        command.put("reduce", (Object)reduceFunction);
        command.put("out", (Object)new Document("inline", (Object)1));
        return command;
    }

    protected List<TimeSlotDataVO> countTimeGroupActiveUser(boolean isDay, Document match) {
        String reduceFunction;
        String mapFunction = "function() {emit({uid:this.uid,time:this." + this.timeKey + ".substring" + this.getGroupCodeVal(isDay) + "}, null); } ";
        Document document = this.runCommand(this.getCmd(mapFunction, reduceFunction = "function (key, values) { return null; }", match));
        List results = (List)document.get((Object)"results", List.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Map<String, Integer> map = results.stream().collect(Collectors.groupingBy(o -> {
                Document id = (Document)o.get((Object)"_id");
                String time = id.getString((Object)"time");
                return time;
            }, Collectors.summingInt(o -> 1)));
            ArrayList<TimeSlotDataVO> list = new ArrayList<TimeSlotDataVO>();
            for (Map.Entry<String, Integer> kv : map.entrySet()) {
                list.add(new TimeSlotDataVO(kv.getKey(), new BigDecimal(kv.getValue())));
            }
            return list;
        }
        return new ArrayList<TimeSlotDataVO>();
    }

    protected Document runCommand(Document cmd) {
        return null;
    }

    private String getGroupCodeVal(boolean isDay) {
        if (isDay) {
            return "(8,10).concat(':00')";
        }
        return "(0,8)";
    }
}

