/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.template;

import com.ellabook.util.ListUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;

public abstract class ADSBaseTemplate<T> {
    public static final String DATE_TIME_PATTERN = "yyyyMMdd HH:mm:ss";
    public static final int ANALYTIC_CACHE_MAX_SIZE = 300000;
    public static final int ANALYTIC_CACHE_DAY_NUM = 7;
    public static final int RETRY_COUNT = 3;
    public int ANALYTIC_PARTITION_SIZE;
    protected int ANALYTIC_BATCH_INSERT_SIZE;
    protected Logger logger;

    public void optimize() {
        String msyText;
        Map<String, String> optimizeMap = this.optimizeInADS();
        if (optimizeMap != null && !StringUtils.startsWithIgnoreCase((String)(msyText = optimizeMap.get("Msg_text")), (String)"OK")) {
            this.logger.error("optimizeInADS {}", (Object)msyText);
        }
    }

    protected abstract Map<String, String> optimizeInADS();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertBatchConcurrent(Map<Integer, Set<T>> partitionGroupMap, int checkNum) {
        boolean success = true;
        if (partitionGroupMap.isEmpty()) {
            this.logger.info("userBehaviorAnalysis uidGroup empty");
            return true;
        }
        for (Map.Entry<Integer, Set<T>> kv : partitionGroupMap.entrySet()) {
            ArrayList<T> list;
            Set<T> set = kv.getValue();
            int size = set.size();
            if (size <= checkNum) continue;
            ReentrantLock lock = new ReentrantLock();
            try {
                lock.lock();
                list = new ArrayList<T>(set);
                set.clear();
            }
            finally {
                lock.unlock();
            }
            this.sortAndGroupAndInsert(list);
        }
        return success;
    }

    public boolean insertBatch(Map<Integer, List<T>> partitionGroupMap) {
        boolean success = true;
        if (partitionGroupMap.isEmpty()) {
            this.logger.info("userBehaviorAnalysis uidGroup empty");
            return true;
        }
        for (Map.Entry<Integer, List<T>> kv : partitionGroupMap.entrySet()) {
            List<T> list = kv.getValue();
            this.sortAndGroupAndInsert(list);
        }
        return success;
    }

    protected boolean sortAndGroupAndInsert(List<T> list) {
        boolean success = true;
        this.sortByPrimaryKey(list);
        List<List<T>> groupList = ListUtil.group(list, this.ANALYTIC_BATCH_INSERT_SIZE);
        block2: for (List<T> gList : groupList) {
            int listSize = gList.size();
            for (int i = 0; i < 3; ++i) {
                try {
                    int insertBatch = this.insertBatchInADS(gList);
                    if (listSize == insertBatch) continue block2;
                    this.logger.error("insertBatchInADS {}:{}", (Object)listSize, (Object)insertBatch);
                    success = false;
                    continue block2;
                }
                catch (Exception e) {
                    this.logger.error("insertBatchInADS {}", (Throwable)e);
                    continue;
                }
            }
        }
        return success;
    }

    protected abstract int insertBatchInADS(List<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertToCollConcurrent(T t, Map<Integer, Set<T>> partitionGroupMap) {
        if (this.encodeBASE64(t)) {
            return false;
        }
        int partitionNum = this.getPartitionNum(this.partitionHashKey(t));
        Set<T> set = partitionGroupMap.get(partitionNum);
        if (set == null) {
            set = ConcurrentHashMap.newKeySet();
            ReentrantLock reentrantLock = new ReentrantLock();
            try {
                reentrantLock.lock();
                Set<T> existSet = partitionGroupMap.get(partitionNum);
                if (existSet == null) {
                    partitionGroupMap.put(partitionNum, set);
                } else {
                    set = existSet;
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
        set.add(t);
        return true;
    }

    public boolean insertToColl(T t, Map<Integer, List<T>> partitionGroupMap) {
        if (!this.encodeBASE64(t)) {
            return false;
        }
        int partitionNum = this.getPartitionNum(this.partitionHashKey(t));
        List<T> list = partitionGroupMap.get(partitionNum);
        if (list == null) {
            list = new ArrayList<T>();
            partitionGroupMap.put(partitionNum, list);
        }
        list.add(t);
        return true;
    }

    protected boolean encodeBASE64(T t) {
        return true;
    }

    protected void sortByPrimaryKey(List<T> list) {
    }

    protected abstract Object partitionHashKey(T var1);

    protected int getPartitionNum(Object partitionColVal) {
        long crc32 = partitionColVal == null ? ADSBaseTemplate.getCRC32("-1") : ADSBaseTemplate.getCRC32(partitionColVal.toString());
        return (int)(crc32 % (long)this.ANALYTIC_PARTITION_SIZE);
    }

    protected static final long getCRC32(String value) {
        CRC32 checksum = new CRC32();
        byte[] bytes = value.getBytes();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    protected int getSubKey() {
        return 0;
    }

    public static String getCacheHead(String cacheId) {
        return StringUtils.isNotBlank((String)cacheId) ? "/*+cache_id=" + cacheId + "*/" : null;
    }

    public void createCache() {
        Integer countCacheTable = this.countForCreateCacheTableInADS(7);
        if (countCacheTable < 300000) {
            Date now = new Date();
            Date startDate = DateUtils.addDays((Date)now, (int)-7);
            String startDay = DateFormatUtils.format((Date)startDate, (String)"yyyy-MM-dd");
            String redisKey = "ANALYSIS:ANALYTIC:CACHE:";
            String cacheId = this.redisGetCacheId(redisKey);
            for (int i = 0; i < 3; ++i) {
                try {
                    String cacheTableId = this.createCacheTableInADS(startDay, ADSBaseTemplate.getCacheHead(cacheId));
                    this.redisSetCacheId(redisKey, cacheTableId);
                    return;
                }
                catch (Exception e) {
                    this.redisDelCacheId(redisKey);
                    e.printStackTrace();
                    this.logger.error("createCache {}", (Throwable)e);
                    continue;
                }
            }
        }
    }

    protected void redisDelCacheId(String redisKey) {
    }

    protected void redisSetCacheId(String redisKey, String cacheTableId) {
    }

    protected String redisGetCacheId(String redisKey) {
        return null;
    }

    protected String createCacheTableInADS(String startDay, String cacheHead) {
        return null;
    }

    protected Integer countForCreateCacheTableInADS(int cacheDayNum) {
        return 0;
    }
}

