/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.push;

import com.ellabook.push.UmengNotification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.springframework.util.DigestUtils;

public class PushClient {
    protected final String USER_AGENT = "Mozilla/5.0";
    protected HttpClient client = HttpClientBuilder.create().build();
    protected static final String host = "http://msg.umeng.com";
    protected static final String uploadPath = "/upload";
    protected static final String postPath = "/api/send";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(UmengNotification msg) {
        boolean results = false;
        BufferedReader rd = null;
        try {
            String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
            msg.setPredefinedKeyValue("timestamp", timestamp);
            String url = "http://msg.umeng.com/api/send";
            String postBody = msg.getPostBody();
            String sign = DigestUtils.md5DigestAsHex((byte[])("POST" + url + postBody + msg.getAppMasterSecret()).getBytes("utf8"));
            url = url + "?sign=" + sign;
            HttpPost post = new HttpPost(url);
            post.setHeader("User-Agent", "Mozilla/5.0");
            StringEntity se = new StringEntity(postBody, "UTF-8");
            post.setEntity((HttpEntity)se);
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            int status = response.getStatusLine().getStatusCode();
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            if (status == 200) {
                results = true;
            } else {
                System.out.println("Failed to send the notification!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadContents(String appkey, String appMasterSecret, String contents) {
        String fileId = null;
        BufferedReader rd = null;
        try {
            JSONObject uploadJson = new JSONObject();
            uploadJson.put("appkey", (Object)appkey);
            String timestamp = Integer.toString((int)(System.currentTimeMillis() / 1000L));
            uploadJson.put("timestamp", (Object)timestamp);
            uploadJson.put("content", (Object)contents);
            String url = "http://msg.umeng.com/upload";
            String postBody = uploadJson.toString();
            String sign = DigestUtils.md5DigestAsHex((byte[])("POST" + url + postBody + appMasterSecret).getBytes("utf8"));
            url = url + "?sign=" + sign;
            HttpPost post = new HttpPost(url);
            post.setHeader("User-Agent", "Mozilla/5.0");
            StringEntity se = new StringEntity(postBody, "UTF-8");
            post.setEntity((HttpEntity)se);
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            JSONObject respJson = new JSONObject(result.toString());
            String ret = respJson.getString("ret");
            if (!"SUCCESS".equals(ret)) {
                throw new Exception("Failed to upload file");
            }
            JSONObject data = respJson.getJSONObject("data");
            fileId = data.getString("file_id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileId;
    }
}

