/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.push;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ellabook.entity.user.MessageAdvice;
import com.ellabook.push.AndroidNotification;
import com.ellabook.push.MessagePushUtil;
import com.ellabook.push.PushClient;
import com.ellabook.push.android.AndroidFilecast;
import com.ellabook.push.android.AndroidUnicast;
import com.ellabook.push.ios.IOSFilecast;
import com.ellabook.push.ios.IOSUnicast;
import com.ellabook.util.SendAdviceConfig;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;

public class MessagePush {
    private static final String iosAppKey = MessagePushUtil.IOS_APPKEY.getType();
    private static final String androidAppKey = MessagePushUtil.ANDROID_APPKEY.getType();
    private static final String androidAppMasterSecret = MessagePushUtil.ANDROID_APPMASTERSECRET.getType();
    private static final String iosAppMasterSecret = MessagePushUtil.IOS_APPMASTERSECRET.getType();
    private static final PushClient client = new PushClient();
    private static final String miActivity = "com.ellabook.umeng.UmengNotifyClickActivity";
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public boolean sendAndroidUnicast(String deviceToken, JSONObject json) throws Exception {
        AndroidUnicast unicast = new AndroidUnicast(androidAppKey, androidAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setTicker("Android unicast ticker");
        unicast.setTitle(json.getString("alert"));
        unicast.setText(json.getString("alert"));
        unicast.goAppAfterOpen();
        unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        unicast.setCustomField(json.toString());
        unicast.setTestMode();
        unicast.setExtraField("test", "helloworld");
        return client.send(unicast);
    }

    public boolean sendIOSUnicast(String deviceToken, JSONObject json) throws Exception {
        IOSUnicast unicast = new IOSUnicast(iosAppKey, iosAppMasterSecret);
        unicast.setDeviceToken(deviceToken);
        unicast.setAlert(json.getString("alert"));
        unicast.setBadge(0);
        unicast.setContentAvailable(1);
        unicast.setSound("default");
        unicast.setTestMode();
        unicast.setCustomizedField("custom", json.toString());
        return client.send(unicast);
    }

    public static boolean sendIOSFilecast(String iosDeviceToken, MessageAdvice messageAdvice) throws Exception {
        IOSFilecast filecast = new IOSFilecast(iosAppKey, iosAppMasterSecret);
        if (messageAdvice.getStartTime() != null) {
            filecast.setStartTime(DateFormatUtils.format((Date)messageAdvice.getStartTime(), (String)TIME_PATTERN));
        }
        String fileId = client.uploadContents(iosAppKey, iosAppMasterSecret, iosDeviceToken);
        JSONObject json = new JSONObject();
        json.put("title", (Object)messageAdvice.getTitle());
        json.put("subtitle", (Object)messageAdvice.getSubTitle());
        json.put("body", (Object)messageAdvice.getContent());
        filecast.setFileId(fileId);
        filecast.setAlert(json);
        filecast.setSound("default");
        String a = SendAdviceConfig.getEnvironment();
        if ("sandbox".equals(SendAdviceConfig.getEnvironment())) {
            filecast.setTestMode();
        } else {
            filecast.setProductionMode();
        }
        filecast.setProductionMode();
        String returnJson = JSONObject.toJSONString((Object)messageAdvice, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        filecast.setCustomizedField("custom", returnJson);
        return client.send(filecast);
    }

    public static boolean sendAndroidFilecast(String androidDeviceToken, MessageAdvice messageAdvice) throws Exception {
        AndroidFilecast filecast = new AndroidFilecast(androidAppKey, androidAppMasterSecret);
        if (messageAdvice.getStartTime() != null) {
            filecast.setStartTime(DateFormatUtils.format((Date)messageAdvice.getStartTime(), (String)TIME_PATTERN));
        }
        String fileId = client.uploadContents(androidAppKey, androidAppMasterSecret, androidDeviceToken);
        filecast.setFileId(fileId);
        filecast.setTicker(messageAdvice.getTitle());
        filecast.setTitle(messageAdvice.getSubTitle());
        filecast.setText(messageAdvice.getContent());
        filecast.goAppAfterOpen();
        if ("sandbox".equals(SendAdviceConfig.getEnvironment())) {
            filecast.setTestMode();
        } else {
            filecast.setProductionMode();
        }
        filecast.setMipush(true);
        filecast.setMiActivity(miActivity);
        filecast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        String returnJson = JSONObject.toJSONString((Object)messageAdvice, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        filecast.setCustomField(returnJson);
        return client.send(filecast);
    }
}

