/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.user.vo;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.dto.BaseTaskDTO;
import com.ellabook.entity.user.usertask.TaskParam;
import com.ellabook.entity.user.usertask.TaskReward;
import com.ellabook.entity.user.usertask.UserTaskRecord;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserTaskRecordVO
extends UserTaskRecord {
    private List<TaskReward> rewardList = new ArrayList<TaskReward>();
    private String taskImageUrl;
    private String taskName;
    private String taskDesc;
    private String taskType;
    private String actionName;
    private String actionType;
    private String actionDesc;
    private String taskParam;
    private String taskWallName;

    public UserTaskRecordVO createUserTaskRecordVO(String recordId, String taskStatus, String rewardStatus) {
        TaskParam taskParamObj = StringUtils.isBlank((CharSequence)this.taskParam) ? new TaskParam() : (TaskParam)JSONObject.parseObject((String)this.taskParam, TaskParam.class);
        return new UserTaskRecordVO(recordId, super.getUid(), super.getTaskCode(), super.getTaskWallCode(), taskStatus, rewardStatus, 0, taskParamObj.getCount(), super.getCreateTime(), super.getUpdateTime());
    }

    public static UserTaskRecordVO createUserTaskRecordVO(String recordId, String taskStatus, String rewardStatus, BaseTaskDTO baseTaskDTO, List<TaskReward> rewardList) {
        String taskParam = baseTaskDTO.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank((CharSequence)taskParam) ? new TaskParam() : (TaskParam)JSONObject.parseObject((String)taskParam, TaskParam.class);
        UserTaskRecordVO userTaskRecordVO = new UserTaskRecordVO(recordId, baseTaskDTO.getUid(), baseTaskDTO.getTaskCode(), baseTaskDTO.getTaskWallCode(), taskStatus, rewardStatus, 0, taskParamObj.getCount(), baseTaskDTO.getCreateTime(), baseTaskDTO.getUpdateTime());
        userTaskRecordVO.setTaskImageUrl(baseTaskDTO.getTaskImageUrl());
        userTaskRecordVO.setTaskName(baseTaskDTO.getTaskName());
        userTaskRecordVO.setTaskDesc(baseTaskDTO.getTaskDesc());
        userTaskRecordVO.setTaskType(baseTaskDTO.getTaskType());
        userTaskRecordVO.setActionName(baseTaskDTO.getActionName());
        userTaskRecordVO.setActionType(baseTaskDTO.getActionType());
        userTaskRecordVO.setActionDesc(baseTaskDTO.getActionDesc());
        if (rewardList != null) {
            userTaskRecordVO.setRewardList(rewardList);
        }
        return userTaskRecordVO;
    }

    public void updateByTaskParam() {
        TaskParam taskParamObj = StringUtils.isBlank((CharSequence)this.taskParam) ? new TaskParam() : (TaskParam)JSONObject.parseObject((String)this.taskParam, TaskParam.class);
        super.setCurrentNum(0);
        super.setMaxNum(taskParamObj.getCount());
    }

    public UserTaskRecordVO(String recordId, String uid, String taskCode, String taskWallCode, String taskStatus, String rewardStatus, int currentNum, int maxNum, Date createTime, Date updateTime) {
        super.setRecordId(recordId);
        super.setUid(uid);
        super.setTaskCode(taskCode);
        super.setTaskStatus(taskStatus);
        super.setRewardStatus(rewardStatus);
        super.setTaskWallCode(taskWallCode);
        super.setCurrentNum(currentNum);
        super.setMaxNum(maxNum);
        super.setCreateTime(createTime);
        super.setUpdateTime(updateTime);
    }

    public double pointVal() {
        if (CollectionUtils.isNotEmpty(this.rewardList)) {
            Double totalPoint = this.rewardList.stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)"POINT", (CharSequence)e.getRewardType())).collect(Collectors.summingDouble(e -> new BigDecimal(e.getRewardContent()).doubleValue()));
            return totalPoint;
        }
        return 0.0;
    }

    public void setRewardList(List<TaskReward> rewardList) {
        this.rewardList = rewardList;
    }

    public void setTaskImageUrl(String taskImageUrl) {
        this.taskImageUrl = taskImageUrl;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskDesc(String taskDesc) {
        this.taskDesc = taskDesc;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setActionDesc(String actionDesc) {
        this.actionDesc = actionDesc;
    }

    public void setTaskParam(String taskParam) {
        this.taskParam = taskParam;
    }

    public void setTaskWallName(String taskWallName) {
        this.taskWallName = taskWallName;
    }

    public UserTaskRecordVO() {
    }

    @ConstructorProperties(value={"rewardList", "taskImageUrl", "taskName", "taskDesc", "taskType", "actionName", "actionType", "actionDesc", "taskParam", "taskWallName"})
    public UserTaskRecordVO(List<TaskReward> rewardList, String taskImageUrl, String taskName, String taskDesc, String taskType, String actionName, String actionType, String actionDesc, String taskParam, String taskWallName) {
        this.rewardList = rewardList;
        this.taskImageUrl = taskImageUrl;
        this.taskName = taskName;
        this.taskDesc = taskDesc;
        this.taskType = taskType;
        this.actionName = actionName;
        this.actionType = actionType;
        this.actionDesc = actionDesc;
        this.taskParam = taskParam;
        this.taskWallName = taskWallName;
    }

    public List<TaskReward> getRewardList() {
        return this.rewardList;
    }

    public String getTaskImageUrl() {
        return this.taskImageUrl;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskDesc() {
        return this.taskDesc;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getActionDesc() {
        return this.actionDesc;
    }
}

