/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.user.dto;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.usertask.BaseTask;
import com.ellabook.entity.user.usertask.TaskParam;
import com.ellabook.entity.user.usertask.TaskReward;
import com.ellabook.entity.user.vo.UserTaskRecordVO;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class BaseTaskDTO
extends BaseTask {
    private Date recordCreate;
    private Date recordUpdate;
    private Date publishTime;
    private Boolean current;
    private String wallShelvesFlag;
    private String targetPageType;
    private String targetPage;
    private String targetParam;
    private String taskWallCode;
    private String recordId;
    private String uid;
    private String taskStatus;
    private String rewardStatus;
    private int currentNum;
    private int maxNum;
    private List<TaskReward> rewardList = new ArrayList<TaskReward>();
    private String actionName;
    private String actionType;
    private String actionDesc;

    public Date takePublishTime() {
        return this.publishTime;
    }

    public Date takeTaskCreateTime() {
        return super.getCreateTime();
    }

    public boolean toView() {
        return this.shelvesOn() || "SHOW_OFF".equalsIgnoreCase(this.getShowFlag()) && this.getTaskStatus() != null;
    }

    public boolean shelvesOn() {
        return "SHOW_ON".equalsIgnoreCase(this.getShowFlag()) && "SHELVES_ON".equalsIgnoreCase(this.wallShelvesFlag);
    }

    public static Comparator<BaseTaskDTO> compareByTaskUpdateTime() {
        Comparator comparator = (lt, rt) -> {
            Date lPublishTime = lt.takePublishTime();
            Date rPublishTime = rt.takePublishTime();
            if (lPublishTime == null && rPublishTime == null) {
                return 0;
            }
            if (lPublishTime != null && rPublishTime == null) {
                return 1;
            }
            if (lPublishTime == null && rPublishTime != null) {
                return -1;
            }
            return lPublishTime.compareTo(rPublishTime);
        };
        return comparator;
    }

    public Date takeRecordCreateTime() {
        return this.recordCreate;
    }

    public Date takeRecordUpdateTime() {
        return this.recordUpdate;
    }

    public boolean checkCurrent() {
        Integer cycleTime = this.getCycleTime();
        if (cycleTime != null && cycleTime > 0) {
            if (this.recordCreate == null) {
                return false;
            }
            Date startTime = this.getStartTime();
            long period = this.recordCreate.getTime() - startTime.getTime();
            long realCycleTime = (long)cycleTime.intValue() * 1000L;
            long overTimes = Math.floorDiv(period, realCycleTime);
            Date currentCycleStartTime = new Date(startTime.getTime() + overTimes * realCycleTime);
            Date currentCycleEndTime = new Date(currentCycleStartTime.getTime() + realCycleTime);
            currentCycleEndTime = currentCycleEndTime.before(this.getEndTime()) ? currentCycleEndTime : this.getEndTime();
            return this.checkCurrent(currentCycleStartTime, currentCycleEndTime);
        }
        return this.checkCurrent(this.getStartTime(), this.getEndTime());
    }

    public boolean checkCurrent(Date currentCycleStartTime, Date currentCycleEndTime) {
        if (this.current == null) {
            this.current = this.recordCreate != null && !currentCycleStartTime.after(this.recordCreate) && !this.recordCreate.after(currentCycleEndTime);
        }
        return this.current;
    }

    public BaseTaskDTO update(String taskStatus, String rewardStatus, List<TaskReward> taskRewards) {
        if (StringUtils.isNotBlank((CharSequence)taskStatus)) {
            this.setTaskStatus(taskStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)rewardStatus)) {
            this.setRewardStatus(rewardStatus);
        }
        if (taskRewards != null) {
            this.setRewardList(taskRewards);
        }
        return this;
    }

    public BaseTaskDTO createNew(String taskStatus, String rewardStatus, String recordId) {
        BaseTaskDTO newData = new BaseTaskDTO();
        BeanUtils.copyProperties((Object)this, (Object)newData);
        newData.setPublishTime(this.takePublishTime());
        newData.setMaxNum(this.takeMaxFinishNum());
        newData.setRecordCreate(this.takeRecordCreateTime());
        newData.setRecordUpdate(this.takeRecordUpdateTime());
        String taskParam = super.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank((CharSequence)taskParam) ? new TaskParam() : (TaskParam)JSONObject.parseObject((String)taskParam, TaskParam.class);
        newData.setTaskStatus(taskStatus);
        newData.setRewardStatus(rewardStatus);
        newData.setCurrentNum(0);
        newData.setMaxNum(taskParamObj.getCount());
        newData.setRecordId(recordId);
        return newData;
    }

    public UserTaskRecordVO createUserTaskRecordVO() {
        String taskParam = super.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank((CharSequence)taskParam) ? new TaskParam() : (TaskParam)JSONObject.parseObject((String)taskParam, TaskParam.class);
        return new UserTaskRecordVO(this.recordId, this.getUid(), this.getTaskCode(), this.getTaskWallCode(), this.taskStatus, this.rewardStatus, 0, taskParamObj.getCount(), null, null);
    }

    public double pointVal() {
        if (CollectionUtils.isNotEmpty(this.rewardList)) {
            Double totalPoint = this.rewardList.stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)"POINT", (CharSequence)e.getRewardType())).collect(Collectors.summingDouble(e -> new BigDecimal(e.getRewardContent()).doubleValue()));
            return totalPoint;
        }
        return 0.0;
    }

    public boolean countReceiveUnAvailable(int currentCount) {
        int max = this.takeMaxFinishNum();
        return max <= 0 || currentCount >= max;
    }

    public int takeMaxFinishNum() {
        return Optional.ofNullable(super.getFinishTimes()).orElse(1);
    }

    public Date getRecordCreate() {
        return this.recordCreate;
    }

    public Date getRecordUpdate() {
        return this.recordUpdate;
    }

    public Date getPublishTime() {
        return this.publishTime;
    }

    public Boolean getCurrent() {
        return this.current;
    }

    public String getWallShelvesFlag() {
        return this.wallShelvesFlag;
    }

    public String getTargetPageType() {
        return this.targetPageType;
    }

    public String getTargetPage() {
        return this.targetPage;
    }

    public String getTargetParam() {
        return this.targetParam;
    }

    public void setRecordCreate(Date recordCreate) {
        this.recordCreate = recordCreate;
    }

    public void setRecordUpdate(Date recordUpdate) {
        this.recordUpdate = recordUpdate;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public void setCurrent(Boolean current) {
        this.current = current;
    }

    public void setWallShelvesFlag(String wallShelvesFlag) {
        this.wallShelvesFlag = wallShelvesFlag;
    }

    public void setTargetPageType(String targetPageType) {
        this.targetPageType = targetPageType;
    }

    public void setTargetPage(String targetPage) {
        this.targetPage = targetPage;
    }

    public void setTargetParam(String targetParam) {
        this.targetParam = targetParam;
    }

    public void setTaskWallCode(String taskWallCode) {
        this.taskWallCode = taskWallCode;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public void setRewardStatus(String rewardStatus) {
        this.rewardStatus = rewardStatus;
    }

    public void setCurrentNum(int currentNum) {
        this.currentNum = currentNum;
    }

    public void setMaxNum(int maxNum) {
        this.maxNum = maxNum;
    }

    public void setRewardList(List<TaskReward> rewardList) {
        this.rewardList = rewardList;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setActionDesc(String actionDesc) {
        this.actionDesc = actionDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTaskDTO)) {
            return false;
        }
        BaseTaskDTO other = (BaseTaskDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$recordCreate = this.getRecordCreate();
        Date other$recordCreate = other.getRecordCreate();
        if (this$recordCreate == null ? other$recordCreate != null : !((Object)this$recordCreate).equals(other$recordCreate)) {
            return false;
        }
        Date this$recordUpdate = this.getRecordUpdate();
        Date other$recordUpdate = other.getRecordUpdate();
        if (this$recordUpdate == null ? other$recordUpdate != null : !((Object)this$recordUpdate).equals(other$recordUpdate)) {
            return false;
        }
        Date this$publishTime = this.getPublishTime();
        Date other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        Boolean this$current = this.getCurrent();
        Boolean other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
            return false;
        }
        String this$wallShelvesFlag = this.getWallShelvesFlag();
        String other$wallShelvesFlag = other.getWallShelvesFlag();
        if (this$wallShelvesFlag == null ? other$wallShelvesFlag != null : !this$wallShelvesFlag.equals(other$wallShelvesFlag)) {
            return false;
        }
        String this$targetPageType = this.getTargetPageType();
        String other$targetPageType = other.getTargetPageType();
        if (this$targetPageType == null ? other$targetPageType != null : !this$targetPageType.equals(other$targetPageType)) {
            return false;
        }
        String this$targetPage = this.getTargetPage();
        String other$targetPage = other.getTargetPage();
        if (this$targetPage == null ? other$targetPage != null : !this$targetPage.equals(other$targetPage)) {
            return false;
        }
        String this$targetParam = this.getTargetParam();
        String other$targetParam = other.getTargetParam();
        if (this$targetParam == null ? other$targetParam != null : !this$targetParam.equals(other$targetParam)) {
            return false;
        }
        String this$taskWallCode = this.getTaskWallCode();
        String other$taskWallCode = other.getTaskWallCode();
        if (this$taskWallCode == null ? other$taskWallCode != null : !this$taskWallCode.equals(other$taskWallCode)) {
            return false;
        }
        String this$recordId = this.getRecordId();
        String other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !this$recordId.equals(other$recordId)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$taskStatus = this.getTaskStatus();
        String other$taskStatus = other.getTaskStatus();
        if (this$taskStatus == null ? other$taskStatus != null : !this$taskStatus.equals(other$taskStatus)) {
            return false;
        }
        String this$rewardStatus = this.getRewardStatus();
        String other$rewardStatus = other.getRewardStatus();
        if (this$rewardStatus == null ? other$rewardStatus != null : !this$rewardStatus.equals(other$rewardStatus)) {
            return false;
        }
        if (this.getCurrentNum() != other.getCurrentNum()) {
            return false;
        }
        if (this.getMaxNum() != other.getMaxNum()) {
            return false;
        }
        List<TaskReward> this$rewardList = this.getRewardList();
        List<TaskReward> other$rewardList = other.getRewardList();
        if (this$rewardList == null ? other$rewardList != null : !((Object)this$rewardList).equals(other$rewardList)) {
            return false;
        }
        String this$actionName = this.getActionName();
        String other$actionName = other.getActionName();
        if (this$actionName == null ? other$actionName != null : !this$actionName.equals(other$actionName)) {
            return false;
        }
        String this$actionType = this.getActionType();
        String other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !this$actionType.equals(other$actionType)) {
            return false;
        }
        String this$actionDesc = this.getActionDesc();
        String other$actionDesc = other.getActionDesc();
        return !(this$actionDesc == null ? other$actionDesc != null : !this$actionDesc.equals(other$actionDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseTaskDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $recordCreate = this.getRecordCreate();
        result = result * 59 + ($recordCreate == null ? 43 : ((Object)$recordCreate).hashCode());
        Date $recordUpdate = this.getRecordUpdate();
        result = result * 59 + ($recordUpdate == null ? 43 : ((Object)$recordUpdate).hashCode());
        Date $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        Boolean $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
        String $wallShelvesFlag = this.getWallShelvesFlag();
        result = result * 59 + ($wallShelvesFlag == null ? 43 : $wallShelvesFlag.hashCode());
        String $targetPageType = this.getTargetPageType();
        result = result * 59 + ($targetPageType == null ? 43 : $targetPageType.hashCode());
        String $targetPage = this.getTargetPage();
        result = result * 59 + ($targetPage == null ? 43 : $targetPage.hashCode());
        String $targetParam = this.getTargetParam();
        result = result * 59 + ($targetParam == null ? 43 : $targetParam.hashCode());
        String $taskWallCode = this.getTaskWallCode();
        result = result * 59 + ($taskWallCode == null ? 43 : $taskWallCode.hashCode());
        String $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : $recordId.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $taskStatus = this.getTaskStatus();
        result = result * 59 + ($taskStatus == null ? 43 : $taskStatus.hashCode());
        String $rewardStatus = this.getRewardStatus();
        result = result * 59 + ($rewardStatus == null ? 43 : $rewardStatus.hashCode());
        result = result * 59 + this.getCurrentNum();
        result = result * 59 + this.getMaxNum();
        List<TaskReward> $rewardList = this.getRewardList();
        result = result * 59 + ($rewardList == null ? 43 : ((Object)$rewardList).hashCode());
        String $actionName = this.getActionName();
        result = result * 59 + ($actionName == null ? 43 : $actionName.hashCode());
        String $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : $actionType.hashCode());
        String $actionDesc = this.getActionDesc();
        result = result * 59 + ($actionDesc == null ? 43 : $actionDesc.hashCode());
        return result;
    }

    public String toString() {
        return "BaseTaskDTO(recordCreate=" + this.getRecordCreate() + ", recordUpdate=" + this.getRecordUpdate() + ", publishTime=" + this.getPublishTime() + ", current=" + this.getCurrent() + ", wallShelvesFlag=" + this.getWallShelvesFlag() + ", targetPageType=" + this.getTargetPageType() + ", targetPage=" + this.getTargetPage() + ", targetParam=" + this.getTargetParam() + ", taskWallCode=" + this.getTaskWallCode() + ", recordId=" + this.getRecordId() + ", uid=" + this.getUid() + ", taskStatus=" + this.getTaskStatus() + ", rewardStatus=" + this.getRewardStatus() + ", currentNum=" + this.getCurrentNum() + ", maxNum=" + this.getMaxNum() + ", rewardList=" + this.getRewardList() + ", actionName=" + this.getActionName() + ", actionType=" + this.getActionType() + ", actionDesc=" + this.getActionDesc() + ")";
    }

    public BaseTaskDTO() {
    }

    @ConstructorProperties(value={"recordCreate", "recordUpdate", "publishTime", "current", "wallShelvesFlag", "targetPageType", "targetPage", "targetParam", "taskWallCode", "recordId", "uid", "taskStatus", "rewardStatus", "currentNum", "maxNum", "rewardList", "actionName", "actionType", "actionDesc"})
    public BaseTaskDTO(Date recordCreate, Date recordUpdate, Date publishTime, Boolean current, String wallShelvesFlag, String targetPageType, String targetPage, String targetParam, String taskWallCode, String recordId, String uid, String taskStatus, String rewardStatus, int currentNum, int maxNum, List<TaskReward> rewardList, String actionName, String actionType, String actionDesc) {
        this.recordCreate = recordCreate;
        this.recordUpdate = recordUpdate;
        this.publishTime = publishTime;
        this.current = current;
        this.wallShelvesFlag = wallShelvesFlag;
        this.targetPageType = targetPageType;
        this.targetPage = targetPage;
        this.targetParam = targetParam;
        this.taskWallCode = taskWallCode;
        this.recordId = recordId;
        this.uid = uid;
        this.taskStatus = taskStatus;
        this.rewardStatus = rewardStatus;
        this.currentNum = currentNum;
        this.maxNum = maxNum;
        this.rewardList = rewardList;
        this.actionName = actionName;
        this.actionType = actionType;
        this.actionDesc = actionDesc;
    }

    public String getTaskWallCode() {
        return this.taskWallCode;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public String getRewardStatus() {
        return this.rewardStatus;
    }

    public int getCurrentNum() {
        return this.currentNum;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public List<TaskReward> getRewardList() {
        return this.rewardList;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getActionDesc() {
        return this.actionDesc;
    }
}

