/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.user.dto;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.experience.BaseExperience;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class BaseExperienceDTO
extends BaseExperience {
    private Date currentCycleStartTime;
    private Date currentCycleEndTime;
    private int countByParam = 1;
    private int maxFinishTimes;

    public boolean checkAvailableAndInit(Date now, long actionCycleTime) {
        boolean neverExpire;
        int expireDuration = Optional.ofNullable(super.getExpireDuration()).orElse(0);
        boolean bl = neverExpire = -1 == expireDuration;
        if (neverExpire) {
            this.setCurrentCycleStartTime(null);
            this.setCurrentCycleEndTime(null);
        } else {
            boolean cycle;
            boolean available;
            Date startTime = super.getStartTime();
            Date endTime = super.getEndTime();
            if (startTime == null || endTime == null) {
                return false;
            }
            boolean bl2 = available = this.checkTime(startTime, now, true) && this.checkTime(now, endTime, true);
            if (!available) {
                return false;
            }
            long cycleTime = actionCycleTime;
            boolean bl3 = cycle = Objects.nonNull(cycleTime) && cycleTime > 0L;
            if (cycle) {
                long period = now.getTime() - startTime.getTime();
                long realCycleTime = cycleTime * 1000L;
                long overTimes = Math.floorDiv(period, realCycleTime);
                this.setCurrentCycleStartTime(new Date(startTime.getTime() + overTimes * realCycleTime));
                Date currentCycleEndTime = new Date(this.currentCycleStartTime.getTime() + realCycleTime);
                this.setCurrentCycleEndTime(currentCycleEndTime);
                this.setCurrentCycleEndTime(currentCycleEndTime.before(endTime) ? currentCycleEndTime : endTime);
            } else {
                this.setCurrentCycleStartTime(startTime);
                this.setCurrentCycleEndTime(endTime);
            }
        }
        this.init();
        return true;
    }

    private boolean checkTime(Date earlier, Date later, boolean canEqual) {
        return canEqual ? !earlier.after(later) : later.after(earlier);
    }

    private void init() {
        JSONObject expParam = Optional.ofNullable(JSONObject.parseObject((String)this.getExpParam())).orElse(new JSONObject());
        this.setCountByParam(Optional.ofNullable(expParam.getInteger("count")).orElse(1));
        this.setMaxFinishTimes(Optional.ofNullable(this.getFinishTimes()).orElse(1));
    }

    public static BaseExperienceDTOBuilder builder() {
        return new BaseExperienceDTOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseExperienceDTO)) {
            return false;
        }
        BaseExperienceDTO other = (BaseExperienceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Date this$currentCycleStartTime = this.getCurrentCycleStartTime();
        Date other$currentCycleStartTime = other.getCurrentCycleStartTime();
        if (this$currentCycleStartTime == null ? other$currentCycleStartTime != null : !((Object)this$currentCycleStartTime).equals(other$currentCycleStartTime)) {
            return false;
        }
        Date this$currentCycleEndTime = this.getCurrentCycleEndTime();
        Date other$currentCycleEndTime = other.getCurrentCycleEndTime();
        if (this$currentCycleEndTime == null ? other$currentCycleEndTime != null : !((Object)this$currentCycleEndTime).equals(other$currentCycleEndTime)) {
            return false;
        }
        if (this.getCountByParam() != other.getCountByParam()) {
            return false;
        }
        return this.getMaxFinishTimes() == other.getMaxFinishTimes();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseExperienceDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Date $currentCycleStartTime = this.getCurrentCycleStartTime();
        result = result * 59 + ($currentCycleStartTime == null ? 43 : ((Object)$currentCycleStartTime).hashCode());
        Date $currentCycleEndTime = this.getCurrentCycleEndTime();
        result = result * 59 + ($currentCycleEndTime == null ? 43 : ((Object)$currentCycleEndTime).hashCode());
        result = result * 59 + this.getCountByParam();
        result = result * 59 + this.getMaxFinishTimes();
        return result;
    }

    public Date getCurrentCycleStartTime() {
        return this.currentCycleStartTime;
    }

    public Date getCurrentCycleEndTime() {
        return this.currentCycleEndTime;
    }

    public int getCountByParam() {
        return this.countByParam;
    }

    public int getMaxFinishTimes() {
        return this.maxFinishTimes;
    }

    public void setCurrentCycleStartTime(Date currentCycleStartTime) {
        this.currentCycleStartTime = currentCycleStartTime;
    }

    public void setCurrentCycleEndTime(Date currentCycleEndTime) {
        this.currentCycleEndTime = currentCycleEndTime;
    }

    public void setCountByParam(int countByParam) {
        this.countByParam = countByParam;
    }

    public void setMaxFinishTimes(int maxFinishTimes) {
        this.maxFinishTimes = maxFinishTimes;
    }

    @Override
    public String toString() {
        return "BaseExperienceDTO(currentCycleStartTime=" + this.getCurrentCycleStartTime() + ", currentCycleEndTime=" + this.getCurrentCycleEndTime() + ", countByParam=" + this.getCountByParam() + ", maxFinishTimes=" + this.getMaxFinishTimes() + ")";
    }

    public BaseExperienceDTO() {
    }

    @ConstructorProperties(value={"currentCycleStartTime", "currentCycleEndTime", "countByParam", "maxFinishTimes"})
    public BaseExperienceDTO(Date currentCycleStartTime, Date currentCycleEndTime, int countByParam, int maxFinishTimes) {
        this.currentCycleStartTime = currentCycleStartTime;
        this.currentCycleEndTime = currentCycleEndTime;
        this.countByParam = countByParam;
        this.maxFinishTimes = maxFinishTimes;
    }

    public static class BaseExperienceDTOBuilder {
        private Date currentCycleStartTime;
        private Date currentCycleEndTime;
        private int countByParam;
        private int maxFinishTimes;

        BaseExperienceDTOBuilder() {
        }

        public BaseExperienceDTOBuilder currentCycleStartTime(Date currentCycleStartTime) {
            this.currentCycleStartTime = currentCycleStartTime;
            return this;
        }

        public BaseExperienceDTOBuilder currentCycleEndTime(Date currentCycleEndTime) {
            this.currentCycleEndTime = currentCycleEndTime;
            return this;
        }

        public BaseExperienceDTOBuilder countByParam(int countByParam) {
            this.countByParam = countByParam;
            return this;
        }

        public BaseExperienceDTOBuilder maxFinishTimes(int maxFinishTimes) {
            this.maxFinishTimes = maxFinishTimes;
            return this;
        }

        public BaseExperienceDTO build() {
            return new BaseExperienceDTO(this.currentCycleStartTime, this.currentCycleEndTime, this.countByParam, this.maxFinishTimes);
        }

        public String toString() {
            return "BaseExperienceDTO.BaseExperienceDTOBuilder(currentCycleStartTime=" + this.currentCycleStartTime + ", currentCycleEndTime=" + this.currentCycleEndTime + ", countByParam=" + this.countByParam + ", maxFinishTimes=" + this.maxFinishTimes + ")";
        }
    }
}

