/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.enums;

import com.ellabook.entity.enums.OwnStatus;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum BookStudySourceType {
    BOOK_BORROWED("BOOK_BORROWED", OwnStatus.TEMPORARY, "\u501f\u9605"),
    BOOK_RENT("BOOK_RENT", OwnStatus.TEMPORARY, "\u79df\u4e66"),
    BOOK_COUPON("BOOK_COUPON", OwnStatus.FOREVER, "\u7ea2\u5305\u8d2d\u4e70"),
    BOOK_COUPON_BALANCE("BOOK_COUPON_BALANCE", OwnStatus.FOREVER, "\u7ea2\u5305+\u4f59\u989d\u8d2d\u4e70"),
    BOOK_FREE("BOOK_FREE", OwnStatus.FOREVER, "\u514d\u8d39\u8d2d\u4e70"),
    BOOK_MONEY("BOOK_MONEY", OwnStatus.FOREVER, "\u4f59\u989d\u8d2d\u4e70"),
    BOOK_SEND("BOOK_SEND", OwnStatus.FOREVER, "\u9001\u4e66"),
    BOOK_TASK("BOOK_TASK", OwnStatus.FOREVER, "\u4efb\u52a1\u83b7\u5f97"),
    BOOK_POINTS("BOOK_POINTS", OwnStatus.FOREVER, "\u79ef\u5206\u8d2d\u4e70"),
    ACHIEVEMENT_LEVEL("ACHIEVEMENT_LEVEL", OwnStatus.FOREVER, "\u7528\u6237\u9605\u8bfb\u7b49\u7ea7\u83b7\u5f97");

    private String value;
    private OwnStatus ownStatus;
    private String desc;

    private BookStudySourceType() {
    }

    private BookStudySourceType(String value, OwnStatus ownStatus, String desc) {
        this.value = value;
        this.ownStatus = ownStatus;
        this.desc = desc;
    }

    public static List<String> foreverSourceTypeList() {
        List<String> list = Arrays.asList(BookStudySourceType.values()).stream().filter(e -> Objects.equals(OwnStatus.FOREVER.getValue(), e.getOwnStatus().getValue())).map(e -> e.getValue()).collect(Collectors.toList());
        return list;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public OwnStatus getOwnStatus() {
        return this.ownStatus;
    }

    public void setOwnStatus(OwnStatus ownStatus) {
        this.ownStatus = ownStatus;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

