/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.book.vo;

import com.ellabook.entity.book.Book;
import com.ellabook.entity.book.BookSubject;
import com.ellabook.entity.book.BookSubjectComment;
import com.ellabook.entity.book.BookSubjectIntroduction;
import com.ellabook.entity.order.Goods;
import com.ellabook.entity.order.dto.JurisdictionDetailDTO;
import com.ellabook.entity.user.AppUser;
import com.ellabook.util.BigDecimalUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BookSubjectVO
extends BookSubject {
    private List<BookSubjectIntroduction> introductionList = new ArrayList<BookSubjectIntroduction>();
    private List<String> tagList = new ArrayList<String>();
    private List<Book> bookList = new ArrayList<Book>();
    private List<BookSubjectComment> commentList = new ArrayList<BookSubjectComment>();
    private int commentSize;
    private String purchaseNotes;
    private String isVip = "VIP_NO";
    private String isSvip = "VIP_NO";
    private String goodsCode;
    private String goodsName;
    private String goodsType;
    private double goodsDiscount;
    private double bookTotalPrice = 0.0;
    private double bookTotalDiscountPrice = 0.0;
    private double balePrice = 0.0;
    private double originalPrice = 0.0;
    private double discountAmount = 0.0;
    private double packageGoodsPrice = 0.0;
    private String haveState = "NONE";
    private String toSettle = "true";
    private String filteredBook = "false";
    private Integer subjectBookNum;
    private List<JurisdictionDetailDTO> jurisdictionDetail;
    private String userBorrow = "NO";
    private String bookSubjectBorrow = "NO";
    private Long limitReadDays = 0L;
    private int shelvesOffNum;
    private AppUser appUser;
    private String shelvesFlag;

    public void updateForVO() {
        String[] tags = StringUtils.split((String)this.getTags(), (String)",");
        if (tags != null) {
            this.setTagList(Arrays.asList(tags));
        }
    }

    public void updatePrices(Map<String, List<Goods>> bookPriceMap, Set<String> leftBookCodeSet) {
        double goodsDiscount = this.bookTotalPrice <= 0.0 ? 0.0 : BigDecimalUtil.div(this.bookTotalDiscountPrice, this.bookTotalPrice);
        double originalPrice = this.bookTotalPrice;
        double bookTotalPrice = 0.0;
        double balePrice = 0.0;
        double havePrice = 0.0;
        for (Map.Entry<String, List<Goods>> kv : bookPriceMap.entrySet()) {
            BigDecimal goodsPrice;
            Goods goods;
            List<Goods> goodsList = kv.getValue();
            if (CollectionUtils.isEmpty(goodsList) || (goods = goodsList.get(0)) == null || (goodsPrice = goods.getGoodsPrice()) == null) continue;
            bookTotalPrice = BigDecimalUtil.add(bookTotalPrice, goodsPrice.doubleValue());
            String bookCode = kv.getKey();
            if (leftBookCodeSet.contains(bookCode)) continue;
            originalPrice -= goodsPrice.doubleValue();
            havePrice = BigDecimalUtil.add(havePrice, goodsPrice.doubleValue());
        }
        balePrice = BigDecimalUtil.mul(BigDecimalUtil.div(BigDecimalUtil.sub(bookTotalPrice, havePrice), bookTotalPrice), this.bookTotalDiscountPrice);
        if (originalPrice > 0.0) {
            this.setOriginalPrice(BigDecimalUtil.round(originalPrice, 2));
            if (balePrice > 0.0) {
                this.setBalePrice(BigDecimalUtil.round(balePrice, 2));
            }
            this.setDiscountAmount(BigDecimalUtil.sub(new BigDecimal(this.getOriginalPrice()), new BigDecimal(this.getBalePrice()), 2).doubleValue());
        }
        if (this.getBalePrice() <= 0.0) {
            this.setToSettle("false");
        }
    }

    @Deprecated
    public double takeGoodsDiscount() {
        return 0.0;
    }

    public Goods generateGoods() {
        Goods goods = new Goods();
        goods.setGoodsCode(this.goodsCode);
        goods.setGoodsName(this.goodsName);
        goods.setGoodsType(this.goodsType);
        goods.setThirdCode(this.getPackageCode());
        return goods;
    }

    public String getThirdCode() {
        return this.getPackageCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookSubjectVO)) {
            return false;
        }
        BookSubjectVO other = (BookSubjectVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BookSubjectIntroduction> this$introductionList = this.getIntroductionList();
        List<BookSubjectIntroduction> other$introductionList = other.getIntroductionList();
        if (this$introductionList == null ? other$introductionList != null : !((Object)this$introductionList).equals(other$introductionList)) {
            return false;
        }
        List<String> this$tagList = this.getTagList();
        List<String> other$tagList = other.getTagList();
        if (this$tagList == null ? other$tagList != null : !((Object)this$tagList).equals(other$tagList)) {
            return false;
        }
        List<Book> this$bookList = this.getBookList();
        List<Book> other$bookList = other.getBookList();
        if (this$bookList == null ? other$bookList != null : !((Object)this$bookList).equals(other$bookList)) {
            return false;
        }
        List<BookSubjectComment> this$commentList = this.getCommentList();
        List<BookSubjectComment> other$commentList = other.getCommentList();
        if (this$commentList == null ? other$commentList != null : !((Object)this$commentList).equals(other$commentList)) {
            return false;
        }
        if (this.getCommentSize() != other.getCommentSize()) {
            return false;
        }
        String this$purchaseNotes = this.getPurchaseNotes();
        String other$purchaseNotes = other.getPurchaseNotes();
        if (this$purchaseNotes == null ? other$purchaseNotes != null : !this$purchaseNotes.equals(other$purchaseNotes)) {
            return false;
        }
        String this$isVip = this.getIsVip();
        String other$isVip = other.getIsVip();
        if (this$isVip == null ? other$isVip != null : !this$isVip.equals(other$isVip)) {
            return false;
        }
        String this$isSvip = this.getIsSvip();
        String other$isSvip = other.getIsSvip();
        if (this$isSvip == null ? other$isSvip != null : !this$isSvip.equals(other$isSvip)) {
            return false;
        }
        String this$goodsCode = this.getGoodsCode();
        String other$goodsCode = other.getGoodsCode();
        if (this$goodsCode == null ? other$goodsCode != null : !this$goodsCode.equals(other$goodsCode)) {
            return false;
        }
        String this$goodsName = this.goodsName;
        String other$goodsName = other.goodsName;
        if (this$goodsName == null ? other$goodsName != null : !this$goodsName.equals(other$goodsName)) {
            return false;
        }
        String this$goodsType = this.goodsType;
        String other$goodsType = other.goodsType;
        if (this$goodsType == null ? other$goodsType != null : !this$goodsType.equals(other$goodsType)) {
            return false;
        }
        if (Double.compare(this.goodsDiscount, other.goodsDiscount) != 0) {
            return false;
        }
        if (Double.compare(this.getBookTotalPrice(), other.getBookTotalPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getBookTotalDiscountPrice(), other.getBookTotalDiscountPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getBalePrice(), other.getBalePrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getOriginalPrice(), other.getOriginalPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiscountAmount(), other.getDiscountAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getPackageGoodsPrice(), other.getPackageGoodsPrice()) != 0) {
            return false;
        }
        String this$haveState = this.getHaveState();
        String other$haveState = other.getHaveState();
        if (this$haveState == null ? other$haveState != null : !this$haveState.equals(other$haveState)) {
            return false;
        }
        String this$toSettle = this.getToSettle();
        String other$toSettle = other.getToSettle();
        if (this$toSettle == null ? other$toSettle != null : !this$toSettle.equals(other$toSettle)) {
            return false;
        }
        String this$filteredBook = this.getFilteredBook();
        String other$filteredBook = other.getFilteredBook();
        if (this$filteredBook == null ? other$filteredBook != null : !this$filteredBook.equals(other$filteredBook)) {
            return false;
        }
        Integer this$subjectBookNum = this.getSubjectBookNum();
        Integer other$subjectBookNum = other.getSubjectBookNum();
        if (this$subjectBookNum == null ? other$subjectBookNum != null : !((Object)this$subjectBookNum).equals(other$subjectBookNum)) {
            return false;
        }
        List<JurisdictionDetailDTO> this$jurisdictionDetail = this.getJurisdictionDetail();
        List<JurisdictionDetailDTO> other$jurisdictionDetail = other.getJurisdictionDetail();
        if (this$jurisdictionDetail == null ? other$jurisdictionDetail != null : !((Object)this$jurisdictionDetail).equals(other$jurisdictionDetail)) {
            return false;
        }
        String this$userBorrow = this.getUserBorrow();
        String other$userBorrow = other.getUserBorrow();
        if (this$userBorrow == null ? other$userBorrow != null : !this$userBorrow.equals(other$userBorrow)) {
            return false;
        }
        String this$bookSubjectBorrow = this.getBookSubjectBorrow();
        String other$bookSubjectBorrow = other.getBookSubjectBorrow();
        if (this$bookSubjectBorrow == null ? other$bookSubjectBorrow != null : !this$bookSubjectBorrow.equals(other$bookSubjectBorrow)) {
            return false;
        }
        Long this$limitReadDays = this.getLimitReadDays();
        Long other$limitReadDays = other.getLimitReadDays();
        if (this$limitReadDays == null ? other$limitReadDays != null : !((Object)this$limitReadDays).equals(other$limitReadDays)) {
            return false;
        }
        if (this.getShelvesOffNum() != other.getShelvesOffNum()) {
            return false;
        }
        AppUser this$appUser = this.getAppUser();
        AppUser other$appUser = other.getAppUser();
        if (this$appUser == null ? other$appUser != null : !((Object)this$appUser).equals(other$appUser)) {
            return false;
        }
        String this$shelvesFlag = this.getShelvesFlag();
        String other$shelvesFlag = other.getShelvesFlag();
        return !(this$shelvesFlag == null ? other$shelvesFlag != null : !this$shelvesFlag.equals(other$shelvesFlag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BookSubjectVO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<BookSubjectIntroduction> $introductionList = this.getIntroductionList();
        result = result * 59 + ($introductionList == null ? 43 : ((Object)$introductionList).hashCode());
        List<String> $tagList = this.getTagList();
        result = result * 59 + ($tagList == null ? 43 : ((Object)$tagList).hashCode());
        List<Book> $bookList = this.getBookList();
        result = result * 59 + ($bookList == null ? 43 : ((Object)$bookList).hashCode());
        List<BookSubjectComment> $commentList = this.getCommentList();
        result = result * 59 + ($commentList == null ? 43 : ((Object)$commentList).hashCode());
        result = result * 59 + this.getCommentSize();
        String $purchaseNotes = this.getPurchaseNotes();
        result = result * 59 + ($purchaseNotes == null ? 43 : $purchaseNotes.hashCode());
        String $isVip = this.getIsVip();
        result = result * 59 + ($isVip == null ? 43 : $isVip.hashCode());
        String $isSvip = this.getIsSvip();
        result = result * 59 + ($isSvip == null ? 43 : $isSvip.hashCode());
        String $goodsCode = this.getGoodsCode();
        result = result * 59 + ($goodsCode == null ? 43 : $goodsCode.hashCode());
        String $goodsName = this.goodsName;
        result = result * 59 + ($goodsName == null ? 43 : $goodsName.hashCode());
        String $goodsType = this.goodsType;
        result = result * 59 + ($goodsType == null ? 43 : $goodsType.hashCode());
        long $goodsDiscount = Double.doubleToLongBits(this.goodsDiscount);
        result = result * 59 + (int)($goodsDiscount >>> 32 ^ $goodsDiscount);
        long $bookTotalPrice = Double.doubleToLongBits(this.getBookTotalPrice());
        result = result * 59 + (int)($bookTotalPrice >>> 32 ^ $bookTotalPrice);
        long $bookTotalDiscountPrice = Double.doubleToLongBits(this.getBookTotalDiscountPrice());
        result = result * 59 + (int)($bookTotalDiscountPrice >>> 32 ^ $bookTotalDiscountPrice);
        long $balePrice = Double.doubleToLongBits(this.getBalePrice());
        result = result * 59 + (int)($balePrice >>> 32 ^ $balePrice);
        long $originalPrice = Double.doubleToLongBits(this.getOriginalPrice());
        result = result * 59 + (int)($originalPrice >>> 32 ^ $originalPrice);
        long $discountAmount = Double.doubleToLongBits(this.getDiscountAmount());
        result = result * 59 + (int)($discountAmount >>> 32 ^ $discountAmount);
        long $packageGoodsPrice = Double.doubleToLongBits(this.getPackageGoodsPrice());
        result = result * 59 + (int)($packageGoodsPrice >>> 32 ^ $packageGoodsPrice);
        String $haveState = this.getHaveState();
        result = result * 59 + ($haveState == null ? 43 : $haveState.hashCode());
        String $toSettle = this.getToSettle();
        result = result * 59 + ($toSettle == null ? 43 : $toSettle.hashCode());
        String $filteredBook = this.getFilteredBook();
        result = result * 59 + ($filteredBook == null ? 43 : $filteredBook.hashCode());
        Integer $subjectBookNum = this.getSubjectBookNum();
        result = result * 59 + ($subjectBookNum == null ? 43 : ((Object)$subjectBookNum).hashCode());
        List<JurisdictionDetailDTO> $jurisdictionDetail = this.getJurisdictionDetail();
        result = result * 59 + ($jurisdictionDetail == null ? 43 : ((Object)$jurisdictionDetail).hashCode());
        String $userBorrow = this.getUserBorrow();
        result = result * 59 + ($userBorrow == null ? 43 : $userBorrow.hashCode());
        String $bookSubjectBorrow = this.getBookSubjectBorrow();
        result = result * 59 + ($bookSubjectBorrow == null ? 43 : $bookSubjectBorrow.hashCode());
        Long $limitReadDays = this.getLimitReadDays();
        result = result * 59 + ($limitReadDays == null ? 43 : ((Object)$limitReadDays).hashCode());
        result = result * 59 + this.getShelvesOffNum();
        AppUser $appUser = this.getAppUser();
        result = result * 59 + ($appUser == null ? 43 : ((Object)$appUser).hashCode());
        String $shelvesFlag = this.getShelvesFlag();
        result = result * 59 + ($shelvesFlag == null ? 43 : $shelvesFlag.hashCode());
        return result;
    }

    public void setIntroductionList(List<BookSubjectIntroduction> introductionList) {
        this.introductionList = introductionList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public void setBookList(List<Book> bookList) {
        this.bookList = bookList;
    }

    public void setCommentList(List<BookSubjectComment> commentList) {
        this.commentList = commentList;
    }

    public void setCommentSize(int commentSize) {
        this.commentSize = commentSize;
    }

    public void setPurchaseNotes(String purchaseNotes) {
        this.purchaseNotes = purchaseNotes;
    }

    public void setIsVip(String isVip) {
        this.isVip = isVip;
    }

    public void setIsSvip(String isSvip) {
        this.isSvip = isSvip;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public void setGoodsDiscount(double goodsDiscount) {
        this.goodsDiscount = goodsDiscount;
    }

    public void setBookTotalPrice(double bookTotalPrice) {
        this.bookTotalPrice = bookTotalPrice;
    }

    public void setBookTotalDiscountPrice(double bookTotalDiscountPrice) {
        this.bookTotalDiscountPrice = bookTotalDiscountPrice;
    }

    public void setBalePrice(double balePrice) {
        this.balePrice = balePrice;
    }

    public void setOriginalPrice(double originalPrice) {
        this.originalPrice = originalPrice;
    }

    public void setDiscountAmount(double discountAmount) {
        this.discountAmount = discountAmount;
    }

    public void setPackageGoodsPrice(double packageGoodsPrice) {
        this.packageGoodsPrice = packageGoodsPrice;
    }

    public void setHaveState(String haveState) {
        this.haveState = haveState;
    }

    public void setToSettle(String toSettle) {
        this.toSettle = toSettle;
    }

    public void setFilteredBook(String filteredBook) {
        this.filteredBook = filteredBook;
    }

    public void setSubjectBookNum(Integer subjectBookNum) {
        this.subjectBookNum = subjectBookNum;
    }

    public void setJurisdictionDetail(List<JurisdictionDetailDTO> jurisdictionDetail) {
        this.jurisdictionDetail = jurisdictionDetail;
    }

    public void setUserBorrow(String userBorrow) {
        this.userBorrow = userBorrow;
    }

    public void setBookSubjectBorrow(String bookSubjectBorrow) {
        this.bookSubjectBorrow = bookSubjectBorrow;
    }

    public void setLimitReadDays(Long limitReadDays) {
        this.limitReadDays = limitReadDays;
    }

    public void setShelvesOffNum(int shelvesOffNum) {
        this.shelvesOffNum = shelvesOffNum;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public void setShelvesFlag(String shelvesFlag) {
        this.shelvesFlag = shelvesFlag;
    }

    public BookSubjectVO() {
    }

    @ConstructorProperties(value={"introductionList", "tagList", "bookList", "commentList", "commentSize", "purchaseNotes", "isVip", "isSvip", "goodsCode", "goodsName", "goodsType", "goodsDiscount", "bookTotalPrice", "bookTotalDiscountPrice", "balePrice", "originalPrice", "discountAmount", "packageGoodsPrice", "haveState", "toSettle", "filteredBook", "subjectBookNum", "jurisdictionDetail", "userBorrow", "bookSubjectBorrow", "limitReadDays", "shelvesOffNum", "appUser", "shelvesFlag"})
    public BookSubjectVO(List<BookSubjectIntroduction> introductionList, List<String> tagList, List<Book> bookList, List<BookSubjectComment> commentList, int commentSize, String purchaseNotes, String isVip, String isSvip, String goodsCode, String goodsName, String goodsType, double goodsDiscount, double bookTotalPrice, double bookTotalDiscountPrice, double balePrice, double originalPrice, double discountAmount, double packageGoodsPrice, String haveState, String toSettle, String filteredBook, Integer subjectBookNum, List<JurisdictionDetailDTO> jurisdictionDetail, String userBorrow, String bookSubjectBorrow, Long limitReadDays, int shelvesOffNum, AppUser appUser, String shelvesFlag) {
        this.introductionList = introductionList;
        this.tagList = tagList;
        this.bookList = bookList;
        this.commentList = commentList;
        this.commentSize = commentSize;
        this.purchaseNotes = purchaseNotes;
        this.isVip = isVip;
        this.isSvip = isSvip;
        this.goodsCode = goodsCode;
        this.goodsName = goodsName;
        this.goodsType = goodsType;
        this.goodsDiscount = goodsDiscount;
        this.bookTotalPrice = bookTotalPrice;
        this.bookTotalDiscountPrice = bookTotalDiscountPrice;
        this.balePrice = balePrice;
        this.originalPrice = originalPrice;
        this.discountAmount = discountAmount;
        this.packageGoodsPrice = packageGoodsPrice;
        this.haveState = haveState;
        this.toSettle = toSettle;
        this.filteredBook = filteredBook;
        this.subjectBookNum = subjectBookNum;
        this.jurisdictionDetail = jurisdictionDetail;
        this.userBorrow = userBorrow;
        this.bookSubjectBorrow = bookSubjectBorrow;
        this.limitReadDays = limitReadDays;
        this.shelvesOffNum = shelvesOffNum;
        this.appUser = appUser;
        this.shelvesFlag = shelvesFlag;
    }

    public List<BookSubjectIntroduction> getIntroductionList() {
        return this.introductionList;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public List<Book> getBookList() {
        return this.bookList;
    }

    public List<BookSubjectComment> getCommentList() {
        return this.commentList;
    }

    public int getCommentSize() {
        return this.commentSize;
    }

    public String getPurchaseNotes() {
        return this.purchaseNotes;
    }

    public String getIsVip() {
        return this.isVip;
    }

    public String getIsSvip() {
        return this.isSvip;
    }

    public String getGoodsCode() {
        return this.goodsCode;
    }

    public double getBookTotalPrice() {
        return this.bookTotalPrice;
    }

    public double getBookTotalDiscountPrice() {
        return this.bookTotalDiscountPrice;
    }

    public double getBalePrice() {
        return this.balePrice;
    }

    public double getOriginalPrice() {
        return this.originalPrice;
    }

    public double getDiscountAmount() {
        return this.discountAmount;
    }

    public double getPackageGoodsPrice() {
        return this.packageGoodsPrice;
    }

    public String getHaveState() {
        return this.haveState;
    }

    public String getToSettle() {
        return this.toSettle;
    }

    public String getFilteredBook() {
        return this.filteredBook;
    }

    public Integer getSubjectBookNum() {
        return this.subjectBookNum;
    }

    public List<JurisdictionDetailDTO> getJurisdictionDetail() {
        return this.jurisdictionDetail;
    }

    public String getUserBorrow() {
        return this.userBorrow;
    }

    public String getBookSubjectBorrow() {
        return this.bookSubjectBorrow;
    }

    public Long getLimitReadDays() {
        return this.limitReadDays;
    }

    public int getShelvesOffNum() {
        return this.shelvesOffNum;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public String getShelvesFlag() {
        return this.shelvesFlag;
    }
}

