/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.book.dto;

import com.ellabook.entity.analysis.AppLogsHostEvent;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class UserAppEventsDto {
    private String id;
    private boolean noLog = false;
    private List<AppLogsHostEvent> appEvents = new ArrayList<AppLogsHostEvent>();

    public UserAppEventsDto(String id) {
        this.id = id;
    }

    public Set<String> getBookCodes() {
        if (CollectionUtils.isEmpty(this.appEvents)) {
            return new HashSet<String>();
        }
        return this.appEvents.stream().map(AppLogsHostEvent::getMsg).filter(msg -> StringUtils.isNotBlank((CharSequence)msg)).collect(Collectors.toSet());
    }

    public void addEvent(AppLogsHostEvent appLogsHostEvent) {
        this.appEvents.add(appLogsHostEvent);
    }

    public String getId() {
        return this.id;
    }

    public boolean isNoLog() {
        return this.noLog;
    }

    public List<AppLogsHostEvent> getAppEvents() {
        return this.appEvents;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNoLog(boolean noLog) {
        this.noLog = noLog;
    }

    public void setAppEvents(List<AppLogsHostEvent> appEvents) {
        this.appEvents = appEvents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAppEventsDto)) {
            return false;
        }
        UserAppEventsDto other = (UserAppEventsDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (this.isNoLog() != other.isNoLog()) {
            return false;
        }
        List<AppLogsHostEvent> this$appEvents = this.getAppEvents();
        List<AppLogsHostEvent> other$appEvents = other.getAppEvents();
        return !(this$appEvents == null ? other$appEvents != null : !((Object)this$appEvents).equals(other$appEvents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserAppEventsDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + (this.isNoLog() ? 79 : 97);
        List<AppLogsHostEvent> $appEvents = this.getAppEvents();
        result = result * 59 + ($appEvents == null ? 43 : ((Object)$appEvents).hashCode());
        return result;
    }

    public String toString() {
        return "UserAppEventsDto(id=" + this.getId() + ", noLog=" + this.isNoLog() + ", appEvents=" + this.getAppEvents() + ")";
    }

    public UserAppEventsDto() {
    }

    @ConstructorProperties(value={"id", "noLog", "appEvents"})
    public UserAppEventsDto(String id, boolean noLog, List<AppLogsHostEvent> appEvents) {
        this.id = id;
        this.noLog = noLog;
        this.appEvents = appEvents;
    }
}

