/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.book.dto;

import com.ellabook.entity.PublicParam;
import com.ellabook.entity.ResponseParams;
import com.ellabook.entity.book.PointsExchange;
import com.ellabook.util.ResponseParamsUtil;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class PointsExchangeDTO
extends PointsExchange {
    private PublicParam publicParam;
    private int points;
    private String uid;
    private String channelCode;
    private Date startTime;
    private Date endTime;
    private Date currentCycleStartTime;
    private Date currentCycleEndTime;
    private int userTotalCount;
    private int userCycleCount;

    public String getUid() {
        return StringUtils.isNotBlank((String)this.uid) ? this.uid : (this.publicParam == null ? null : this.publicParam.getUid());
    }

    public String getChannelCode() {
        return StringUtils.isNotBlank((String)this.channelCode) ? this.channelCode : (this.publicParam == null ? null : this.publicParam.getChannelCode());
    }

    public void computeCycleTime(Date now, PointsExchangeDTO pointsExchangeDTO) throws Exception {
        long realCycleTime;
        if (this.startTime == null || this.endTime == null) {
            throw new Exception("time err");
        }
        long startTimeVal = this.getStartTime().getTime();
        Date endTime = this.getEndTime();
        long period = now.getTime() - startTimeVal;
        long overTimes = Math.floorDiv(period, realCycleTime = (long)(this.getCycleTime() * 24 * 3600) * 1000L);
        Date currentCycleStartTime = new Date(startTimeVal + overTimes * realCycleTime);
        Date currentCycleEndTime = new Date(currentCycleStartTime.getTime() + realCycleTime);
        currentCycleEndTime = currentCycleEndTime.before(endTime) ? currentCycleEndTime : endTime;
        pointsExchangeDTO.setCurrentCycleStartTime(currentCycleStartTime);
        pointsExchangeDTO.setCurrentCycleEndTime(currentCycleEndTime);
    }

    public ResponseParams checkUserPointsExchange(PointsExchangeDTO pointsExchange, ResponseParamsUtil responseParamsUtil) {
        int maxTimes = Optional.ofNullable(pointsExchange.getMaxTimes()).orElse(-1);
        int exchangeTimes = Optional.ofNullable(pointsExchange.getExchangeTimes()).orElse(0);
        if (this.userCycleCount >= exchangeTimes) {
            return responseParamsUtil.fail("10020004", pointsExchange.getCycleTime() + "\u5929\u5185\u53ea\u80fd\u5151\u6362" + pointsExchange.getExchangeTimes() + "\u6b21\u54e6", "\u79ef\u5206\u5151\u6362");
        }
        if (maxTimes != -1 && this.userTotalCount >= maxTimes) {
            return responseParamsUtil.fail("10020002", "\u5df2\u7528\u5b8c\u5151\u6362\u6b21\u6570\uff0c\u7b49\u5f85\u4e0b\u4e00\u671f\u5151\u6362\u5427~", "\u79ef\u5206\u5151\u6362");
        }
        return responseParamsUtil.success("\u3010\u8c03\u7528\u6210\u529f\u3011", "\u79ef\u5206\u5151\u6362", null);
    }

    public static PointsExchangeDTOBuilder builder() {
        return new PointsExchangeDTOBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PointsExchangeDTO)) {
            return false;
        }
        PointsExchangeDTO other = (PointsExchangeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicParam this$publicParam = this.getPublicParam();
        PublicParam other$publicParam = other.getPublicParam();
        if (this$publicParam == null ? other$publicParam != null : !((Object)this$publicParam).equals(other$publicParam)) {
            return false;
        }
        if (this.getPoints() != other.getPoints()) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        String this$channelCode = this.getChannelCode();
        String other$channelCode = other.getChannelCode();
        if (this$channelCode == null ? other$channelCode != null : !this$channelCode.equals(other$channelCode)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Date this$currentCycleStartTime = this.getCurrentCycleStartTime();
        Date other$currentCycleStartTime = other.getCurrentCycleStartTime();
        if (this$currentCycleStartTime == null ? other$currentCycleStartTime != null : !((Object)this$currentCycleStartTime).equals(other$currentCycleStartTime)) {
            return false;
        }
        Date this$currentCycleEndTime = this.getCurrentCycleEndTime();
        Date other$currentCycleEndTime = other.getCurrentCycleEndTime();
        if (this$currentCycleEndTime == null ? other$currentCycleEndTime != null : !((Object)this$currentCycleEndTime).equals(other$currentCycleEndTime)) {
            return false;
        }
        if (this.getUserTotalCount() != other.getUserTotalCount()) {
            return false;
        }
        return this.getUserCycleCount() == other.getUserCycleCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PointsExchangeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        PublicParam $publicParam = this.getPublicParam();
        result = result * 59 + ($publicParam == null ? 43 : ((Object)$publicParam).hashCode());
        result = result * 59 + this.getPoints();
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        String $channelCode = this.getChannelCode();
        result = result * 59 + ($channelCode == null ? 43 : $channelCode.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Date $currentCycleStartTime = this.getCurrentCycleStartTime();
        result = result * 59 + ($currentCycleStartTime == null ? 43 : ((Object)$currentCycleStartTime).hashCode());
        Date $currentCycleEndTime = this.getCurrentCycleEndTime();
        result = result * 59 + ($currentCycleEndTime == null ? 43 : ((Object)$currentCycleEndTime).hashCode());
        result = result * 59 + this.getUserTotalCount();
        result = result * 59 + this.getUserCycleCount();
        return result;
    }

    public PublicParam getPublicParam() {
        return this.publicParam;
    }

    public int getPoints() {
        return this.points;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getCurrentCycleStartTime() {
        return this.currentCycleStartTime;
    }

    public Date getCurrentCycleEndTime() {
        return this.currentCycleEndTime;
    }

    public int getUserTotalCount() {
        return this.userTotalCount;
    }

    public int getUserCycleCount() {
        return this.userCycleCount;
    }

    public void setPublicParam(PublicParam publicParam) {
        this.publicParam = publicParam;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setCurrentCycleStartTime(Date currentCycleStartTime) {
        this.currentCycleStartTime = currentCycleStartTime;
    }

    public void setCurrentCycleEndTime(Date currentCycleEndTime) {
        this.currentCycleEndTime = currentCycleEndTime;
    }

    public void setUserTotalCount(int userTotalCount) {
        this.userTotalCount = userTotalCount;
    }

    public void setUserCycleCount(int userCycleCount) {
        this.userCycleCount = userCycleCount;
    }

    public String toString() {
        return "PointsExchangeDTO(publicParam=" + this.getPublicParam() + ", points=" + this.getPoints() + ", uid=" + this.getUid() + ", channelCode=" + this.getChannelCode() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", currentCycleStartTime=" + this.getCurrentCycleStartTime() + ", currentCycleEndTime=" + this.getCurrentCycleEndTime() + ", userTotalCount=" + this.getUserTotalCount() + ", userCycleCount=" + this.getUserCycleCount() + ")";
    }

    public PointsExchangeDTO() {
    }

    @ConstructorProperties(value={"publicParam", "points", "uid", "channelCode", "startTime", "endTime", "currentCycleStartTime", "currentCycleEndTime", "userTotalCount", "userCycleCount"})
    public PointsExchangeDTO(PublicParam publicParam, int points, String uid, String channelCode, Date startTime, Date endTime, Date currentCycleStartTime, Date currentCycleEndTime, int userTotalCount, int userCycleCount) {
        this.publicParam = publicParam;
        this.points = points;
        this.uid = uid;
        this.channelCode = channelCode;
        this.startTime = startTime;
        this.endTime = endTime;
        this.currentCycleStartTime = currentCycleStartTime;
        this.currentCycleEndTime = currentCycleEndTime;
        this.userTotalCount = userTotalCount;
        this.userCycleCount = userCycleCount;
    }

    public static class PointsExchangeDTOBuilder {
        private PublicParam publicParam;
        private int points;
        private String uid;
        private String channelCode;
        private Date startTime;
        private Date endTime;
        private Date currentCycleStartTime;
        private Date currentCycleEndTime;
        private int userTotalCount;
        private int userCycleCount;

        PointsExchangeDTOBuilder() {
        }

        public PointsExchangeDTOBuilder publicParam(PublicParam publicParam) {
            this.publicParam = publicParam;
            return this;
        }

        public PointsExchangeDTOBuilder points(int points) {
            this.points = points;
            return this;
        }

        public PointsExchangeDTOBuilder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public PointsExchangeDTOBuilder channelCode(String channelCode) {
            this.channelCode = channelCode;
            return this;
        }

        public PointsExchangeDTOBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public PointsExchangeDTOBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public PointsExchangeDTOBuilder currentCycleStartTime(Date currentCycleStartTime) {
            this.currentCycleStartTime = currentCycleStartTime;
            return this;
        }

        public PointsExchangeDTOBuilder currentCycleEndTime(Date currentCycleEndTime) {
            this.currentCycleEndTime = currentCycleEndTime;
            return this;
        }

        public PointsExchangeDTOBuilder userTotalCount(int userTotalCount) {
            this.userTotalCount = userTotalCount;
            return this;
        }

        public PointsExchangeDTOBuilder userCycleCount(int userCycleCount) {
            this.userCycleCount = userCycleCount;
            return this;
        }

        public PointsExchangeDTO build() {
            return new PointsExchangeDTO(this.publicParam, this.points, this.uid, this.channelCode, this.startTime, this.endTime, this.currentCycleStartTime, this.currentCycleEndTime, this.userTotalCount, this.userCycleCount);
        }

        public String toString() {
            return "PointsExchangeDTO.PointsExchangeDTOBuilder(publicParam=" + this.publicParam + ", points=" + this.points + ", uid=" + this.uid + ", channelCode=" + this.channelCode + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", currentCycleStartTime=" + this.currentCycleStartTime + ", currentCycleEndTime=" + this.currentCycleEndTime + ", userTotalCount=" + this.userTotalCount + ", userCycleCount=" + this.userCycleCount + ")";
        }
    }
}

