/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.book.dto;

import com.ellabook.entity.PublicParam;
import com.ellabook.entity.book.BookSubject;
import com.ellabook.entity.user.vo.PageVo;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class BookSubjectDTO
extends BookSubject {
    private Integer page;
    private Integer pageSize;
    private PageVo pageVo = new PageVo();
    private String channelCode;
    private String platform;
    private String uid;
    private PublicParam publicParam = new PublicParam();
    private String bookStudySourceTypes;
    private String packageCode;
    private double goodsDiscount;
    private String siteCode;
    private String language;
    private String requestType = "DETAIL_RENT";

    public BookSubjectDTO(PageVo pageVo, String channelCode, String platform) {
        this.pageVo = pageVo;
        this.channelCode = channelCode;
        this.platform = platform;
    }

    public BookSubjectDTO(PageVo pageVo, String channelCode, String platform, String siteCode) {
        this.pageVo = pageVo;
        this.channelCode = channelCode;
        this.platform = platform;
        this.siteCode = siteCode;
    }

    public void updateParam(int pageSize) {
        this.pageVo.setPage(Optional.ofNullable(this.page).orElse(0));
        this.pageVo.setPageSize(Optional.ofNullable(this.pageSize).orElse(pageSize));
        this.pageVo.setStartAndEnd();
    }

    public String getChannelCode() {
        return StringUtils.isNotBlank((String)this.channelCode) ? this.channelCode : (this.publicParam == null ? null : this.publicParam.getChannelCode());
    }

    public String getPlatform() {
        return StringUtils.isNotBlank((String)this.platform) ? this.platform : (this.publicParam == null ? null : this.publicParam.getPlatform());
    }

    public String getUid() {
        return StringUtils.isNotBlank((String)this.uid) ? this.uid : (this.publicParam == null ? null : this.publicParam.getUid());
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookSubjectDTO)) {
            return false;
        }
        BookSubjectDTO other = (BookSubjectDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        PageVo this$pageVo = this.getPageVo();
        PageVo other$pageVo = other.getPageVo();
        if (this$pageVo == null ? other$pageVo != null : !this$pageVo.equals(other$pageVo)) {
            return false;
        }
        String this$channelCode = this.getChannelCode();
        String other$channelCode = other.getChannelCode();
        if (this$channelCode == null ? other$channelCode != null : !this$channelCode.equals(other$channelCode)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$uid = this.getUid();
        String other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) {
            return false;
        }
        PublicParam this$publicParam = this.getPublicParam();
        PublicParam other$publicParam = other.getPublicParam();
        if (this$publicParam == null ? other$publicParam != null : !((Object)this$publicParam).equals(other$publicParam)) {
            return false;
        }
        String this$bookStudySourceTypes = this.getBookStudySourceTypes();
        String other$bookStudySourceTypes = other.getBookStudySourceTypes();
        if (this$bookStudySourceTypes == null ? other$bookStudySourceTypes != null : !this$bookStudySourceTypes.equals(other$bookStudySourceTypes)) {
            return false;
        }
        String this$packageCode = this.getPackageCode();
        String other$packageCode = other.getPackageCode();
        if (this$packageCode == null ? other$packageCode != null : !this$packageCode.equals(other$packageCode)) {
            return false;
        }
        if (Double.compare(this.getGoodsDiscount(), other.getGoodsDiscount()) != 0) {
            return false;
        }
        String this$siteCode = this.getSiteCode();
        String other$siteCode = other.getSiteCode();
        if (this$siteCode == null ? other$siteCode != null : !this$siteCode.equals(other$siteCode)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        return !(this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BookSubjectDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        PageVo $pageVo = this.getPageVo();
        result = result * 59 + ($pageVo == null ? 43 : $pageVo.hashCode());
        String $channelCode = this.getChannelCode();
        result = result * 59 + ($channelCode == null ? 43 : $channelCode.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : $uid.hashCode());
        PublicParam $publicParam = this.getPublicParam();
        result = result * 59 + ($publicParam == null ? 43 : ((Object)$publicParam).hashCode());
        String $bookStudySourceTypes = this.getBookStudySourceTypes();
        result = result * 59 + ($bookStudySourceTypes == null ? 43 : $bookStudySourceTypes.hashCode());
        String $packageCode = this.getPackageCode();
        result = result * 59 + ($packageCode == null ? 43 : $packageCode.hashCode());
        long $goodsDiscount = Double.doubleToLongBits(this.getGoodsDiscount());
        result = result * 59 + (int)($goodsDiscount >>> 32 ^ $goodsDiscount);
        String $siteCode = this.getSiteCode();
        result = result * 59 + ($siteCode == null ? 43 : $siteCode.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        return result;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public PageVo getPageVo() {
        return this.pageVo;
    }

    public PublicParam getPublicParam() {
        return this.publicParam;
    }

    public String getBookStudySourceTypes() {
        return this.bookStudySourceTypes;
    }

    @Override
    public String getPackageCode() {
        return this.packageCode;
    }

    public double getGoodsDiscount() {
        return this.goodsDiscount;
    }

    public String getSiteCode() {
        return this.siteCode;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageVo(PageVo pageVo) {
        this.pageVo = pageVo;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setPublicParam(PublicParam publicParam) {
        this.publicParam = publicParam;
    }

    public void setBookStudySourceTypes(String bookStudySourceTypes) {
        this.bookStudySourceTypes = bookStudySourceTypes;
    }

    @Override
    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public void setGoodsDiscount(double goodsDiscount) {
        this.goodsDiscount = goodsDiscount;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    @Override
    public String toString() {
        return "BookSubjectDTO(page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", pageVo=" + this.getPageVo() + ", channelCode=" + this.getChannelCode() + ", platform=" + this.getPlatform() + ", uid=" + this.getUid() + ", publicParam=" + this.getPublicParam() + ", bookStudySourceTypes=" + this.getBookStudySourceTypes() + ", packageCode=" + this.getPackageCode() + ", goodsDiscount=" + this.getGoodsDiscount() + ", siteCode=" + this.getSiteCode() + ", language=" + this.getLanguage() + ", requestType=" + this.getRequestType() + ")";
    }

    public BookSubjectDTO() {
    }
}

