/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.analysis.vo;

import com.ellabook.entity.analysis.dto.KeyValDataDTO;
import com.ellabook.util.BigDecimalUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChannelDataVO {
    private String channelName = "";
    private BigDecimal channelNum;
    private BigDecimal channelAmount;
    private Double channelRate;
    private KeyValDataDTO dto;

    public ChannelDataVO(String channelName, BigDecimal channelNum) {
        this.channelName = channelName;
        this.channelNum = channelNum;
    }

    public ChannelDataVO(KeyValDataDTO dto) {
        this.dto = dto;
        this.channelName = dto.getMsg();
        this.channelNum = dto.getValue();
    }

    public double compute(BigDecimal value, BigDecimal total) {
        double result = 0.0;
        if (value != null && total != null && total.doubleValue() != 0.0) {
            result = BigDecimalUtil.div(BigDecimalUtil.mul(value, new BigDecimal(100)), total, 2).doubleValue();
        }
        this.channelRate = result;
        return result;
    }

    public String sortByDay() {
        return this.dto.getKey();
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setChannelNum(BigDecimal channelNum) {
        this.channelNum = channelNum;
    }

    public void setChannelAmount(BigDecimal channelAmount) {
        this.channelAmount = channelAmount;
    }

    public void setChannelRate(Double channelRate) {
        this.channelRate = channelRate;
    }

    public void setDto(KeyValDataDTO dto) {
        this.dto = dto;
    }

    public ChannelDataVO() {
    }

    @ConstructorProperties(value={"channelName", "channelNum", "channelAmount", "channelRate", "dto"})
    public ChannelDataVO(String channelName, BigDecimal channelNum, BigDecimal channelAmount, Double channelRate, KeyValDataDTO dto) {
        this.channelName = channelName;
        this.channelNum = channelNum;
        this.channelAmount = channelAmount;
        this.channelRate = channelRate;
        this.dto = dto;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public BigDecimal getChannelNum() {
        return this.channelNum;
    }

    public BigDecimal getChannelAmount() {
        return this.channelAmount;
    }

    public Double getChannelRate() {
        return this.channelRate;
    }
}

