/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.dto.BaseUserSynopsisDataDTO;
import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class UserSynopsisActiveDataDTO
extends BaseUserSynopsisDataDTO {
    private int activeUserNum;
    private int compareActiveUserNum;
    private double activeUserChangingRate;
    private int activeNewUserNum;
    private double activeNewUserRate;
    private double activeOldUserRate;
    private int iosActiveUserNum;
    private double iosActiveUserRate;
    private double androidActiveUserRate;
    private List<ChannelDataVO> channelActiveDataList = new ArrayList<ChannelDataVO>();
    private double activeAppStartOnceUserNum;
    private double activeAppStartOnceUserRate;
    int increaseLoyaltyUserNum;
    int increaseLeaveUserNum;
    int increaseReflowUserNum;

    public void compute() {
        if (this.activeUserNum <= 0) {
            return;
        }
        this.activeNewUserRate = this.percent(this.activeNewUserNum, this.activeUserNum);
        this.activeOldUserRate = this.leftPercentScale(this.activeUserNum, this.activeNewUserNum);
        this.computeChannel(false);
        this.activeAppStartOnceUserRate = this.percent(this.activeAppStartOnceUserNum, this.activeUserNum);
    }

    private void computeChannel(boolean compute) {
        BigDecimal iosActiveNum = BigDecimal.ZERO;
        BigDecimal total = new BigDecimal(this.activeUserNum);
        for (ChannelDataVO channelDataVO : this.channelActiveDataList) {
            if (compute) {
                channelDataVO.compute(channelDataVO.getChannelNum(), total);
            }
            if (!UserSynopsisActiveDataDTO.ifIOS(channelDataVO.getChannelName())) continue;
            this.iosActiveUserRate += channelDataVO.getChannelRate().doubleValue();
            iosActiveNum = BigDecimalUtil.add(iosActiveNum, channelDataVO.getChannelNum());
        }
        this.channelActiveDataList = this.channelActiveDataList.stream().filter(e -> UserSynopsisActiveDataDTO.toChannelFilter(e)).collect(Collectors.toList());
        this.androidActiveUserRate = this.leftPercentScale(this.activeUserNum, iosActiveNum.doubleValue());
    }

    public void computeForActiveUser() {
        if (this.activeUserNum <= 0) {
            return;
        }
        this.activeUserChangingRate = this.percent(this.activeUserNum - this.compareActiveUserNum, this.activeUserNum);
        this.activeNewUserRate = this.percent(this.activeNewUserNum, this.activeUserNum);
        this.activeOldUserRate = this.leftPercentScale(this.activeUserNum, this.activeNewUserNum);
        this.computeChannel(true);
        Collections.sort(this.channelActiveDataList, Comparator.comparing(ChannelDataVO::getChannelRate).reversed());
    }

    public void setActiveUserNum(int activeUserNum) {
        this.activeUserNum = activeUserNum;
    }

    public void setCompareActiveUserNum(int compareActiveUserNum) {
        this.compareActiveUserNum = compareActiveUserNum;
    }

    public void setActiveUserChangingRate(double activeUserChangingRate) {
        this.activeUserChangingRate = activeUserChangingRate;
    }

    public void setActiveNewUserNum(int activeNewUserNum) {
        this.activeNewUserNum = activeNewUserNum;
    }

    public void setActiveNewUserRate(double activeNewUserRate) {
        this.activeNewUserRate = activeNewUserRate;
    }

    public void setActiveOldUserRate(double activeOldUserRate) {
        this.activeOldUserRate = activeOldUserRate;
    }

    public void setIosActiveUserNum(int iosActiveUserNum) {
        this.iosActiveUserNum = iosActiveUserNum;
    }

    public void setIosActiveUserRate(double iosActiveUserRate) {
        this.iosActiveUserRate = iosActiveUserRate;
    }

    public void setAndroidActiveUserRate(double androidActiveUserRate) {
        this.androidActiveUserRate = androidActiveUserRate;
    }

    public void setChannelActiveDataList(List<ChannelDataVO> channelActiveDataList) {
        this.channelActiveDataList = channelActiveDataList;
    }

    public void setActiveAppStartOnceUserNum(double activeAppStartOnceUserNum) {
        this.activeAppStartOnceUserNum = activeAppStartOnceUserNum;
    }

    public void setActiveAppStartOnceUserRate(double activeAppStartOnceUserRate) {
        this.activeAppStartOnceUserRate = activeAppStartOnceUserRate;
    }

    public void setIncreaseLoyaltyUserNum(int increaseLoyaltyUserNum) {
        this.increaseLoyaltyUserNum = increaseLoyaltyUserNum;
    }

    public void setIncreaseLeaveUserNum(int increaseLeaveUserNum) {
        this.increaseLeaveUserNum = increaseLeaveUserNum;
    }

    public void setIncreaseReflowUserNum(int increaseReflowUserNum) {
        this.increaseReflowUserNum = increaseReflowUserNum;
    }

    public UserSynopsisActiveDataDTO() {
    }

    @ConstructorProperties(value={"activeUserNum", "compareActiveUserNum", "activeUserChangingRate", "activeNewUserNum", "activeNewUserRate", "activeOldUserRate", "iosActiveUserNum", "iosActiveUserRate", "androidActiveUserRate", "channelActiveDataList", "activeAppStartOnceUserNum", "activeAppStartOnceUserRate", "increaseLoyaltyUserNum", "increaseLeaveUserNum", "increaseReflowUserNum"})
    public UserSynopsisActiveDataDTO(int activeUserNum, int compareActiveUserNum, double activeUserChangingRate, int activeNewUserNum, double activeNewUserRate, double activeOldUserRate, int iosActiveUserNum, double iosActiveUserRate, double androidActiveUserRate, List<ChannelDataVO> channelActiveDataList, double activeAppStartOnceUserNum, double activeAppStartOnceUserRate, int increaseLoyaltyUserNum, int increaseLeaveUserNum, int increaseReflowUserNum) {
        this.activeUserNum = activeUserNum;
        this.compareActiveUserNum = compareActiveUserNum;
        this.activeUserChangingRate = activeUserChangingRate;
        this.activeNewUserNum = activeNewUserNum;
        this.activeNewUserRate = activeNewUserRate;
        this.activeOldUserRate = activeOldUserRate;
        this.iosActiveUserNum = iosActiveUserNum;
        this.iosActiveUserRate = iosActiveUserRate;
        this.androidActiveUserRate = androidActiveUserRate;
        this.channelActiveDataList = channelActiveDataList;
        this.activeAppStartOnceUserNum = activeAppStartOnceUserNum;
        this.activeAppStartOnceUserRate = activeAppStartOnceUserRate;
        this.increaseLoyaltyUserNum = increaseLoyaltyUserNum;
        this.increaseLeaveUserNum = increaseLeaveUserNum;
        this.increaseReflowUserNum = increaseReflowUserNum;
    }

    public int getActiveUserNum() {
        return this.activeUserNum;
    }

    public double getActiveUserChangingRate() {
        return this.activeUserChangingRate;
    }

    public double getActiveNewUserRate() {
        return this.activeNewUserRate;
    }

    public double getActiveOldUserRate() {
        return this.activeOldUserRate;
    }

    public double getIosActiveUserRate() {
        return this.iosActiveUserRate;
    }

    public double getAndroidActiveUserRate() {
        return this.androidActiveUserRate;
    }

    public List<ChannelDataVO> getChannelActiveDataList() {
        return this.channelActiveDataList;
    }

    public double getActiveAppStartOnceUserRate() {
        return this.activeAppStartOnceUserRate;
    }

    public int getIncreaseLoyaltyUserNum() {
        return this.increaseLoyaltyUserNum;
    }

    public int getIncreaseLeaveUserNum() {
        return this.increaseLeaveUserNum;
    }

    public int getIncreaseReflowUserNum() {
        return this.increaseReflowUserNum;
    }
}

