/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.entity.analysis.dto;

import com.ellabook.entity.analysis.vo.ChannelDataVO;
import com.ellabook.util.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseUserSynopsisDataDTO {
    protected static List<String> iosChannelNames = Arrays.asList("APPLE_STORE", "IOS");
    private static final int scale = 2;

    protected double sub(double total, double percent) {
        return this.sub(total, percent, 2);
    }

    private double sub(double total, double percent, int scale) {
        return BigDecimalUtil.sub(new BigDecimal(total), new BigDecimal(percent), scale).doubleValue();
    }

    private double div(double value, double divisor, int scale) {
        return BigDecimalUtil.div(value, divisor, scale);
    }

    protected double percent(double v, double divisor) {
        if (divisor == 0.0) {
            return 0.0;
        }
        return this.div(v * 100.0, divisor, 2);
    }

    protected double percentScale(double v, double divisor) {
        if (divisor == 0.0) {
            return 0.0;
        }
        return this.div(v * 100.0, divisor, 8);
    }

    protected double leftPercentScale(double divisor, double v) {
        if (divisor <= 0.0) {
            return 0.0;
        }
        return this.percent(divisor - v, divisor);
    }

    protected double percent(BigDecimal value, BigDecimal divisor) {
        if (divisor == null || value == null || divisor.doubleValue() == 0.0) {
            return 0.0;
        }
        return BigDecimalUtil.div(value.multiply(new BigDecimal(100)), divisor, 2).doubleValue();
    }

    protected static boolean ifIOS(String channelDataVOName) {
        return iosChannelNames.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n, (CharSequence)channelDataVOName));
    }

    public static boolean toChannelFilter(ChannelDataVO e) {
        return !BaseUserSynopsisDataDTO.ifIOS(e.getChannelName()) && e.getChannelRate() > 0.0;
    }
}

