/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.constraint.validation;

import com.ellabook.constraint.annotation.DefaultURL;
import java.net.MalformedURLException;
import java.net.URL;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DefaultURLValidator
implements ConstraintValidator<DefaultURL, CharSequence> {
    private String protocol;
    private String host;
    private int port;

    public void initialize(DefaultURL url) {
        this.protocol = url.protocol();
        this.host = url.host();
        this.port = url.port();
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        URL url;
        if (value == null || value.length() == 0) {
            return false;
        }
        try {
            url = new URL(value.toString());
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (this.protocol != null && this.protocol.length() > 0 && !url.getProtocol().equals(this.protocol)) {
            return false;
        }
        if (this.host != null && this.host.length() > 0 && !url.getHost().equals(this.host)) {
            return false;
        }
        return this.port == -1 || url.getPort() == this.port;
    }
}

