/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.constraint.inf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassUtil {
    public static List<Class<?>> getAllAssignedClass(Class<?> cls) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        for (Class<?> c : ClassUtil.getClasses(cls)) {
            if (!cls.isAssignableFrom(c) || cls.equals(c)) continue;
            classes.add(c);
        }
        return classes;
    }

    public static List<Class<?>> getClasses(Class<?> cls) throws IOException, ClassNotFoundException {
        String pk = cls.getPackage().getName();
        String path = pk.replace('.', '/');
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        URL url = classloader.getResource(path);
        return ClassUtil.getClasses(new File(url.getFile()), pk);
    }

    private static List<Class<?>> getClasses(File dir, String pk) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!dir.exists()) {
            return classes;
        }
        for (File f : dir.listFiles()) {
            String name;
            if (f.isDirectory()) {
                classes.addAll(ClassUtil.getClasses(f, pk + "." + f.getName()));
            }
            if (!(name = f.getName()).endsWith(".class")) continue;
            classes.add(Class.forName(pk + "." + name.substring(0, name.length() - 6)));
        }
        return classes;
    }
}

