/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.aspect;

import com.ellabook.util.redis.RedisServiceUtil;
import com.ellabook.util.redis.RedisZone;
import com.ellabook.util.redis.RedisZoneEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class RedisAspect {
    @Pointcut(value="@annotation(com.ellabook.util.redis.RedisZone)")
    public void redisPointcut() {
    }

    @Around(value="redisPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        LinkedHashMap<RedisServiceUtil, Integer> map = new LinkedHashMap<RedisServiceUtil, Integer>();
        try {
            Object proceed;
            Object obj = joinPoint.getTarget();
            Class<?> clz = obj.getClass();
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; fields != null && i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                Object fieldObj = field.get(obj);
                if (!(fieldObj instanceof RedisServiceUtil)) continue;
                RedisServiceUtil redis = (RedisServiceUtil)fieldObj;
                map.put(redis, redis.getDatabase());
                Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
                RedisZone redisZone = method.getAnnotation(RedisZone.class);
                redisZone = redisZone == null ? field.getAnnotation(RedisZone.class) : redisZone;
                RedisZone redisZone2 = redisZone = redisZone == null ? clz.getAnnotation(RedisZone.class) : redisZone;
                if (redisZone == null) continue;
                method = redis.getClass().getSuperclass().getDeclaredMethod("setDatabase", RedisZoneEnum.class);
                method.setAccessible(true);
                method.invoke((Object)redis, new Object[]{redisZone.value()});
            }
            object = proceed = joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                for (Map.Entry next : map.entrySet()) {
                    RedisServiceUtil redis = (RedisServiceUtil)next.getKey();
                    Method method = redis.getClass().getSuperclass().getDeclaredMethod("setDatabase", RedisZoneEnum.class);
                    method.setAccessible(true);
                    method.invoke((Object)redis, new Object[]{RedisZoneEnum.getRedisZoneEnum((Integer)next.getValue())});
                }
                throw throwable;
            }
        }
        for (Map.Entry next : map.entrySet()) {
            RedisServiceUtil redis = (RedisServiceUtil)next.getKey();
            Method method = redis.getClass().getSuperclass().getDeclaredMethod("setDatabase", RedisZoneEnum.class);
            method.setAccessible(true);
            method.invoke((Object)redis, new Object[]{RedisZoneEnum.getRedisZoneEnum((Integer)next.getValue())});
        }
        return object;
    }
}

