/*
 * Decompiled with CFR 0.152.
 */
package com.ellabook.aspect;

import com.ellabook.aspect.AvoidConcurrent;
import com.ellabook.entity.ResponseParams;
import com.ellabook.util.ResponseParamsUtil;
import com.ellabook.util.redis.RedisServiceUtil;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentAspect.class);
    private ResponseParamsUtil responseParamsUtil = new ResponseParamsUtil();
    protected static final long expireTime = 10L;
    protected RedisServiceUtil redis;

    @Pointcut(value="@annotation(AvoidConcurrent)")
    public void concurrentPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="concurrentPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) throws Exception {
        String clazzName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        StringBuilder builder = new StringBuilder();
        String redisKey = "";
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        AvoidConcurrent avoidConcurrent = method.getAnnotation(AvoidConcurrent.class);
        String[] primaryKey = avoidConcurrent.primaryKey();
        if (primaryKey.length > 0) {
            builder.append(methodName);
            redisKey = avoidConcurrent.keyHelperClz().newInstance().getPrimaryKey(joinPoint);
            builder.append(redisKey);
            redisKey = builder.toString();
        }
        if (primaryKey.length < 1 || StringUtils.isBlank((CharSequence)redisKey)) {
            redisKey = ConcurrentAspect.getMethodKey(clazzName, methodName, args);
        }
        LOGGER.info("method {} concurrentPointcut key {}", (Object)methodName, (Object)redisKey);
        try {
            if (null == this.redis) {
                ResponseParams responseParams = (ResponseParams)joinPoint.proceed(args);
                return responseParams;
            }
            if (!StringUtils.isBlank((CharSequence)this.getRedisKey(redisKey, methodName))) {
                LOGGER.info("method {} concurrentPointcut get key {}", (Object)methodName, (Object)this.redis.get(redisKey));
                ResponseParams responseParams = this.responseParamsUtil.fail("\u8bf7\u7a0d\u540e...", null);
                return responseParams;
            }
            this.setRedisKey(redisKey, methodName);
            Object object = joinPoint.proceed(args);
            return object;
        }
        catch (Throwable e) {
            LOGGER.error("\u7cfb\u7edf\u5f02\u5e38", e);
            ResponseParams responseParams = this.responseParamsUtil.fail("\u7cfb\u7edf\u5f02\u5e38", "\u7cfb\u7edf\u5f02\u5e38");
            return responseParams;
        }
        finally {
            this.deleteRedisKey(redisKey, methodName);
        }
    }

    private String getRedisKey(String redisKey, String methodName) {
        try {
            LOGGER.info("method {} concurrentPointcut get key {}", (Object)methodName, (Object)redisKey);
            return this.redis.get(redisKey);
        }
        catch (Exception e) {
            LOGGER.error("method {} concurrentPointcut get key error{}", (Object)methodName, (Object)e);
            return "";
        }
    }

    private void setRedisKey(String redisKey, String methodName) {
        try {
            LOGGER.info("method {} concurrentPointcut set key {}", (Object)methodName, (Object)redisKey);
            this.redis.setNX(redisKey, methodName);
            this.redis.expire(redisKey, 10L);
        }
        catch (Exception e) {
            LOGGER.error("method {} concurrentPointcut set key error{}", (Object)methodName, (Object)e);
        }
    }

    private void deleteRedisKey(String redisKey, String methodName) {
        if (null == this.redis) {
            return;
        }
        try {
            LOGGER.info("method {} concurrentPointcut del key {}", (Object)methodName, (Object)redisKey);
            this.redis.del(redisKey);
        }
        catch (Exception e) {
            LOGGER.error("method {} concurrentPointcut del key error{}", (Object)methodName, (Object)e);
        }
    }

    public static String getMethodKey(String clazzName, String methodName, Object[] args) {
        StringBuilder key = new StringBuilder(clazzName);
        key.append(methodName);
        for (Object obj : args) {
            key.append(obj.toString().replace(".", "").replace(" ", "").replace(",", "").replace("\"", "").replace(":", ""));
        }
        return key.toString();
    }
}

