/*
 * Decompiled with CFR 0.152.
 */
package com.bbk.util;

import com.alibaba.fastjson.JSONObject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);

    public static Map<String, String> getUrlMap(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        URL urls = null;
        try {
            urls = new URL(url);
            String param = urls.getQuery();
            if (StringUtils.isNotBlank((CharSequence)param)) {
                String[] arr;
                for (String s : arr = param.split("&")) {
                    String key = s.split("=")[0];
                    String value = s.split("=")[1];
                    map.put(key, value);
                }
            }
        }
        catch (MalformedURLException e) {
            log.warn("getUrlMap", (Object)("MalformedURLException e={}" + e));
        }
        return map;
    }

    public static String getMapToUrl(Map<String, String> params) {
        StringBuilder urlParams = new StringBuilder("?");
        params.forEach((k, v) -> urlParams.append((String)k).append("=").append((String)v).append("&"));
        String urlParamsStr = urlParams.toString();
        return urlParamsStr.substring(0, urlParamsStr.length() - 1);
    }

    public static String responseConvert(Map<String, String> resultMap) {
        String result = "";
        if (resultMap != null && !resultMap.isEmpty()) {
            String code = resultMap.get("code");
            if (StringUtils.isNotBlank((CharSequence)code) && code.equals("200")) {
                String body = resultMap.get("body");
                return body;
            }
            log.info(JSONObject.toJSONString(resultMap));
        }
        return result;
    }
}

