/*
 * Decompiled with CFR 0.152.
 */
package com.bbk.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesUtil.class);
    public static final String CBC_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String ENCODING = "UTF-8";
    private static final String KEY_ALGORITHM = "AES";

    public static String encrypt(String content, String encodeRules) {
        try {
            SecretKey key = (SecretKey)AesUtil.initKeyForAES(encodeRules);
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            cipher.init(1, (Key)key, new IvParameterSpec(encodeRules.getBytes(ENCODING)));
            byte[] contentEncodeByte = content.getBytes(ENCODING);
            byte[] contentAesByte = cipher.doFinal(contentEncodeByte);
            String contentAes = new BASE64Encoder().encode(contentAesByte);
            return contentAes;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        return null;
    }

    public static String decrypt(String content, String encodeRules) {
        try {
            SecretKey key = (SecretKey)AesUtil.initKeyForAES(encodeRules);
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            cipher.init(2, (Key)key, new IvParameterSpec(encodeRules.getBytes(ENCODING)));
            byte[] contentAes = new BASE64Decoder().decodeBuffer(content);
            byte[] contentEncodeByte = cipher.doFinal(contentAes);
            String contentSrc = new String(contentEncodeByte, ENCODING);
            return contentSrc;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (InvalidKeyException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (BadPaddingException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error(String.format("AES.encrypt failed.content:%s", content), (Throwable)e);
        }
        return null;
    }

    private static Key initKeyForAES(String key) {
        if (null == key || key.length() == 0) {
            throw new NullPointerException("key not is null");
        }
        SecretKeySpec secretKey = null;
        try {
            secretKey = new SecretKeySpec(key.getBytes(ENCODING), KEY_ALGORITHM);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(String.format("AES.initKeyForAES failed.key:%s", key), (Throwable)e);
        }
        return secretKey;
    }
}

