/*
 * Decompiled with CFR 0.152.
 */
package com.bbk.sign;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    public static String sign(String secret, String method, String path, Map<String, String> headers, Map<String, String> bodys) {
        return SignUtil.sign(secret, method, path, headers, null, bodys);
    }

    public static String sign(String secret, String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            byte[] keyBytes = secret.getBytes("UTF-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
            return new String(Base64.encodeBase64((byte[])hmacSha256.doFinal(SignUtil.buildStringToSign(method, path, headers, querys, bodys).getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String buildStringToSign(String method, String path, Map<String, String> headers, Map<String, String> querys, Map<String, String> bodys) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append("\n");
        if (null != headers) {
            if (null != headers.get("s-content-md5")) {
                sb.append(headers.get("s-content-md5"));
            }
            sb.append("\n");
            if (null != headers.get("Content-Type")) {
                sb.append(headers.get("Content-Type"));
            }
        }
        sb.append("\n");
        sb.append(SignUtil.buildHeaders(headers));
        sb.append(SignUtil.buildResource(path, querys, bodys));
        return sb.toString();
    }

    private static String buildResource(String path, Map<String, String> querys, Map<String, String> bodys) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)path)) {
            sb.append(path);
        }
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        if (null != querys) {
            for (Map.Entry<String, String> query : querys.entrySet()) {
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sortMap.put(query.getKey(), query.getValue());
            }
        }
        if (null != bodys) {
            for (Map.Entry<String, String> body : bodys.entrySet()) {
                if (StringUtils.isBlank((CharSequence)body.getKey())) continue;
                sortMap.put(body.getKey(), body.getValue());
            }
        }
        StringBuilder sbParam = new StringBuilder();
        for (Map.Entry item : sortMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)item.getKey()))) continue;
            if (0 < sbParam.length()) {
                sbParam.append("&");
            }
            sbParam.append((String)item.getKey());
            if (StringUtils.isBlank((CharSequence)((CharSequence)item.getValue()))) continue;
            sbParam.append("=").append((String)item.getValue());
        }
        if (0 < sbParam.length()) {
            sb.append("?");
            sb.append((CharSequence)sbParam);
        }
        return sb.toString();
    }

    private static String buildHeaders(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        if (null != headers) {
            headers.remove("s-sign");
            headers.remove("s-content-md5");
            headers.remove("Content-Type");
            TreeMap<String, String> sortMap = new TreeMap<String, String>();
            sortMap.putAll(headers);
            StringBuilder signHeadersStringBuilder = new StringBuilder();
            for (Map.Entry header : sortMap.entrySet()) {
                if (!SignUtil.isHeaderToSign((String)header.getKey())) continue;
                sb.append(((String)header.getKey()).toLowerCase());
                sb.append(":");
                if (!StringUtils.isBlank((CharSequence)((CharSequence)header.getValue()))) {
                    sb.append((String)header.getValue());
                }
                sb.append("\n");
                if (0 < signHeadersStringBuilder.length()) {
                    signHeadersStringBuilder.append(",");
                }
                signHeadersStringBuilder.append((String)header.getKey());
            }
            headers.put("X-Ca-Signature-Headers", signHeadersStringBuilder.toString());
        }
        return sb.toString();
    }

    private static String buildHeaders(Map<String, String> headers, List<String> signHeaderPrefixList) {
        StringBuilder sb = new StringBuilder();
        if (null != signHeaderPrefixList) {
            signHeaderPrefixList.remove("s-sign");
            signHeaderPrefixList.remove("Accept");
            signHeaderPrefixList.remove("s-content-md5");
            signHeaderPrefixList.remove("Content-Type");
            signHeaderPrefixList.remove("Date");
            Collections.sort(signHeaderPrefixList);
            if (null != headers) {
                TreeMap<String, String> sortMap = new TreeMap<String, String>();
                sortMap.putAll(headers);
                StringBuilder signHeadersStringBuilder = new StringBuilder();
                for (Map.Entry header : sortMap.entrySet()) {
                    if (!SignUtil.isHeaderToSign((String)header.getKey(), signHeaderPrefixList)) continue;
                    sb.append((String)header.getKey());
                    sb.append(":");
                    if (!StringUtils.isBlank((CharSequence)((CharSequence)header.getValue()))) {
                        sb.append((String)header.getValue());
                    }
                    sb.append("\n");
                    if (0 < signHeadersStringBuilder.length()) {
                        signHeadersStringBuilder.append(",");
                    }
                    signHeadersStringBuilder.append((String)header.getKey());
                }
                headers.put("X-Ca-Signature-Headers", signHeadersStringBuilder.toString());
            }
        }
        return sb.toString();
    }

    public static boolean isHeaderToSign(String headerName) {
        if (StringUtils.isBlank((CharSequence)headerName)) {
            return false;
        }
        if ("s-sign".equals(headerName)) {
            return false;
        }
        if (headerName.startsWith("s-")) {
            return true;
        }
        return headerName.startsWith("u-");
    }

    private static boolean isHeaderToSign(String headerName, List<String> signHeaderPrefixList) {
        if (StringUtils.isBlank((CharSequence)headerName)) {
            return false;
        }
        if (headerName.startsWith("s-")) {
            return true;
        }
        if (headerName.startsWith("u-")) {
            return true;
        }
        if (null != signHeaderPrefixList) {
            for (String signHeaderPrefix : signHeaderPrefixList) {
                if (!headerName.equalsIgnoreCase(signHeaderPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

