/*
 * Decompiled with CFR 0.152.
 */
package com.analysis.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;

public class DateUtil {
    public static String DATE_DAY_PATTERN = "yyyy-MM-dd";
    public static String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static String MILLIS_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss:SSS";
    static SimpleDateFormat dayFormat = new SimpleDateFormat(DATE_DAY_PATTERN);
    static SimpleDateFormat timeFormat = new SimpleDateFormat(TIME_PATTERN);
    static SimpleDateFormat millisFormat = new SimpleDateFormat(MILLIS_TIME_PATTERN);

    public static long getCurrentHoursHavePassed(String date) {
        long hour;
        if (DateUtil.getCurrentDayToStr().equals(date)) {
            LocalDateTime midnight = LocalDateTime.now().plusDays(0L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            hour = ChronoUnit.HOURS.between(midnight, LocalDateTime.now());
        } else {
            hour = DateUtil.getBetweenTime(DateUtil.getCurrentDayToStr(), date) > 0L ? 0L : 24L;
        }
        return hour;
    }

    public static String getDateFormatToStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date.getTime());
    }

    public static String getDateFormat(String date, String type) {
        if (StringUtils.isNotBlank((String)date)) {
            if (type.equals("date") && date.length() >= 8) {
                date = DateUtil.dateStrSub(date, "date");
            } else if (type.equals("time") && date.length() >= 14) {
                date = DateUtil.dateStrSub(date, "time");
            } else if (type.equals("datetime") && date.length() >= 14) {
                date = DateUtil.dateStrSub(date, "date") + " " + DateUtil.dateStrSub(date, "time");
            }
        }
        return date;
    }

    public static String dateStrSub(String date, String type) {
        String subDate = "";
        if (type.equals("date") && date.length() >= 8) {
            subDate = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        } else if (type.equals("date") && date.length() == 8) {
            subDate = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6);
        } else if (type.equals("time") && date.length() > 14) {
            subDate = date.substring(8, 10) + ":" + date.substring(10, 12) + ":" + date.substring(12, 14);
        } else if (type.equals("time") && date.length() >= 14) {
            subDate = date.substring(8, 10) + ":" + date.substring(10, 12) + ":" + date.substring(12);
        }
        return subDate;
    }

    @Test
    public void test1() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse("20190115184743");
            System.out.println(sdf.format(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static String getNextDayToStr() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        calendar.set(5, day + 1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getCurrentDayToStr() {
        Calendar calendar = Calendar.getInstance();
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        calendar.set(5, day - 1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getLastWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.setTime(calendar.getTime());
        calendar.add(7, -7);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getLastWeekLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.setTime(calendar.getTime());
        calendar.add(7, -1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getCurrentWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getNextWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.setTime(calendar.getTime());
        calendar.add(7, 7);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getLastMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getLastMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 0);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getCurrentMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getCurrentMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 1);
        calendar.set(5, 0);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getNextMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 1);
        calendar.set(5, 1);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static String getNextMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 2);
        calendar.set(5, 0);
        return DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    public static Date getCurrentDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Date getNextDay() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        calendar.set(5, day + 1);
        return calendar.getTime();
    }

    public static Date getLastDay() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        calendar.set(5, day - 1);
        return calendar.getTime();
    }

    public static Date getLastWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.setTime(calendar.getTime());
        calendar.add(7, -7);
        return calendar.getTime();
    }

    public static Date getLastWeekLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 1);
        calendar.setTime(calendar.getTime());
        calendar.add(7, -7);
        return calendar.getTime();
    }

    public static Date getCurrentWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getNextWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        calendar.setTime(calendar.getTime());
        calendar.add(7, 7);
        return calendar.getTime();
    }

    public static Date getLastMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getLastMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date getCurrentMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getCurrentMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date getNextMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getNextMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, 2);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static long getExpireTime(String dateType) {
        long expireTime = 0L;
        if (dateType.equals("DAY")) {
            expireTime = DateUtil.getTimeByDate(DateUtil.getNextDay()) - new Date().getTime();
        } else if (dateType.equals("WEEK")) {
            expireTime = DateUtil.getTimeByDate(DateUtil.getNextWeekFirstDay()) - new Date().getTime();
        } else if (dateType.equals("MONTH")) {
            expireTime = DateUtil.getTimeByDate(DateUtil.getNextMonthFirstDay()) - new Date().getTime();
        }
        return expireTime / 1000L;
    }

    public static long getTimeByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static String getFistDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            calendar.set(5, 1);
            firstDay = DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    public static String getLastDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
            firstDay = DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    public static String getDayOfWeek(String date, String type) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            int d = 0;
            d = calendar.get(7) == 1 ? -7 : 2 - calendar.get(7);
            calendar.add(7, d);
            if (type.equals("LAST_DAY")) {
                calendar.add(7, 6);
            }
            firstDay = DateUtil.getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    public static Date geLastWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getCurrentWeekMonday(date));
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getCurrentWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getBeforeWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getCurrentWeekMonday(date));
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getMonthFirstDay() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(5, 1);
        return calendar1.getTime();
    }

    public static Date getMonthLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static Date beforeMonthFirstDay() {
        Calendar calendar5 = Calendar.getInstance();
        int maxCurrentMonthDay = calendar5.getActualMaximum(5);
        calendar5.add(5, -maxCurrentMonthDay);
        calendar5.set(5, 1);
        return calendar5.getTime();
    }

    public static Date beforeMonthLastDay() {
        Calendar calendar6 = Calendar.getInstance();
        int maxCurrentMonthDay = calendar6.getActualMaximum(5);
        calendar6.add(5, -maxCurrentMonthDay);
        maxCurrentMonthDay = calendar6.getActualMaximum(5);
        calendar6.set(5, maxCurrentMonthDay);
        return calendar6.getTime();
    }

    public static Date getBeforeDay(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getSundayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 7);
        return c.getTime();
    }

    public static Integer getDayBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer dayNum = 0;
        try {
            Date start = format.parse(startDate);
            Date end = format.parse(endDate);
            dayNum = (int)((end.getTime() - start.getTime()) / 86400000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dayNum;
    }

    public static Integer getDayBetweenNum(String startDate, String endDate, String currentDate) {
        long time = DateUtil.getBetweenTime(currentDate, endDate);
        if (time >= 0L) {
            endDate = currentDate;
        }
        Integer dayNum = DateUtil.getDayBetweenNum(startDate, endDate);
        return dayNum;
    }

    public static Integer getWeekBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer weekNum = 0;
        try {
            long start = format.parse(startDate).getTime();
            long end = format.parse(endDate).getTime();
            weekNum = (int)((end - start) / 604800000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return weekNum;
    }

    public static Integer getMonthBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer monthNum = 0;
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            startCalendar.setTime(format.parse(startDate));
            endCalendar.setTime(format.parse(endDate));
            monthNum = DateUtil.getYearBetweenNum(startDate, endDate) * 12 + endCalendar.get(2) - startCalendar.get(2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return monthNum;
    }

    public static int getYearBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        int yearNum = 0;
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            startCalendar.setTime(format.parse(startDate));
            endCalendar.setTime(format.parse(endDate));
            yearNum = endCalendar.get(1) - startCalendar.get(1);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return yearNum;
    }

    public static String getNextDateToStr(String startTimeStr, Integer feild, Integer amount) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date endTime = null;
        try {
            Date startTime = format.parse(startTimeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(feild, amount);
            endTime = calendar.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return format.format(endTime);
    }

    public static Integer dayNumConvert(String date, String dateType) {
        Integer num = 0;
        if (dateType.equals("DAY")) {
            num = DateUtil.getDayBetweenNum(date, DateUtil.getCurrentDayToStr());
        } else if (dateType.equals("WEEK")) {
            num = DateUtil.getWeekBetweenNum(DateUtil.getDayOfWeek(date, "FIRST_DAY"), DateUtil.getCurrentDayToStr());
        } else if (dateType.equals("MONTH")) {
            num = DateUtil.getMonthBetweenNum(date, DateUtil.getCurrentDayToStr());
        }
        return num;
    }

    public static String cleanTimeConvert(String date, String dateType, String type) {
        String cleanTime = "";
        if (dateType.equals("DAY")) {
            cleanTime = date;
        } else if (dateType.equals("WEEK")) {
            cleanTime = DateUtil.getDayOfWeek(date, type);
        } else if (dateType.equals("MONTH")) {
            if (type.equals("FIRST_DAY")) {
                cleanTime = DateUtil.getFistDayOfMonth(date);
            } else if (type.equals("LAST_DAY")) {
                cleanTime = DateUtil.getLastDayOfMonth(date);
            }
        }
        return cleanTime;
    }

    public static long getBetweenTime(String beginTime, String endTime) {
        long time = DateUtil.getTimeByDate(DateUtil.getStrToDate(endTime)) - DateUtil.getTimeByDate(DateUtil.getStrToDate(beginTime));
        return time;
    }

    public static Date getStrToDate(String date) {
        Date convertDate = new Date();
        try {
            convertDate = dayFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return convertDate;
    }
}

