package com.huawei.entity;

import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;

/**
 * @author ：xixiaoyi
 * @date ：Created by 2020/8/14
 * @modified By：
 */
public class CourseDelivery {
    private static final String ERROR_MSG = "不能为空";
    @NotBlank(message = ERROR_MSG)
    private String developerId;
    private String appId;
    @NotBlank(message = ERROR_MSG)
    private String orderId;
    @NotBlank(message = ERROR_MSG)
    private String productNo;
    @NotBlank(message = ERROR_MSG)
    private String openId;
    @Min(value = 1, message = "购买数量必须是整数，且最小值是1")
    @NotBlank(message = ERROR_MSG)
    private String count;
    @NotBlank(message = ERROR_MSG)
    @Pattern(regexp = "\\d{13}||\\d{10}", message = "时间戳错误")
    private String ts;

    public String getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(String developerId) {
        this.developerId = developerId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getProductNo() {
        return productNo;
    }

    public void setProductNo(String productNo) {
        this.productNo = productNo;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getCount() {
        return count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getTs() {
        return ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }
}
