package com.ellabook.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class userRoleUtil {

    public static boolean matchingRoleByUid(String userRole, String targetRole) {
        if (StringUtils.equalsIgnoreCase(targetRole, "ALL") || StringUtils.isEmpty(targetRole)) {
            return true;
        }
        List<String> userRoleList = Arrays.asList(userRole.split(","));
        userRoleList = userRoleList.stream().filter(r -> StringUtils.isNotEmpty(r)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userRoleList)) {
            return false;
        }
        List<String> targetRoleList = Arrays.asList(targetRole.split(","));
        if (CollectionUtils.isEmpty(targetRoleList)) {
            return true;
        }
        if (CollectionUtils.intersection(userRoleList, targetRoleList).size() > 0) {
            return true;
        }
        return false;
    }
}
