package com.ellabook.util.doc.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ellabook.util.doc.inf.Table;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author mc
 * @date 2018/7/13
 */
public class TableFromJson implements Table {
    List<String> list;
    String type;
    String groupId;
    String fieldName;
    Object fieldObj;
    String necessary;
    String docTypeAlias;
    String explain;

    public TableFromJson() {
    }

    public TableFromJson(List<String> list, String groupId, String type, String fieldName, Object fieldObj) {
        this.list = list;
        this.groupId = groupId;
        this.type = type;
        this.fieldName = fieldName;
        this.fieldObj = fieldObj;
    }

    @Override
    public void setTitle() {
        list.add("**" + fieldName + "说明：** ");
        list.add("");
        if ("param".equalsIgnoreCase(type)) {
            list.add("|参数名|必选|类型|说明|");
            list.add("|:----    |:---:|:-----: |-----   |");
            list.add("| ==========| ==== | ====|  ========================================  |");
        } else {
            list.add("|参数名|类型|说明|");
            list.add("|:----  |:---: |-----   |");
            list.add("| ==========| ==== | =====================================================  |");
        }
    }

    @Override
    public StringBuilder setElementTitle() {
        StringBuilder sb = new StringBuilder();
        if ("param".equalsIgnoreCase(type)) {
            sb.append("|").append(fieldName).append("|").append(necessary).append("|").append(docTypeAlias).append("|").append(explain).append("|");
        } else {
            sb.append("|").append(fieldName).append("|").append(docTypeAlias).append("|").append(explain).append("|");
        }
        return sb;
    }

    @Override
    public void create() throws Exception {
        Map<String, Object> objects = new HashMap<>();
        setTitle();
        JSONObject object = getJsonObject(fieldObj);
        object.entrySet().iterator().forEachRemaining(entry -> {
            docTypeAlias = "string";
            fieldName = entry.getKey();
            necessary = "是";
            explain = "   ";
            StringBuilder sb = setElementTitle();
            list.add(sb.toString());
            try {
                JSONObject jsonObject = getJsonObject(entry.getValue());
                if (!jsonObject.isEmpty())
                    objects.put(entry.getKey(), entry.getValue());
            } catch (Exception e) {
                //ignore
            }
        });
        list.add("");
        Iterator<Map.Entry<String, Object>> iterator = objects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            fieldName = next.getKey();
            fieldObj = next.getValue();
            this.create();
        }

    }

    public JSONObject getJsonObject(Object jsonObj) {
        String json = JSONObject.toJSONString(jsonObj, SerializerFeature.WriteMapNullValue);
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = StringUtils.isBlank(json) ? jsonObject : JSONObject.parseObject(json);
        } catch (Exception e) {
            try {
                JSONArray array = StringUtils.isBlank(json) ? new JSONArray() : JSONObject.parseArray(json);
                if (array.size() > 0) {
                    jsonObject = JSONObject.parseObject(JSONObject.toJSONString(array.get(0), SerializerFeature.WriteMapNullValue));
                }
            } catch (Exception e1) {
                //Ignore
            }
        }
        return jsonObject;
    }
}
