package com.ellabook.util.doc;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.util.FileUtil;
import com.ellabook.util.doc.enums.DocPage;
import com.ellabook.util.doc.enums.EllaProject;
import com.ellabook.util.doc.enums.TableHelper;
import com.ellabook.util.doc.impl.DocImpl;
import com.ellabook.util.doc.impl.SampleImpl;
import com.ellabook.util.doc.impl.TableFromClz;
import com.ellabook.util.doc.impl.TableFromJson;
import com.ellabook.util.doc.inf.Doc;
import com.ellabook.util.doc.inf.Sample;
import com.ellabook.util.doc.inf.Table;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;

/**
 * @author mc
 * @date 2018/7/13
 */
public class DocFactory {
    private Class<?> paramClass = Object.class;
    private Class<?> responseClass = Object.class;
    private Object param = "{}";
    private Object response = "{}";
    private DocEntity docEntity;
    private String fileName;
    private String remark;
    private String groupId;
    private List<String> list;
    private Doc doc;
    private Sample sample;
    private Table table;
    private DocPage docPage;
    private EllaProject ellaProject;

    public DocFactory setEllaProject(EllaProject ellaProject) {
        this.ellaProject = ellaProject;
        return this;
    }

    public static DocFactory instance() {
        return new DocFactory();
    }

    public DocFactory setParamAndResponseClz(Class<?> paramClass, Class<?> responseClass) {
        this.paramClass = paramClass == null ? this.paramClass : paramClass;
        this.responseClass = responseClass == null ? this.responseClass : responseClass;
        return this;
    }

    public <P, R> DocFactory setParamAndResponse(P param, R response) {
        this.param = param == null ? this.param : param;
        this.response = response == null ? this.response : response;
        try {
            this.remark = BeanUtils.getNestedProperty(response, "remark");
        } catch (Exception e) {
            this.remark = "";
        }
        return this;
    }

    public DocFactory setDocAndFileName(DocEntity docEntity, String fileName) {
        this.docEntity = docEntity;
        this.fileName = fileName;
        return this;
    }

    public DocFactory setFieldGroups(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public void create(TableHelper tableType) throws Exception {
        this.create(DocImpl.class, tableType.getClz(), SampleImpl.class);
    }

    public void create(Class<? extends Doc> docClz, Class<? extends Table> tableClz, Class<? extends Sample> sampleClz) throws Exception {
        this.list = new LinkedList<>();
        File file = FileUtil.createFile(".." + File.separator + "doc" + File.separator + fileName + ".txt", File.separator);
        this.createDoc(docClz);
        this.addTable(tableClz, "param", "传参");
        this.addSample(sampleClz, param, "传参");
        this.addTable(tableClz, "response", "返参");
        this.addSample(sampleClz, response, "返参");
        IOUtils.writeLines(list, IOUtils.LINE_SEPARATOR, new FileOutputStream(file), "UTF-8");
        this.upload();
    }

    public void upload() throws Exception {
        this.docPage = docPage == null ? DocPage.ELLA_APP_PAGE : docPage;
        if (ellaProject == null || ellaProject.equals(EllaProject.EMPTY)) {
            throw new RuntimeException("ellaProject id can't be null or empty!");
        }
        this.docPage.setItemId(ellaProject);
        StringBuilder sb = new StringBuilder();
        list.forEach(str -> sb.append(str + "\n"));
        docPage.setPageContent(URLEncoder.encode(sb.toString(), "UTF-8"));
        docPage.setPageTitle(remark);
        DocClient.uploadDoc(docPage);
    }

    public void createDoc(Class<? extends Doc> docClz) {
        if (docClz == DocImpl.class) {
            doc = new DocImpl(list, docEntity);
            doc.create();
        }
    }

    public void addSample(Class<? extends Sample> sampleClz, Object obj, String name) {
        if (sampleClz == SampleImpl.class) {
            sample = new SampleImpl(list, name, obj);
            sample.create();
        }
    }

    public void addTable(Class<? extends Table> tableClz, String type, String fieldName) throws Exception {
        Class<?> clz = "param".equalsIgnoreCase(type) ? paramClass : responseClass;
        Object obj = "param".equalsIgnoreCase(type) ? param : response;
        if (tableClz == TableFromClz.class) {
            table = new TableFromClz(list, groupId, type, fieldName, clz.newInstance());
            table.create();
        }

        if (tableClz == TableFromJson.class) {
            table = new TableFromJson(list, groupId, type, fieldName, obj);
            table.create();
        }
    }


    private void setResponse() throws InstantiationException, IllegalAccessException {
        try {
            response = JSONObject.parseObject(JSONObject.toJSONString(response), responseClass);
        } catch (Exception e) {
            try {
                response = JSONObject.parseArray(JSONObject.toJSONString(response), responseClass);
            } catch (Exception e1) {
                response = responseClass.newInstance();
            }
        }
    }

    public DocPage getDocPage() {
        return docPage;
    }

    public void setDocPage(DocPage docPage) {
        this.docPage = docPage;
    }
}
