package com.ellabook.util;

import com.ellabook.entity.AccessToken;
import com.ellabook.entity.business.KeyNote;
import com.ellabook.entity.business.NoticeMessage;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

import static com.ellabook.util.WXPayConstant.*;

public class WeiXinUtil {

    private static Logger log = LoggerFactory.getLogger(WeiXinUtil.class);
    //微信的请求url
    //获取access_token的接口地址（GET） 限200（次/天）
    public final static String access_token_url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={appid}&secret={secret}";
    public static String uploadTempMaterial_url = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";


    /**
     * 1.发起https请求并获取结果
     *
     * @param requestUrl    请求地址
     * @param requestMethod 请求方式（GET、POST）
     * @param outputStr     提交的数据
     * @return JSONObject(通过JSONObject.get ( key)的方式获取json对象的属性值)
     */
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            // 创建SSLContext对象，并使用我们指定的信任管理器初始化
            TrustManager[] tm = {new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new java.security.SecureRandom());
            // 从上述SSLContext对象中得到SSLSocketFactory对象
            SSLSocketFactory ssf = sslContext.getSocketFactory();

            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection) url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);

            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            // 设置请求方式（GET/POST）
            httpUrlConn.setRequestMethod(requestMethod);

            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }

            // 当有数据需要提交时
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                // 注意编码格式，防止中文乱码
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }

            // 将返回的输入流转换成字符串
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            // 释放资源
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject(buffer.toString());
        } catch (ConnectException ce) {
            log.error("Weixin server connection timed out.");
        } catch (Exception e) {
            log.error("https request error:{}", e);
        }
        return jsonObject;
    }

    /**
     * @param requestUrl 微信上传临时素材的接口url
     * @param file       要上传的文件
     * @return String  上传成功后，微信服务器返回的消息
     * @desc ：微信上传素材的请求方法
     */
    public static String httpRequest(String requestUrl, File file) {
        StringBuffer buffer = new StringBuffer();

        try {
            //1.建立连接
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection) url.openConnection();  //打开链接

            //1.1输入输出设置
            httpUrlConn.setDoInput(true);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setUseCaches(false); // post方式不能使用缓存
            //1.2设置请求头信息
            httpUrlConn.setRequestProperty("Connection", "Keep-Alive");
            httpUrlConn.setRequestProperty("Charset", "UTF-8");
            //1.3设置边界
            String BOUNDARY = "----------" + System.currentTimeMillis();
            httpUrlConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);

            // 请求正文信息
            // 第一部分：
            //2.将文件头输出到微信服务器
            StringBuilder sb = new StringBuilder();
            sb.append("--"); // 必须多两道线
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data;name=\"media\";filelength=\"" + file.length()
                    + "\";filename=\"" + file.getName() + "\"\r\n");
            sb.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] head = sb.toString().getBytes("utf-8");
            // 获得输出流
            OutputStream outputStream = new DataOutputStream(httpUrlConn.getOutputStream());
            // 将表头写入输出流中：输出表头
            outputStream.write(head);

            //3.将文件正文部分输出到微信服务器
            // 把文件以流文件的方式 写入到微信服务器中
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                outputStream.write(bufferOut, 0, bytes);
            }
            in.close();
            //4.将结尾部分输出到微信服务器
            byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");// 定义最后数据分隔线
            outputStream.write(foot);
            outputStream.flush();
            outputStream.close();


            //5.将微信服务器返回的输入流转换成字符串
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }

            bufferedReader.close();
            inputStreamReader.close();
            // 释放资源
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();


        } catch (IOException e) {
            System.out.println("发送POST请求出现异常！" + e);
            e.printStackTrace();
        }
        return buffer.toString();
    }

    /**
     * 2.发起http请求获取返回结果
     *
     * @param requestUrl 请求地址
     * @return
     */
    public static String httpRequest(String requestUrl) {
        StringBuffer buffer = new StringBuffer();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection) url.openConnection();

            httpUrlConn.setDoOutput(false);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);

            httpUrlConn.setRequestMethod("GET");
            httpUrlConn.connect();

            // 将返回的输入流转换成字符串
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            // 释放资源
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();

        } catch (Exception e) {
        }
        return buffer.toString();
    }


    /**
     * 3.获取access_token
     *
     * @param appid     凭证
     * @param appsecret 密钥
     * @return
     */
    public static AccessToken getAccessToken(String appid, String appsecret) {
        AccessToken accessToken = null;

        String requestUrl = access_token_url.replace("{appid}", appid).replace("{secret}", appsecret);
        JSONObject jsonObject = httpRequest(requestUrl, "GET", null);
        // 如果请求成功
        if (null != jsonObject) {
            try {
                accessToken = new AccessToken();
                accessToken.setToken(jsonObject.getString("access_token"));
                accessToken.setExpiresIn(jsonObject.getInt("expires_in"));
            } catch (JSONException e) {
                accessToken = null;
                // 获取token失败
                log.error("获取token失败 errcode:{} errmsg:{}", jsonObject.getInt("errcode"), jsonObject.getString("errmsg"));
            }
        }
        return accessToken;
    }


    /**
     * 3.获取微信的JSSDK配置信息
     * 方法名：getWxConfig</br>
     * 详述：获取微信的配置信息 </br>
     * 开发人员：souvc  </br>
     * 创建时间：2016-1-5  </br>
     *
     * @param request
     * @return 说明返回值含义
     */
    public static Map<String, Object> getWxConfig(HttpServletRequest request) {
        Map<String, Object> ret = new HashMap<String, Object>();

        String appId = "wxa0064ea657f80062"; // 必填，公众号的唯一标识
        String secret = "fcc960840df869ad1a46af7993784917";

        String requestUrl = request.getRequestURL().toString();
        String access_token = "";
        String jsapi_ticket = "";
        String timestamp = Long.toString(System.currentTimeMillis() / 1000); // 必填，生成签名的时间戳
        String nonceStr = UUID.randomUUID().toString(); // 必填，生成签名的随机串
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
        //使用http请求获取access_token
        JSONObject json = WeiXinUtil.httpRequest(url, "GET", null);
        System.out.println(" 获取access_token " + json);
        if (json != null) {
            //要注意，access_token需要缓存
            access_token = json.getString("access_token");
            //根据access_token获取jsapi_ticket
            url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + access_token + "&type=jsapi";
            json = WeiXinUtil.httpRequest(url, "GET", null);
            System.out.println("jsapi_ticket " + json);
            if (json != null) {
                jsapi_ticket = json.getString("ticket");
            }
        }
        String signature = "";
        // 注意这里参数名必须全部小写，且必须有序
        String sign = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonceStr + "&timestamp=" + timestamp + "&url=" + requestUrl;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(sign.getBytes("UTF-8"));
            signature = byteToHex(crypt.digest());
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret.put("appId", appId);
        ret.put("timestamp", timestamp);
        ret.put("nonceStr", nonceStr);
        ret.put("signature", signature);
        return ret;
    }

    public static Map<String, String> uploadTempMaterial(String accessToken, String type, String fileUrl) {
        Map<String, String> map = new HashMap<>();
        //1.创建本地文件
        File file = new File(fileUrl);
        String fileName = file.getName();
        //2.拼接请求url
        uploadTempMaterial_url = uploadTempMaterial_url.replace("ACCESS_TOKEN", accessToken)
                .replace("TYPE", type);

        //3.调用接口，发送请求，上传文件到微信服务器
        String result = WeiXinUtil.httpRequest(uploadTempMaterial_url, file);

        //4.json字符串转对象：解析返回值，json反序列化
        result = result.replaceAll("[\\\\]", "");
        System.out.println("result:" + result);
        JSONObject resultJSON = JSONObject.fromObject(result);

        //5.返回参数判断
        if (resultJSON != null) {
            if (resultJSON.get("media_id") != null) {
                System.out.println("上传" + type + "永久素材成功");
                map.put("fileName", fileName);
                map.put("media_id", resultJSON.get("media_id").toString());
                return map;
            } else {
                System.out.println("上传" + type + "永久素材失败");
            }
        }
        return null;
    }


    /**
     * 方法名：byteToHex</br>
     * 详述：字符串加密辅助方法 </br>
     * 开发人员：souvc  </br>
     * 创建时间：2016-1-5  </br>
     *
     * @param hash
     * @return 说明返回值含义
     */
    private static String byteToHex(final byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;

    }

    /**
     * 验证签名
     *
     * @param signature 验证签名的数据
     * @param timestamp 参数
     * @param nonce     参数
     * @return boolean
     */
    public static boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        //TOKEN
        //与token 比较
        String[] arr = new String[]{token, timestamp, nonce};
        // 将token、timestamp、nonce三个参数进行字典排序
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; i++) {
            content.append(arr[i]);
        }
        MessageDigest md = null;
        String tmpStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");

            // 将三个参数字符串拼接成一个字符串进行sha1加密
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = byteToStr(digest);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        content = null;
        // 将sha1加密后的字符串可与signature对比
        return tmpStr != null ? tmpStr.equals(signature.toUpperCase()) : false;
    }


    /**
     * 将字节数组转换为十六进制字符串
     *
     * @param byteArray
     * @return String
     */
    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; i++) {
            strDigest += byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }


    /**
     * 将字节转换为十六进制字符串
     *
     * @param mByte
     * @return String
     */
    private static String byteToHexStr(byte mByte) {
        char[] Digit = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[2];
        tempArr[0] = Digit[(mByte >>> 4) & 0X0F];
        tempArr[1] = Digit[mByte & 0X0F];
        String s = new String(tempArr);
        return s;
    }

    public static String getEllaPartnerAccessToken() {
        Map<String, Object> param = new HashMap<>(3);
        param.put("grant_type", GRANT_TYPE);
        param.put("appid", "wxca187025bd70cab8");
        param.put("secret", "8ea56b893801ae7b02868f3769e9fe4d");
        String token = HttpConnectUtil.getConnectionJsonResponse(BUSINESS_ACCESS_TOKEN_URL, param, "POST");
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject(token);
        return json.getString("access_token");
    }


    public static String getBusinessAccessToken() {
        Map<String, Object> param = new HashMap<>(3);
        param.put("grant_type", GRANT_TYPE);
        param.put("appid", APPID);
        param.put("secret", SECRET);
        String token = HttpConnectUtil.getConnectionJsonResponse(BUSINESS_ACCESS_TOKEN_URL, param, "POST");
        com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject(token);

        return json.getString("access_token");
    }


    /**
     * 生成notice
     *
     * @return
     */
    public static String buildMessage(String openid, String income, String totalIncome, String type) {
        NoticeMessage message = new NoticeMessage();
        message.setTouser(openid);
        message.setTemplate_id(TEMPLATE_ID);
        message.setUrl(FORWARD_URL);
        message.setData(buildData(income, totalIncome, type));

        return com.alibaba.fastjson.JSONObject.toJSONString(message);
    }

    /**
     * 生成notice
     *
     * @return
     */
    public static String buildMessage(String openid, String templateId, String url, Map<String, KeyNote> data) {
        NoticeMessage message = new NoticeMessage();
        message.setTouser(openid);
        message.setTemplate_id(templateId);
        message.setUrl(url);
        message.setData(data);
        return com.alibaba.fastjson.JSONObject.toJSONString(message);
    }


    /**
     * 构建消息内容
     *
     * @param income
     * @param totalIncome
     * @param type
     * @return
     */
    public static Map buildData(String income, String totalIncome, String type) {
        Map<String, KeyNote> map = new HashMap<>();
        map.put("first", buildFirst(type));
        map.put("keyword1", buildKeynote1());
        map.put("keyword2", buildKeynote2(income));
        map.put("keyword3", buildKeynote3());
        map.put("remark", buildRemark(totalIncome));
        return map;
    }

    public static Map<String, KeyNote> buildData(KeyNote first, KeyNote remark, KeyNote... keyWords) {
        Map<String, KeyNote> map = new HashMap<>();
        map.put("first", first);
        map.put("remark", remark);
        for (int i = 0; i < keyWords.length; i++) {
            map.put("keyword" + (i + 1), keyWords[i]);
        }
        return map;
    }

    /**
     * 消息标题
     *
     * @param type
     * @return
     */
    public static KeyNote buildFirst(String type) {
        KeyNote first = new KeyNote();
        if ("income".equals(type)) {
            first.setValue("您获得了一笔收益");
        } else {
            first.setValue("您今天的收益");
        }

        first.setColor("#173177");
        return first;
    }

    /**
     * @return
     */
    public static KeyNote buildKeynote1() {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue("收入");
        keyNote.setColor("#173177");
        return keyNote;
    }

    /**
     * @param income
     * @return
     */
    public static KeyNote buildKeynote2(String income) {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue(income);
        keyNote.setColor("#173177");
        return keyNote;
    }

    /**
     * @param
     * @return
     */
    public static KeyNote buildKeynote3() {
        KeyNote keyNote = new KeyNote();
        keyNote.setValue(DateUtil.dateFormat(new Date()));
        keyNote.setColor("#173177");
        return keyNote;
    }

    /**
     * @param total
     * @return
     */
    public static KeyNote buildRemark(String total) {
        KeyNote remark = new KeyNote();
        remark.setValue("您的总收益:" + total + "元");
        remark.setColor("#173177");
        return remark;
    }

    /**
     * 获取关注咿啦伙伴的用户列表
     */
    public static void main(String[] args) {
        String accessToken = getEllaPartnerAccessToken();
        String body = HttpConnectUtil.getConnectionFromBody("https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + accessToken, null, "GET");
        System.out.println(body);
    }
}
