package com.ellabook.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.model.*;
import com.constants.BookCodeConstantUtil;
import com.ellabook.entity.ResponseParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by mengxiangchao on 2017/12/6.
 */
public class UploadUtil {
    private final static ResponseParamsUtil responseParamsUtil = new ResponseParamsUtil();
    /*public static final String OSS_BUCKET_ELLABOOK_PUBLIC = "ellabook-public";
    public static final String OSS_KEY_PREFIX_EVENT = "event/";*/
    public static final String OSS_BUCKET_ELLABOOK_PUBLIC = "ellabook-assistant";
    public static final String OSS_KEY_PREFIX_EVENT = "resource/";
    //    public static final String OSS_BUCKET_ELLABOOK_BOOK = "ellabook-book";
    public static final String OSS_BUCKET_ELLABOOK_BOOK = "ellabook-resource";
    //    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_VIDEO = "book-preview-resource-video/";
    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_VIDEO = "video/";
    public static final String OSS_KEY_PREFIX_COURSE_PREVIEW_RESOURCE_VIDEO = "course-video/";//课程预览存放路径
    //    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_IMG = "book-preview-resource-img/";
    public static final String OSS_KEY_PREFIX_BOOK_PREVIEW_RESOURCE_IMG = "img/";
    public static final String OSS_KEY_PREFIX_COURSE_PREVIEW_RESOURCE_IMG = "course-img/";//课程预览存放路径
    public static final Map<String, ProgressEvent> progressEventList = null;

    public String multipartUploadObject(String bucketName, String key, File partFile) {
        String tag = null;
        String uploadId = null;
        int j = 0;
        // 初始化一个OSSClient
        OSSClient client = OSSServer.getInstance();
        ListMultipartUploadsRequest lmur = new ListMultipartUploadsRequest(bucketName);

        // 获取Bucket内所有上传事件
        MultipartUploadListing multipartUploadListing = client.listMultipartUploads(lmur);
        // 新建一个List保存每个分块上传后的ETag和PartNumber
        List<PartETag> partETags = new ArrayList<PartETag>();

        // 遍历所有上传事件  设置UploadId
        for (MultipartUpload multipartUpload : multipartUploadListing.getMultipartUploads()) {
            if (multipartUpload.getKey().equals(key)) {
                uploadId = multipartUpload.getUploadId();
                break;
            }
        }

        if (StringUtils.isEmpty(uploadId)) {
            // 开始Multipart Upload,InitiateMultipartUploadRequest 来指定上传Object的名字和所属Bucket
            InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
            InitiateMultipartUploadResult initiateMultipartUploadResult = client.initiateMultipartUpload(initiateMultipartUploadRequest);
            uploadId = initiateMultipartUploadResult.getUploadId();
        } else {
            ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
            //listParts 方法获取某个上传事件所有已上传的块
            PartListing partListing = client.listParts(listPartsRequest);
            // 遍历所有Part
            for (PartSummary part : partListing.getParts()) {
                partETags.add(new PartETag(part.getPartNumber(), part.getETag()));
                j++;
            }
        }
        // 设置每块为 5M（最小支持5M）
        final int partSize = 1024 * 1024 * 5;

        // 计算分块数目
        int partCount = (int) (partFile.length() / partSize);
        if (partFile.length() % partSize != 0) {
            partCount++;
        }
        try {
            for (int i = j; i < partCount; i++) {
                // 获取文件流
                FileInputStream fis;
                fis = new FileInputStream(partFile);

                // 跳到每个分块的开头
                long skipBytes = partSize * i;
                fis.skip(skipBytes);

                // 计算每个分块的大小
                long size = partSize < partFile.length() - skipBytes ? partSize : partFile.length() - skipBytes;

                // 创建UploadPartRequest，上传分块
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey(key);
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream(fis);
                uploadPartRequest.setPartSize(size);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = client.uploadPart(uploadPartRequest);

                // 将返回的PartETag保存到List中。
                partETags.add(uploadPartResult.getPartETag());

                // 关闭文件
                fis.close();

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        // 完成分块上传
        CompleteMultipartUploadResult completeMultipartUploadResult = client.completeMultipartUpload(completeMultipartUploadRequest);
        // 打印Object的ETag（返回的ETag不是md5.具体是什么不详）
        tag = completeMultipartUploadResult.getETag();
        return tag;
    }

    public static ResponseParams uploadFileBase64(String file, String type, int size, String bucket, String key) throws IOException {
        try {
            if (StringUtils.isBlank(file)) {
                return responseParamsUtil.fail("10000001", "文件不能为空！", "base64格式文件上传");
            } else {
                byte[] b = Base64Util.decodeBase64File(file);
                if (size != 0 && b.length > 1024 * 1024 * size) {
                    return responseParamsUtil.fail("10000002", "文件过大！", "base64格式文件上传");
                }

                InputStream inputStream = new ByteArrayInputStream(b);
                String suffix = "." + file.substring(file.indexOf('/') + 1, file.indexOf(';'));
                if (!StringUtils.isBlank(type) && !type.equals(suffix)) {
                    return responseParamsUtil.fail("10000003", "不支持该文件类型！", "base64格式文件上传");
                }
                key = key + suffix;

                ObjectMetadata meta = new ObjectMetadata();
                meta.setContentLength(b.length);
                OSSServer.getInstance().putObject(bucket, key, inputStream, meta);
                String url = OSSServer.ossUrl(bucket, key).split("\\?")[0];
                return responseParamsUtil.success(BookCodeConstantUtil.SUCCESS_DESCRIBE, "base64格式文件上传", url);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return responseParamsUtil.fail("base64格式文件上传");
        }
    }

    public static ResponseParams uploadFile(MultipartFile file, String type, int size, String bucket, String key) throws IOException {
        try {
            if (null == file) {
                return responseParamsUtil.fail("10000001", "文件不能为空！", "文件上传");
            }
            long fileStreamSize = file.getSize();
            if (size != 0 && fileStreamSize > 1024 * 1024 * size) {
                return responseParamsUtil.fail("10000002", "文件过大！", "文件上传");
            }
            String fileName = file.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            if (!StringUtils.isBlank(type) && !type.equals(suffix)) {
                return responseParamsUtil.fail("10000003", "不支持该文件类型！", "base64格式文件上传");
            }
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(fileStreamSize);
            OSSServer.getInstance().putObject(bucket, key + suffix, file.getInputStream(), meta);
            /*OSSServer.getInstance().putObject(new PutObjectRequest(bucket, key + suffix, file.getInputStream()).withProgressListener(new ProgressListener() {
                @Override
                public void progressChanged(ProgressEvent progressEvent) {
                    progressEventList.put(key+suffix, progressEvent);
                }
            }));*/
            String url = OSSServer.ossUrl(bucket, key + suffix).split("\\?")[0];
            return responseParamsUtil.success(BookCodeConstantUtil.SUCCESS_DESCRIBE, "文件上传", url);
        } catch (Exception e) {
            e.printStackTrace();
            return responseParamsUtil.fail("文件上传");
        }
    }


    public static String uploadAndDeleteFile(String bucket, String filePath, String fileName) {
        File xlsxFile = new File(filePath);
        OSSServer.getInstance().putObject(bucket, fileName, xlsxFile);
        String url = OSSServer.ossUrl(bucket, fileName).split("\\?")[0];
        xlsxFile.delete();
        return url;
    }

}
