package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class URLUtil {
    /**
     * 将URL中的参数转化为map
     *
     * @param url
     * @return
     */
    public static Map<String, Object> getUrlParams(String url) {
        Map<String, Object> map = new HashMap<>(0);
        if (StringUtils.isBlank(url)) {
            return map;
        }
        String[] split = url.split("\\?");
        if (split.length > 1) {
            String[] params = split[1].split("&");
            for (int i = 0; i < params.length; i++) {
                String[] p = params[i].split("=");
                if (p.length == 2) {
                    map.put(p[0], p[1]);
                }
            }
        }
        return map;
    }

    /**
     * 为URL添加参数
     *
     * @param url
     * @param map
     * @return
     */
    public static String addParams(String url, HashMap<Object, Object> map) {
        if (map == null) {
            return url;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = org.apache.commons.lang.StringUtils.substringBeforeLast(s, "&");
        }
        return url + "?" + s;
    }

    public static String getFileName(String url) {
        if (StringUtils.isBlank(url)) {
            return "";
        }
        String urlWithoutParameter = url.split("\\?")[0];
        return urlWithoutParameter.substring(urlWithoutParameter.lastIndexOf("/") + 1, urlWithoutParameter.length());
    }

    public static String getUrlWithoutParameter(String url) {
        if (StringUtils.isBlank(url)) {
            return "";
        }
        return url.split("\\?")[0];
    }

    public static String getFileNameSuffix(String url) {
        String[] split = getFileName(url).split("\\.");
        return split.length > 1 ? split[1] : "";
    }

    public static String getFileNameWithoutSuffix(String url) {
        String fileName = getFileName(url);
        return fileName.split("\\.")[0];
    }


}
