package com.ellabook.util;

import java.util.Arrays;
import java.util.List;

/**
 * @author mengxiangchao@ellabook.cn
 * @date 2018/2/27
 */
public class StringUtil {

    public static boolean equalsAnyStr(String str, String... arrayStr) {
        if (arrayStr == null) {
            return false;
        }
        List<String> list = Arrays.asList(arrayStr);
        return list.contains(str);
    }

    public static String mask(String src, int beginIndex, int endIndex) {
        return mask(src, '*', beginIndex, endIndex);
    }

    public static String mask(String src, char maskCode, int beginIndex, int endIndex) {
        if (beginIndex + 1 >= src.length() || beginIndex >= endIndex) {
            return src;
        }
        StringBuilder sb = new StringBuilder(src.subSequence(0, beginIndex));
        int realEnd = Math.min(endIndex, src.length() - 1);
        while (beginIndex < realEnd) {
            sb.append(maskCode);
            ++beginIndex;
        }
        if (realEnd == endIndex) {
            sb.append(src.substring(realEnd));
        }
        return sb.toString();
    }

    /**
     * 字符串转集合
     *
     * @param strs
     * @return
     */
    public static List<String> stringToList(String strs) {
        String str[] = strs.split(",");
        return Arrays.asList(str);
    }

}
