package com.ellabook.util;


import com.constants.BookCodeConstantUtil;
import com.ellabook.entity.ResponseParams;

import java.io.Serializable;

public class ResponseParamsUtil<T> implements Serializable {

    public ResponseParams success(String message, String remark, T data) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.SYSTEM_SUCCESS, BookCodeConstantUtil.STATUS_SUCCESS, message, remark, data);
        return params;
    }

    public ResponseParams success(String message, String remark) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.SYSTEM_SUCCESS, BookCodeConstantUtil.STATUS_SUCCESS, message, remark, "");
        return params;
    }

    public ResponseParams success(String remark, T data) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.SYSTEM_SUCCESS, BookCodeConstantUtil.STATUS_SUCCESS, BookCodeConstantUtil.SUCCESS_DESCRIBE, remark, data);
        return params;
    }

    public ResponseParams success(String remark) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.SYSTEM_SUCCESS, BookCodeConstantUtil.STATUS_SUCCESS, BookCodeConstantUtil.SUCCESS_DESCRIBE, remark, "");
        return params;
    }

    public ResponseParams fail(String code, String message, String remark) {
        ResponseParams params = new ResponseParams(code, BookCodeConstantUtil.STATUS_FAIL, message, remark);
        return params;
    }

    public ResponseParams fail(String message, String remark) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.STATUS_FAIL, message, "");
        params.setRemark(remark);
        return params;
    }

    public ResponseParams fail(String remark) {
        ResponseParams params = new ResponseParams(BookCodeConstantUtil.STATUS_FAIL, BookCodeConstantUtil.FAIL_DESCRIBE, "");
        params.setRemark(remark);
        return params;
    }

    public ResponseParams errorParams(String message, String remark) {
        ResponseParams params = new ResponseParams();
        params.setCodeAndMessage(BookCodeConstantUtil.ERROR_PARAM_CODE, message);
        params.setRemark(remark);
        return params;
    }
}
