package com.ellabook.util;

import com.ellabook.entity.listenBook.DTO.ResponsePageResultDto;
import com.github.pagehelper.Page;

import java.util.List;

public class ResponsePageResultUtils {

    public static <T extends List> ResponsePageResultDto<T> build(T list) {
        ResponsePageResultDto<T> result = new ResponsePageResultDto<T>();
        if (list == null) {
            return new ResponsePageResultDto<T>();
        }
        if (list instanceof Page) {
            Page<T> page = (Page<T>) list;
            result.setPageNum(page.getPageNum());
            result.setPageSize(page.getPageSize());
            result.setTotal(page.getTotal());
            result.setTotalPage(page.getPages());
            result.setList(list);
        }

        return result;
    }

    /**
     * @param resultList   PageHelper 返回的分页结果集
     * @param responseList 接口返回的分页结果
     */
    public static <T extends List> ResponsePageResultDto<T> build(List resultList, T responseList) {
        ResponsePageResultDto<T> result = new ResponsePageResultDto<T>();
        if (resultList == null) {
            return new ResponsePageResultDto<T>();
        }
        if (resultList instanceof Page) {
            Page<T> page = (Page<T>) resultList;
            result.setPageNum(page.getPageNum());
            result.setPageSize(page.getPageSize());
            result.setTotal(page.getTotal());
            result.setTotalPage(page.getPages());
            result.setList(responseList);
        }
        return result;
    }

}
