package com.ellabook.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.cdn.model.v20180510.PushObjectCacheRequest;
import com.aliyuncs.cdn.model.v20180510.PushObjectCacheResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class OSSServer {

    private static final Logger logger = LoggerFactory
            .getLogger(OSSServer.class);

    /**
     * oss连接配置信息
     **/
    public static String accessKeyId = "wCSYOmYFgJmttmWs";
    public static String accessKeySecret = "QcXJXEXWr59zfvszfFd6AxY5KMnqrb";
    // bucket所在的数据中心域名，以杭州为例
    private static String endpoint = "https://oss-cn-hangzhou.aliyuncs.com";
    private static String bookEndpoint = "https://book.ellabook.cn";
    private static String secretBookEndpoint = "https://res-secret.ellabook.cn";
    private static String storeEndpoint = "https://store.ellabook.cn";
    private static String memberEndpoint = "https://member.ellabook.cn";
    private static String commentEndpoint = "https://comment.ellabook.cn";
    private static String dailyEndpoint = "https://daily.ellabook.cn";
    public static String resEndpoint = "https://res.ellabook.cn";
    public static String projectEndpoint = "https://project.ellabook.cn";
    public static String teachingEndpoint = "https://teach.ellabook.cn";

    public static String regionId = "cn-hangzhou";


    private static String lanEndpoint = "oss-cn-hangzhou-internal.aliyuncs.com";
    private static String lanBookEndpoint = "ellabook-book.oss-cn-hangzhou-internal.aliyuncs.com";
    private static String lanSecretBookEndpoint = "ellabook-book-secert.oss-cn-hangzhou.aliyuncs.com";
    private static String lanStoreEndpoint = "ellabook-store.oss-cn-hangzhou-internal.aliyuncs.com";
    private static String lanMemberEndpoint = "ellabook-member.oss-cn-hangzhou-internal.aliyuncs.com";
    private static String lanCommentEndpoint = "ellabook-comment.oss-cn-hangzhou-internal.aliyuncs.com";
    private static String lanDailyEndpoint = "ellabook-daily.oss-cn-beijing-internal.aliyuncs.com";
    private static String lanResourceEndpoint = "ellabook-resource.oss-cn-hangzhou.aliyuncs.com";
    private static String lanProjectEndpoint = "ellabook-project.oss-cn-hangzhou.aliyuncs.com";
    private static String lanTeachingEndpoint = "ellabook-assistant.oss-cn-hangzhou.aliyuncs.com";


    private static OSSClient ossClient = new OSSClient(endpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient bookossClient = new OSSClient(lanBookEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient secretBookossClient = new OSSClient(lanSecretBookEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient storeossClient = new OSSClient(lanStoreEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient memberossClient = new OSSClient(lanMemberEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient commentossClient = new OSSClient(lanCommentEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient resOssClient = new OSSClient(resEndpoint,
            accessKeyId, accessKeySecret);
    private static OSSClient projectOssClient = new OSSClient(lanProjectEndpoint, accessKeyId, accessKeySecret);

    private static OSSClient teachingOssClient = new OSSClient(lanTeachingEndpoint, accessKeyId, accessKeySecret);

    public static OSSClient getInstance() {
        return ossClient;
    }

    public void uploadAvatar(String bucket, String key, InputStream inputStream, ObjectMetadata meta) {
        PutObjectResult result = ossClient.putObject(bucket, key, inputStream, meta);
    }

    public static String ossUrl(String bucket, String key) {
        Date expires = new Date(System.currentTimeMillis() + 1000 * 3600 * 24 * 3650);
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(bucket, key);
        generatePresignedUrlRequest.setExpiration(expires);
        URL url = null;// ossClient.generatePresignedUrl(generatePresignedUrlRequest);
        String urlstr = "";
        if (bucket.equals("ellabook-book")) {
            url = bookossClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanBookEndpoint, bookEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-book.", "");
        } else if (bucket.equals("ellabook-book-secert")) {
            url = secretBookossClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanSecretBookEndpoint, secretBookEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-book-secert.", "");
        } else if (bucket.equals("ellabook-store")) {
            url = storeossClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanStoreEndpoint, storeEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-store.", "");
        } else if (bucket.equals("ellabook-member")) {
            url = memberossClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanMemberEndpoint, memberEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-member.", "");
        } else if (bucket.equals("ellabook-resource")) {
            url = resOssClient
                    .generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanResourceEndpoint,
                    resEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-resource.", "");
        } else if (bucket.equals("ellabook-project")) {
            url = projectOssClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanProjectEndpoint, projectEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-project.", "");
        } else if (bucket.equals("ellabook-assistant")) {
            url = teachingOssClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanTeachingEndpoint, teachingEndpoint);
            urlstr = urlstr.replaceAll("http[s]?://ellabook-assistant.", "");
        } else {
            url = ossClient.generatePresignedUrl(generatePresignedUrlRequest);
            urlstr = url.toString().replaceAll(lanEndpoint, endpoint);
        }
        return urlstr;
    }

    public static boolean del(String bucket, String key) {
        try {
            ossClient.deleteObject(bucket, key);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static long getObjectLength(String url) {
        long contentLength = 0;
        try {
            contentLength = OSSServer.getInstance().getObject(new URL(url), null).getObjectMetadata().getContentLength();
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return contentLength;
    }


    public static void main(String[] args) throws MalformedURLException {
//        long objectLength = getObjectLength("http://book.ellabook.cn/099c4a7e46984b89b0aced962aa6d8612");
//        System.out.println(objectLength);
        String s = DigestUtils.md5DigestAsHex("http://book.ellabook.cn/4070b0f39c014833992a7da8a9e117530".getBytes());
        System.out.println(s);
    }

    public String uploadRedeemCode(String bucket, String key, File file) {
        PutObjectResult result = ossClient.putObject(bucket, key, file);
        return OSSServer.ossUrl(bucket, key);
    }

    public Boolean checkUpDuplicateFileName(String bucket, String objectName) {
        boolean found = ossClient.doesObjectExist(bucket, objectName);
        return found;
    }

    public static void pushObjectCache(String objectPath) {
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        IAcsClient client = new DefaultAcsClient(profile);

        PushObjectCacheRequest request = new PushObjectCacheRequest();
        request.setRegionId(regionId);
        request.setObjectPath(objectPath);
        String PushObjectCacheRes = "";

        try {
            PushObjectCacheResponse response = client.getAcsResponse(request);
            PushObjectCacheRes = new Gson().toJson(response);
            System.out.println(new Gson().toJson(response));
        } catch (ServerException e) {
            e.printStackTrace();
        } catch (ClientException e) {
            System.out.println("ErrCode:" + e.getErrCode());
            System.out.println("ErrMsg:" + e.getErrMsg());
            System.out.println("RequestId:" + e.getRequestId());
        }

    }
}
