package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ListUtil {

    public static List<String> removeListAll(List<String> source, List<String> target) {
        Collection exists = new ArrayList<String>(source);
        Collection notexists = new ArrayList<String>(target);
        exists.removeAll(notexists);
        List<String> list = new ArrayList<String>(exists);
        return list;
    }

    public static List<String> StrTransitionList(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        String[] strs = str.split(",");
        if (strs == null && strs.length <= 0) {
            return null;
        }
        return Arrays.asList(strs);
    }

    /**
     * 分组计算，避免大量数据
     */
    public static <T> List<List<T>> group(List<T> list, int maxSize) {
        int size = list.size();
        int i = 0;
        List<List<T>> groupLists = new ArrayList<>();
        if (size <= maxSize) {
            groupLists.add(list);
            return groupLists;
        }

        for (; i + maxSize < size; i = i + maxSize) {
            groupLists.add(list.subList(i, i + maxSize));
        }
        groupLists.add(list.subList(i, size));// [)
        return groupLists;
    }
}
