package com.ellabook.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.constants.BookCodeConstantUtil;
import com.ellabook.entity.PublicParam;
import com.ellabook.entity.RequestParams;
import com.ellabook.exception.EllaBookException;
import com.ellabook.util.datx.City;
import com.ellabook.util.datx.IPv4FormatException;
import org.apache.commons.lang.StringUtils;
import org.junit.Test;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.constants.LanguageConstant.*;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class JsonUtil {

    /**
     * 校验json串是否合法
     *
     * @param params
     * @return
     */
    public static String getContent(RequestParams params) {
        String content = params.getParams().get("content");
        try {
            content = StringUtils.isBlank(content) ? "{}" : content;
            JSONObject.parseObject(content);
        } catch (Exception e1) {
            try {
                content = content.equals("{}") ? "[]" : content;
                JSONObject.parseArray(content);
            } catch (Exception e2) {
                throw new EllaBookException(BookCodeConstantUtil.ILLEGAL_JSON_STRING_DESC + content);
            }
        }
        return content;
    }

    public static String getContentByPutUidAndVersionAndChannelCode(RequestParams params) {
        String content = JsonUtil.getContent(params);
        JSONObject obj = JSONObject.parseObject(content);
        String uid = params.getParams().get("uid");
        String channelCode = params.getParams().get("channelCode");
        String v = params.getParams().get("v");
        String platform = params.getParams().get("platform");
        String countryCode = params.getParams().get("countryCode");
        String snCode = params.getParams().get("snCode");
        String language = params.getParams().get("language");
        String siteCode = params.getSiteCode();
        if (StringUtils.isBlank(obj.getString("uid"))) {
            obj.put("uid", uid);
        }
        if (StringUtils.isBlank(obj.getString("channelCode"))) {
            obj.put("channelCode", channelCode);
        }
        if (StringUtils.isBlank(obj.getString("version"))) {
            obj.put("version", v);
        }
        if (StringUtils.isBlank(obj.getString("platform"))) {
            obj.put("platform", platform);
        }
        if (StringUtils.isBlank(obj.getString("countryCode"))) {
            obj.put("countryCode", countryCode);
        }
        if (StringUtils.isBlank(obj.getString("snCode"))) {
            obj.put("snCode", snCode);
        }
        if (StringUtils.isBlank(obj.getString("language"))) {
            obj.put("language", language);
        }
        //往公参数增加siteCode
        if (StringUtils.isBlank(obj.getString("siteCode"))) {
            obj.put("siteCode", siteCode);
        }
        PublicParam publicParam = getPublicParam(params);
        obj.put("publicParam", publicParam);

        return JSONObject.toJSONString(obj);
    }

    public static String getContentContainsPublicParam(RequestParams params) {
        JSONObject obj = new JSONObject();
        String content = getContent(params);
        PublicParam publicParam = getPublicParam(params);
        try {
            obj = JSONObject.parseObject(content);
        } catch (Exception e) {
            try {
                content = content.equals("{}") ? "[]" : content;
                JSONArray jsonArray = JSONObject.parseArray(content);
                obj.put("list", jsonArray);
            } catch (Exception e2) {
                throw new EllaBookException(BookCodeConstantUtil.ILLEGAL_JSON_STRING_DESC + content);
            }
        }
        publicParam.setCountry(countryConvert(params.getIp()));
        publicParam.setRegion(getRegion(params.getIp()));
        obj.put("ip", params.getIp());
        obj.put("publicParam", publicParam);
        obj.put("siteCode", StringUtils.isNotBlank(publicParam.getSiteCode()) ? publicParam.getSiteCode() : params.getSiteCode());
        return JSONObject.toJSONString(obj);
    }

    public static PublicParam getPublicParam(RequestParams params) {
        PublicParam publicParam = new PublicParam();
        Map<String, String> map = params.getParams();
        publicParam.setMethod(map.get("method"));

        publicParam.setAppKey(map.get("app_key"));
        publicParam.setFormat(map.get("format"));
        publicParam.setSign(map.get("sign"));
        publicParam.setSignMethod(map.get("sign_method"));
        publicParam.setTimestamp(map.get("timestamp"));

        publicParam.setToken(map.get("token"));
        publicParam.setUid(map.get("uid"));
        publicParam.setVersion(map.get("v"));
        publicParam.setChannelCode(map.get("channelCode"));
        publicParam.setPlatform(map.get("platform"));
        publicParam.setProduct(map.get("product"));
        publicParam.setContent(map.get("content"));
        String countryCode = map.get("countryCode");
        publicParam.setSnCode(map.get("snCode"));
        publicParam.setLanguage(map.get("language"));
        publicParam.setSiteCode(params.getSiteCode());
        //校验乱码
        countryCode = countryCodeConvert(countryCode);
        publicParam.setCountryCode(countryCode);
        return publicParam;
    }

    /**
     * 国家编码特殊字符处理-GET请求和POST请求
     *
     * @param countryCode
     * @return
     */
    public static String countryCodeConvert(String countryCode) {
        try {
            if (StringUtils.isNotBlank(countryCode)) {
                countryCode = URLEncoder.encode(countryCode, "UTF-8");
                if (!countryCode.startsWith("+")) {
                    countryCode = URLDecoder.decode(countryCode, "UTF-8");
                }
            } else {
                countryCode = "+86";
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            countryCode = "+86";
        }
        return countryCode;
    }

    @Test
    public void main() {
        String cityCode = countryConvert("49.246.255.255");
        System.out.println(cityCode);
    }

    /**
     * 中间隐藏 前2位和2位显示
     *
     * @param number
     * @return
     */
    public static String numberConvert(String number) {
        if (number.length() < 4) {
            return number;
        } else {
            Pattern p2 = Pattern.compile("[0-9]"); // 只允数字
            Matcher m = p2.matcher(number.substring(2, number.length() - 2));
            String trim = m.replaceAll("*");
            return number.substring(0, 2) + trim + number.substring(number.length() - 2, number.length());
        }
    }

    /**
     * 国家编码特殊字符处理-GET请求和POST请求
     *
     * @param ip
     * @return
     */
    public static String countryConvert(String ip) {
        String country = CN;
        String region = "";
        try {
//            City cityUtil = City.newInstance(DatxConfig.getPath());
            City cityUtil = City.newInstance("17monipdb.datx");
            String[] addressNameList = cityUtil.find(ip);
            if (addressNameList.length >= 1) {
                country = getCountryMap().get(addressNameList[0]);
                if (addressNameList.length >= 2) {
                    region = addressNameList[1];
                }
                if (StringUtils.isNotBlank(country)) {
                    if (StringUtils.equalsIgnoreCase(country, CN)) {
                        country = StringUtils.isNotBlank(getRegionMap().get(region)) ? getRegionMap().get(region) : CN;
                    }
                } else {
                    country = CN;
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (IPv4FormatException e) {
            e.printStackTrace();
        }
        return country;
    }

    public static String getRegion(String ip) {
        String region = null;
        try {
            City cityUtil = City.newInstance("17monipdb.datx");
            String[] addressNameList = cityUtil.find(ip);
            if (addressNameList.length >= 1) {
                region = addressNameList[1];
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (IPv4FormatException e) {
            e.printStackTrace();
        }
        return region;
    }


    public static String getKidsToolsContent(RequestParams params) {
        String content = JsonUtil.getContent(params);
        String channelCode = params.getParams().get("channelCode");
        JSONObject obj = JSONObject.parseObject(content);
        obj.put("channelCode", channelCode);
        content = obj.toJSONString();
        return content;
    }


    /**
     * 将对象中的日期按照（yyyy-MM-dd HH:mm:ss）格式化
     *
     * @param obj
     * @return 返回值类型为JSONObject
     */
    public static JSONObject dateFormat(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat(obj, JSONObject.DEFFAULT_DATE_FORMAT, SerializerFeature.WriteMapNullValue);
        return JSONObject.parseObject(s);
    }

    /**
     * 将对象中的日期按照（yyyy-MM-dd HH:mm:ss）格式化
     *
     * @param obj
     * @return 返回值类型为JSONArray
     */
    public static JSONArray dateFormatArray(Object obj) {
        String s = JSONObject.toJSONStringWithDateFormat(obj, JSONObject.DEFFAULT_DATE_FORMAT, SerializerFeature.WriteMapNullValue);
        return JSONObject.parseArray(s);
    }

    /**
     * 格式化输出json
     *
     * @param json
     */
    public static String output(Object json) {
        String start = "  ";
        // 先将json对象转化为string对象
        String jsonStr = JSONObject.toJSONString(json, SerializerFeature.WriteMapNullValue);
        // 用户标记层级
        int level = 0;
        // 新建stringbuffer对象，用户接收转化好的string字符串
        StringBuffer jsonResultStr = new StringBuffer();
        // 循环遍历每一个字符
        for (int i = 0; i < jsonStr.length(); i++) {
            // 获取当前字符
            char piece = jsonStr.charAt(i);
            // 如果上一个字符是断行，则在本行开始按照level数值添加标记符，排除第一行
            if (i != 0 && '\n' == jsonResultStr.charAt(jsonResultStr.length() - 1)) {
                for (int k = 0; k < level; k++) {
                    jsonResultStr.append(start);
                }
            }
            switch (piece) {
                case '{':
                case '[':
                    // 如果字符是{或者[，则断行，level加1
                    jsonResultStr.append(piece + "\n");
                    level++;
                    break;
                case ',':
                    // 如果是“,”，则断行
                    jsonResultStr.append(piece + "\n");
                    break;
                case '}':
                case ']':
                    // 如果是}或者]，则断行，level减1
                    jsonResultStr.append("\n");
                    level--;
                    for (int k = 0; k < level; k++) {
                        jsonResultStr.append(start);
                    }
                    jsonResultStr.append(piece);
                    break;
                default:
                    jsonResultStr.append(piece);
                    break;
            }
        }
//        System.out.println(jsonResultStr);
        return jsonResultStr.toString();
    }

    /**
     * 国家和地区
     *
     * @return
     */
    public static Map<String, String> getCountryMap() {
        Map<String, String> map = new HashMap<>();
        map.put("中国", CN);
        map.put("美国", US);
        map.put("阿布哈兹", US);
        map.put("阿富汗", US);
        map.put("阿尔巴尼亚", US);
        map.put("阿尔及利亚", US);
        map.put("安道尔", US);
        map.put("安哥拉", US);
        map.put("安提瓜和巴布达", US);
        map.put("阿根廷", US);
        map.put("亚美尼亚", US);
        map.put("澳大利亚", US);
        map.put("奥地利", US);
        map.put("阿塞拜疆", US);
        map.put("巴哈马", US);
        map.put("巴林", US);
        map.put("孟加拉国", US);
        map.put("巴巴多斯", US);
        map.put("白俄罗斯", US);
        map.put("比利时", US);
        map.put("伯利兹", US);
        map.put("贝宁", US);
        map.put("不丹", US);
        map.put("玻利维亚", US);
        map.put("波黑", US);
        map.put("博茨瓦纳", US);
        map.put("巴西", US);
        map.put("文莱", US);
        map.put("保加利亚", US);
        map.put("布基纳法索", US);
        map.put("布隆迪", US);
        map.put("柬埔寨", US);
        map.put("喀麦隆", US);
        map.put("加拿大", US);
        map.put("佛得角", US);
        map.put("加泰罗尼亚", US);
        map.put("中非共和国", US);
        map.put("乍得", US);
        map.put("智利", US);
        map.put("哥伦比亚", US);
        map.put("科摩罗", US);
        map.put("刚果共和国", US);
        map.put("刚果民主共和国", US);
        map.put("库克群岛", US);
        map.put("哥斯达黎加", US);
        map.put("科特迪瓦", US);
        map.put("克罗地亚", US);
        map.put("古巴", US);
        map.put("塞浦路斯", US);
        map.put("捷克", US);
        map.put("丹麦", US);
        map.put("吉布提", US);
        map.put("顿涅茨克", US);
        map.put("多米尼克", US);
        map.put("多米尼加", US);
        map.put("厄瓜多尔", US);
        map.put("埃及", US);
        map.put("萨尔瓦多", US);
        map.put("赤道几内亚", US);
        map.put("厄立特里亚", US);
        map.put("爱沙尼亚", US);
        map.put("埃塞俄比亚", US);
        map.put("斐济", US);
        map.put("芬兰", US);
        map.put("法国", US);
        map.put("加蓬", US);
        map.put("冈比亚", US);
        map.put("格鲁吉亚", US);
        map.put("德国", US);
        map.put("加纳", US);
        map.put("希腊", US);
        map.put("格林纳达", US);
        map.put("危地马拉", US);
        map.put("几内亚", US);
        map.put("几内亚比绍", US);
        map.put("圭亚那", US);
        map.put("海地", US);
        map.put("洪都拉斯", US);
        map.put("匈牙利", US);
        map.put("冰岛", US);
        map.put("印度", US);
        map.put("印度尼西亚", US);
        map.put("伊朗", US);
        map.put("伊拉克", US);
        map.put("爱尔兰", US);
        map.put("以色列", US);
        map.put("意大利", US);
        map.put("牙买加", US);
        map.put("日本", US);
        map.put("约旦", US);
        map.put("哈萨克斯坦", US);
        map.put("肯尼亚", US);
        map.put("基里巴斯", US);
        map.put("韩国", US);
        map.put("科索沃", US);
        map.put("科威特", US);
        map.put("吉尔吉斯斯坦", US);
        map.put("老挝", US);
        map.put("拉脱维亚", US);
        map.put("黎巴嫩", US);
        map.put("莱索托", US);
        map.put("利比里亚", US);
        map.put("利比亚", US);
        map.put("列支敦士登", US);
        map.put("立陶宛", US);
        map.put("卢森堡", US);
        map.put("马达加斯加", US);
        map.put("马拉维", US);
        map.put("马来西亚", US);
        map.put("马尔代夫", US);
        map.put("马耳他骑士团", US);
        map.put("马里", US);
        map.put("马耳他", US);
        map.put("马绍尔群岛", US);
        map.put("毛里塔尼亚", US);
        map.put("毛里求斯", US);
        map.put("墨西哥", US);
        map.put("密克罗尼西亚联邦", US);
        map.put("摩尔多瓦", US);
        map.put("摩纳哥", US);
        map.put("蒙古国", US);
        map.put("黑山", US);
        map.put("摩洛哥", US);
        map.put("莫桑比克", US);
        map.put("缅甸", US);
        map.put("纳戈尔诺-卡拉巴赫", US);
        map.put("纳米比亚", US);
        map.put("瑙鲁", US);
        map.put("尼泊尔", US);
        map.put("荷兰", US);
        map.put("新西兰", US);
        map.put("尼加拉瓜", US);
        map.put("尼日尔", US);
        map.put("尼日利亚", US);
        map.put("纽埃（新西兰）", US);
        map.put("北塞浦路斯", US);
        map.put("北马其顿", US);
        map.put("挪威", US);
        map.put("阿曼", US);
        map.put("巴基斯坦", US);
        map.put("帕劳", US);
        map.put("巴勒斯坦", US);
        map.put("巴拿马", US);
        map.put("巴布亚新几内亚", US);
        map.put("巴拉圭", US);
        map.put("朝鲜", US);
        map.put("秘鲁", US);
        map.put("菲律宾", US);
        map.put("波兰", US);
        map.put("葡萄牙", US);
        map.put("德涅斯特河沿岸", US);
        map.put("邦特兰", US);
        map.put("罗马尼亚", US);
        map.put("俄罗斯", US);
        map.put("卢旺达", US);
        map.put("卡塔尔", US);
        map.put("圣基茨和尼维斯", US);
        map.put("圣卢西亚", US);
        map.put("圣文森特和格林纳丁斯", US);
        map.put("萨摩亚", US);
        map.put("圣马力诺", US);
        map.put("圣多美和普林西比", US);
        map.put("沙特阿拉伯", US);
        map.put("塞内加尔", US);
        map.put("塞尔维亚", US);
        map.put("塞舌尔", US);
        map.put("塞拉利昂", US);
        map.put("新加坡", US);
        map.put("斯洛伐克", US);
        map.put("斯洛文尼亚", US);
        map.put("所罗门群岛", US);
        map.put("索马里", US);
        map.put("索马里兰", US);
        map.put("南非", US);
        map.put("南奥塞梯", US);
        map.put("南苏丹", US);
        map.put("西班牙", US);
        map.put("斯里兰卡", US);
        map.put("苏丹", US);
        map.put("苏里南", US);
        map.put("斯威士兰", US);
        map.put("瑞典", US);
        map.put("瑞士", US);
        map.put("叙利亚", US);
        map.put("塔吉克斯坦", US);
        map.put("坦桑尼亚", US);
        map.put("泰国", US);
        map.put("东帝汶", US);
        map.put("多哥", US);
        map.put("汤加", US);
        map.put("特立尼达和多巴哥", US);
        map.put("突尼斯", US);
        map.put("土耳其", US);
        map.put("土库曼斯坦", US);
        map.put("图瓦卢", US);
        map.put("乌干达", US);
        map.put("乌克兰", US);
        map.put("阿联酋", US);
        map.put("英国", US);
        map.put("乌拉圭", US);
        map.put("乌兹别克斯坦", US);
        map.put("瓦努阿图", US);
        map.put("梵蒂冈", US);
        map.put("委内瑞拉", US);
        map.put("越南", US);
        map.put("西撒哈拉", US);
        map.put("也门", US);
        map.put("赞比亚", US);
        map.put("津巴布韦", US);
        return map;
    }

    public static Map<String, String> getRegionMap() {
        Map<String, String> map = new HashMap<>();
        map.put("香港", ZH_HK);
        map.put("澳门", ZH_MC);
        map.put("台湾", ZH_TW);
        return map;
    }
}