package com.ellabook.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.ellabook.entity.home.ExcelFile;
import com.ellabook.entity.home.ExcelSheet;
import com.ellabook.errorCode.HomeErrorCode;
import com.ellabook.exception.EllaBookException;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;


public class ExcelUtil {

    /**
     * 创建excel文件
     *
     * @param @param  filePath			生成路径
     * @param @param  excelFile			EXCEL文件对象
     * @param @return
     * @return boolean
     * @throws
     * @Title: createExcelFile
     */
    public static boolean createExcelFile(String filePath, ExcelFile excelFile) {

        FileOutputStream os;

        try {
            os = new FileOutputStream(filePath);

            XSSFWorkbook workbook = new XSSFWorkbook();

            for (int i = 0; i < excelFile.getSize(); i++) {
                ExcelSheet excelsheet = excelFile.get(i);
                List<Map<String, Object>> content = excelsheet.getContent();
                Map<String, Object> title = excelsheet.getTitle();

                XSSFSheet sheet = workbook.createSheet(excelsheet.getSheetName());
                XSSFRow row = sheet.createRow(0);

                int colNum = 0;
                for (String titleKey : title.keySet()) {
                    row.createCell(colNum++).setCellValue(title.get(titleKey).toString());
                }

                int rouNum = 1;
                for (Map<String, Object> rowMap : content) {
                    row = sheet.createRow(rouNum++);
                    colNum = 0;
                    for (String key : title.keySet()) {
                        row.createCell(colNum++).setCellValue(rowMap.get(key).toString());
                    }
                }
            }
            workbook.write(os);

            os.flush();
            os.close();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(HomeErrorCode.FILE_NOT_EXISTS_DESC);
        } catch (IOException e) {
            throw new RuntimeException(HomeErrorCode.FILE_CREATE_FAILED_DESC);
        }

        return true;
    }
}
