package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;

import com.ellabook.enums.IdEnum;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Random;

/**
 * Created by xixiaoyi
 * on 2017/9/28
 */
public class CoreUtil {

    /**
     * 通用core生成 ，年月日时分秒毫秒
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore(String coreFirstCharacter) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        StringBuffer str = new StringBuffer(coreFirstCharacter);
        str.append(format.format(date));
        return str.toString();
    }

    /**
     * 通用core生成 ，年月日时分秒毫秒+随机数
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore(String coreFirstCharacter, int numOfRandom) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        StringBuffer str = new StringBuffer(coreFirstCharacter);
        str.append(format.format(date));
        String random = create(numOfRandom);
        str.append(random);
        return str.toString();
    }

    public static String createCommonsCore(IdEnum ie) {
        Objects.requireNonNull(ie, "ID业务类型不能为空！");
        return createCommonsCore(ie.getPrefix(), ie.getRandomNum());
    }

    /**
     * 生成n位随机数
     *
     * @param numOfRandom
     * @return
     */
    public static String create(int numOfRandom) {
        StringBuffer str = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < numOfRandom; i++) {
            str.append(random.nextInt(10) + "");
        }
        return str.toString();
    }

    /**
     * 通用core生成 ，年月日+时分秒毫秒（32位）+随机数
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore32(String coreFirstCharacter, int numOfRandom) {
        return createCommonsCore32(coreFirstCharacter, numOfRandom, 0);
    }

    /**
     * 通用core生成 ，年月日+时分秒毫秒（32位）+随机数
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore32(String coreFirstCharacter, int numOfRandom, int incr) {
        Date date = new Date();
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat formatTime = new SimpleDateFormat("HHmmssSSS");
        StringBuffer str = new StringBuffer(coreFirstCharacter);
        str.append(formatDate.format(date));
        str.append(Base32Util.encode32(Long.parseLong(formatTime.format(date)) + 100000000 + incr));
        String random = create(numOfRandom);
        str.append(random);
        return str.toString();
    }

    public static String getAppointDigitsDecimal(String decimal, int digits) {
        BigDecimal bd = new BigDecimal(decimal);
        return bd.setScale(digits, BigDecimal.ROUND_HALF_UP).toString();
    }

    public static int compareVersion(String version1, String version2) {
        version1 = StringUtils.isBlank(version1) ? "1.0" : version1;
        version2 = StringUtils.isBlank(version2) ? "1.0" : version2;
        String[] versionArray1 = version1.split("\\.");//注意此处为正则匹配，不能用"."；
        String[] versionArray2 = version2.split("\\.");
        int idx = 0;
        int minLength = Math.min(versionArray1.length, versionArray2.length);//取最小长度值
        int diff = 0;
        while (idx < minLength
                && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0//先比较长度
                && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0) {//再比较字符
            ++idx;
        }
        //如果已经分出大小，则直接返回，如果未分出大小，则再比较位数，有子版本的为大；
        diff = (diff != 0) ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    public static void main(String[] args) throws Exception {
        String code = "2020081910435566703";
        byte[] bytes = code.getBytes();
        for (int i = 0; i < 14; i++) {
            System.out.println(createCommonsCore("U", 4));
        }
//        System.out.println(compareVersion("2.0.8","2.0.6"));
    }

}
