package com.ellabook.template;

import org.jeecgframework.poi.excel.annotation.Excel;

import javax.validation.constraints.NotNull;

/**
 * 教师导入导出的excel模板
 *
 * @author LiBin
 **/
public class TeacherTemplate {

    @NotNull(message = "不可为空")
    @Excel(name = "行号", orderNum = "1", isImportField = "rowNum")
    private int rowNum;

    @NotNull(message = "不可为空")
    @Excel(name = "入学年份", orderNum = "2", isImportField = "enrolYear")
    private String enrolYear;

    @NotNull(message = "不可为空")
    @Excel(name = "年级", orderNum = "3", isImportField = "gradeName")
    private String gradeName;

    @NotNull(message = "不可为空")
    @Excel(name = "班级名称", orderNum = "4", isImportField = "className")
    private String className;

    @NotNull(message = "不可为空")
    @Excel(name = "老师1姓名", orderNum = "5", isImportField = "teacher1Name")
    private String teacher1Name;

    @NotNull(message = "不可为空")
    @Excel(name = "老师1手机", orderNum = "6", isImportField = "phone1", width = 20)
    private String phone1;

    @Excel(name = "老师2姓名", orderNum = "7", isImportField = "teacher2Name")
    private String teacher2Name;

    @Excel(name = "老师2手机", orderNum = "8", isImportField = "phone2", width = 20)
    private String phone2;

    @Excel(name = "老师3姓名", orderNum = "9", isImportField = "teacher3Name")
    private String teacher3Name;

    @Excel(name = "老师3手机", orderNum = "10", isImportField = "phone3", width = 20)
    private String phone3;

    public String getEnrolYear() {
        return enrolYear;
    }

    public void setEnrolYear(String enrolYear) {
        this.enrolYear = enrolYear;
    }

    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTeacher1Name() {
        return teacher1Name;
    }

    public void setTeacher1Name(String teacher1Name) {
        this.teacher1Name = teacher1Name;
    }

    public String getPhone1() {
        return phone1;
    }

    public void setPhone1(String phone1) {
        this.phone1 = phone1;
    }

    public String getTeacher2Name() {
        return teacher2Name;
    }

    public void setTeacher2Name(String teacher2Name) {
        this.teacher2Name = teacher2Name;
    }

    public String getPhone2() {
        return phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public String getTeacher3Name() {
        return teacher3Name;
    }

    public void setTeacher3Name(String teacher3Name) {
        this.teacher3Name = teacher3Name;
    }

    public String getPhone3() {
        return phone3;
    }

    public void setPhone3(String phone3) {
        this.phone3 = phone3;
    }

    public int getRowNum() {
        return rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public static TeacherTemplate getDefault() {
        TeacherTemplate template = new TeacherTemplate();
        template.setRowNum(1);
        template.setEnrolYear("2018");
        template.setGradeName("大班");
        template.setClassName("大一班");
        template.setTeacher1Name("李老师");
        template.setTeacher2Name("陈老师");
        template.setTeacher3Name("王老师");
        template.setPhone1("131********");
        template.setPhone2("132********");
        template.setPhone3("133********");
        return template;
    }

    @Override
    public String toString() {
        return "TeacherTemplate{" +
                "rowNum=" + rowNum +
                ", enrolYear='" + enrolYear + '\'' +
                ", gradeName='" + gradeName + '\'' +
                ", className='" + className + '\'' +
                ", teacher1Name='" + teacher1Name + '\'' +
                ", phone1='" + phone1 + '\'' +
                ", teacher2Name='" + teacher2Name + '\'' +
                ", phone2='" + phone2 + '\'' +
                ", teacher3Name='" + teacher3Name + '\'' +
                ", phone3='" + phone3 + '\'' +
                '}';
    }
}
